/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;

public class TimLoader {
    private final TContext context;
    private final TMemory global = new TMemoryGlobal();

    public TimLoader(ImportedFiles importedFiles, Defines defines) {
        this.context = new TContext(importedFiles, defines);
    }

    public List<StringLocated> load(List<StringLocated> input) {
        for (StringLocated s : input) {
            if (s.getPreprocessorError() == null) continue;
            return new ArrayList<StringLocated>(input);
        }
        for (StringLocated s : input) {
            TLineType type = TLineType.getFromLine(s.getStringTrimmed());
            CommandExecutionResult exe = this.context.executeOneLine(this.global, type, s, null);
            if (exe.isOk()) continue;
            return this.context.getResultWithError(s.withErrorPreprocessor(exe.getError()));
        }
        return this.context.getResult();
    }
}

