/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;

public class Trie {
    private final Map<Character, Trie> brothers = new HashMap<Character, Trie>();
    private boolean terminalWord = false;

    public void add(String s) {
        Trie.add(this, s);
    }

    private static void add(Trie current, String s) {
        if (s.length() == 0) {
            throw new UnsupportedOperationException();
        }
        while (s.length() > 0) {
            Character added = Character.valueOf(s.charAt(0));
            Trie child = current.getOrCreate(added);
            if ((s = s.substring(1)).length() == 0) {
                child.terminalWord = true;
            }
            current = child;
        }
    }

    private Trie getOrCreate(Character added) {
        Trie result = this.brothers.get(added);
        if (result == null) {
            result = new Trie();
            this.brothers.put(added, result);
        }
        return result;
    }

    public String getLonguestMatchStartingIn(String s) {
        return Trie.getLonguestMatchStartingIn(this, s);
    }

    private static String getLonguestMatchStartingIn(Trie current, String s) {
        StringBuilder result = new StringBuilder();
        while (current != null) {
            if (s.length() == 0) {
                if (current.terminalWord) {
                    return result.toString();
                }
                return "";
            }
            Trie child = current.brothers.get(Character.valueOf(s.charAt(0)));
            if (child == null) {
                if (current.terminalWord) {
                    return result.toString();
                }
                return "";
            }
            result.append(s.charAt(0));
            current = child;
            s = s.substring(1);
        }
        return "";
    }
}

