/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandClock
extends SingleLineCommand2<TimingDiagram> {
    public CommandClock() {
        super(CommandClock.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(clock)[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PERIOD", "[%s]+with[%s]+period[%s]+([0-9]+)"), new RegexOptional((IRegex)new RegexLeaf("PULSE", "[%s]+pulse[%s]+([0-9]+)")), new RegexLeaf("$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("CODE", 0);
        int period = Integer.parseInt(arg.get("PERIOD", 0));
        String pulseString = arg.get("PULSE", 0);
        int pulse = 0;
        if (pulseString != null) {
            pulse = Integer.parseInt(pulseString);
        }
        return diagram.createClock(code, code, period, pulse);
    }
}

