/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.comp.Slot;

public class SlotSet
implements Iterable<Slot> {
    private final List<Slot> all = new ArrayList<Slot>();

    public SlotSet filter(double start, double end) {
        SlotSet result = new SlotSet();
        for (Slot slot : this.all) {
            Slot intersec = slot.intersect(start, end);
            if (intersec == null) continue;
            result.all.add(intersec);
        }
        return result;
    }

    public void addAll(SlotSet other) {
        this.all.addAll(other.all);
    }

    public void addSlot(double start, double end) {
        ArrayList<Slot> collisions = new ArrayList<Slot>();
        Slot newSlot = new Slot(start, end);
        Iterator<Slot> it = this.all.iterator();
        while (it.hasNext()) {
            Slot s = it.next();
            if (!s.intersect(newSlot)) continue;
            it.remove();
            collisions.add(s);
        }
        for (Slot s : collisions) {
            newSlot = newSlot.merge(s);
        }
        this.all.add(newSlot);
    }

    public SlotSet smaller(double margin) {
        SlotSet result = new SlotSet();
        for (Slot sl : this.all) {
            if (sl.size() <= 2.0 * margin) continue;
            result.addSlot(sl.getStart() + margin, sl.getEnd() - margin);
        }
        return result;
    }

    public String toString() {
        return this.all.toString();
    }

    public List<Slot> getSlots() {
        return Collections.unmodifiableList(this.all);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.getSlots().iterator();
    }

    public SlotSet reverse() {
        SlotSet result = new SlotSet();
        Collections.sort(this.all);
        Slot last = null;
        for (Slot slot : this.all) {
            if (last != null) {
                result.addSlot(last.getEnd(), slot.getStart());
            }
            last = slot;
        }
        return result;
    }

    public void drawDebugX(UGraphic ug, double size) {
        for (Slot slot : this.all) {
            URectangle rect = new URectangle(slot.getEnd() - slot.getStart(), size);
            ug.apply(new UTranslate(slot.getStart(), 0.0)).draw(rect);
        }
    }
}

