/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.FoxSignature;

public final class StringLocated {
    private final String s;
    private final LineLocation location;
    private final String preprocessorError;
    private StringLocated trimmed;
    private long fox = -1L;

    public StringLocated(String s, LineLocation location) {
        this(s, location, null);
    }

    public String toString() {
        return this.s;
    }

    public StringLocated(String s, LineLocation location, String preprocessorError) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        this.s = s;
        this.location = location;
        this.preprocessorError = preprocessorError;
    }

    public StringLocated withErrorPreprocessor(String preprocessorError) {
        return new StringLocated(this.s, this.location, preprocessorError);
    }

    public StringLocated sub(int start, int end) {
        return new StringLocated(this.getString().substring(start, end), this.getLocation(), this.getPreprocessorError());
    }

    public StringLocated getTrimmed() {
        if (this.trimmed == null) {
            this.trimmed = new StringLocated(StringUtils.trin(this.getString()), this.location, this.preprocessorError);
            this.trimmed.fox = this.fox;
            this.trimmed.trimmed = this.trimmed;
        }
        return this.trimmed;
    }

    public StringLocated removeInnerComment() {
        int idx;
        String string = this.s.toString();
        String trim = string.replace('\t', ' ').trim();
        if (trim.startsWith("/'") && (idx = string.indexOf("'/")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(idx + 2, this.s.length())), this.location, this.preprocessorError);
        }
        if (trim.endsWith("'/") && (idx = string.lastIndexOf("/'")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(0, idx)), this.location, this.preprocessorError);
        }
        if (trim.contains("/'''") && trim.contains("'''/")) {
            return new StringLocated(this.removeSpecialInnerComment(this.s), this.location, this.preprocessorError);
        }
        return this;
    }

    private String removeSpecialInnerComment(String s) {
        if (s.contains("/'''") && s.contains("'''/")) {
            return s.replaceAll("/'''[-\\w]*'''/", "");
        }
        return s;
    }

    public String getString() {
        return this.s;
    }

    public LineLocation getLocation() {
        return this.location;
    }

    public String getPreprocessorError() {
        return this.preprocessorError;
    }

    public long getFoxSignature() {
        if (this.fox == -1L) {
            this.fox = FoxSignature.getFoxSignature(this.getString());
        }
        return this.fox;
    }
}

