/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionSplit
implements Instruction {
    private final List<InstructionList> splits = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final Swimlane swimlaneIn;
    private Swimlane swimlaneOut;

    public InstructionSplit(Instruction parent, LinkRendering inlinkRendering, Swimlane swimlane) {
        this.parent = parent;
        this.swimlaneIn = swimlane;
        this.splits.add(new InstructionList(swimlane));
        this.inlinkRendering = inlinkRendering;
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean containsBreak() {
        for (InstructionList split : this.splits) {
            if (!split.containsBreak()) continue;
            return true;
        }
        return false;
    }

    private InstructionList getLast() {
        return this.splits.get(this.splits.size() - 1);
    }

    @Override
    public void add(Instruction ins) {
        this.getLast().add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.splits) {
            all.add(list.createFtile(factory));
        }
        return factory.createParallel(all, ForkStyle.SPLIT, null);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void splitAgain(LinkRendering inlinkRendering) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        InstructionList list = new InstructionList(this.swimlaneIn);
        this.splits.add(list);
    }

    public void endSplit(LinkRendering inlinkRendering, Swimlane endSwimlane) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        this.swimlaneOut = endSwimlane;
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.getLast().addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.splits);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlaneOut;
    }
}

