/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileForkInner;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleEnd;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleSpot;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStart;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStop;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateIn;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateOut;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UFont;

public class VCompactFactory
implements FtileFactory {
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();
    private final StringBounder stringBounder;

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public StyleBuilder getCurrentStyleBuilder() {
        return this.skinParam.getCurrentStyleBuilder();
    }

    public VCompactFactory(ISkinParam skinParam, StringBounder stringBounder) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
    }

    public final StyleSignature getDefaultStyleDefinitionCircle() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        HtmlColor color;
        Style style = null;
        if (SkinParam.USE_STYLES()) {
            style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        } else {
            color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityStart);
        }
        return new FtileCircleStart(this.skinParam(), color, swimlane, style);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        HtmlColor color;
        Style style = null;
        if (SkinParam.USE_STYLES()) {
            style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        } else {
            color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityEnd);
        }
        return new FtileCircleStop(this.skinParam(), color, swimlane, style);
    }

    @Override
    public Ftile spot(Swimlane swimlane, String spot) {
        UFont font = this.skinParam.getFont(null, false, FontParam.ACTIVITY);
        return new FtileCircleSpot(this.skinParam(), swimlane, spot, font);
    }

    @Override
    public Ftile end(Swimlane swimlane) {
        HtmlColor color;
        Style style = null;
        if (SkinParam.USE_STYLES()) {
            style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        } else {
            color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityEnd);
        }
        return new FtileCircleEnd(this.skinParam(), color, swimlane, style);
    }

    @Override
    public Ftile activity(Display label, Swimlane swimlane, BoxStyle boxStyle, Colors colors) {
        UFont font = this.skinParam.getFont(null, false, FontParam.ACTIVITY);
        return FtileBox.create(colors.mute(this.skinParam), label, swimlane, boxStyle);
    }

    @Override
    public Ftile addNote(Ftile ftile, Swimlane swimlane, Collection<PositionedNote> notes) {
        return ftile;
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return ftile;
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        return new FtileAssemblySimple(tile1, tile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Swimlane swimlaneOut, Display startLabel, Ftile repeat, Display test, Display yes, Display out, HtmlColor color, LinkRendering backRepeatLinkRendering, Ftile backward, boolean noOut) {
        return repeat;
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile whileBlock, Display test, Display yes, Display out, LinkRendering afterEndwhile, HtmlColor color, Instruction specialOut) {
        return whileBlock;
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> thens, Branch elseBranch, LinkRendering afterEndwhile, LinkRendering topInlinkRendering, Url url) {
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            ftiles.add(branch.getFtile());
        }
        ftiles.add(elseBranch.getFtile());
        return new FtileForkInner(ftiles);
    }

    @Override
    public Ftile createSwitch(Swimlane swimlane, List<Branch> branches, LinkRendering afterEndwhile, LinkRendering topInlinkRendering, Display labelTest) {
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        for (Branch branch : branches) {
            ftiles.add(branch.getFtile());
        }
        return new FtileForkInner(ftiles);
    }

    @Override
    public Ftile createParallel(List<Ftile> all, ForkStyle style, String label) {
        return new FtileForkInner(all);
    }

    @Override
    public Ftile createGroup(Ftile list, Display name, HtmlColor backColor, HtmlColor titleColor, PositionedNote note, HtmlColor borderColor, USymbol type, double roundCorner) {
        return list;
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateOut(ftile, linkRendering);
    }

    @Override
    public ISkinParam skinParam() {
        return this.skinParam;
    }
}

