/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;

public class BlocLines
implements Iterable<StringLocated> {
    private List<StringLocated> lines;

    public String toString() {
        return this.lines.toString();
    }

    public static BlocLines load(File f, LineLocation location) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        return BlocLines.loadInternal(br, location);
    }

    public static BlocLines load(InputStream is, LineLocation location) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return BlocLines.loadInternal(br, location);
    }

    private static BlocLines loadInternal(BufferedReader br, LineLocation location) throws IOException {
        String s;
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        while ((s = br.readLine()) != null) {
            result.add(new StringLocated(s, location));
        }
        br.close();
        return new BlocLines(result);
    }

    private BlocLines(List<StringLocated> lines) {
        this.lines = Collections.unmodifiableList(lines);
    }

    public Display toDisplay() {
        return Display.createFoo(this.lines);
    }

    public static BlocLines single2(StringLocated single) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        result.add(single);
        return new BlocLines(result);
    }

    public static BlocLines singleString(String single) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        result.add(new StringLocated(single, null));
        return new BlocLines(result);
    }

    public static BlocLines getWithNewlines(String s) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        for (String cs : BackSlash.getWithNewlines(s)) {
            result.add(new StringLocated(cs, null));
        }
        return new BlocLines(result);
    }

    public BlocLines() {
        this(new ArrayList<StringLocated>());
    }

    public BlocLines add2(StringLocated s) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.add(s);
        return new BlocLines(copy);
    }

    public BlocLines addString(String s) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.add(new StringLocated(s, null));
        return new BlocLines(copy);
    }

    public List<String> getLinesAsStringForSprite() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringLocated s : this.lines) {
            result.add(s.getString());
        }
        return result;
    }

    public int size() {
        return this.lines.size();
    }

    public StringLocated get499(int i) {
        return this.lines.get(i);
    }

    public StringLocated getFirst499() {
        if (this.lines.size() == 0) {
            return null;
        }
        return this.lines.get(0);
    }

    public StringLocated getLast499() {
        return this.lines.get(this.lines.size() - 1);
    }

    public BlocLines cleanList2(MultilinesStrategy strategy) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        strategy.cleanList(copy);
        return new BlocLines(copy);
    }

    public BlocLines trim(boolean removeEmptyLines) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        for (int i = 0; i < copy.size(); ++i) {
            StringLocated s = (StringLocated)copy.get(i);
            copy.set(i, new StringLocated(s.getTrimmed().getString(), s.getLocation()));
        }
        if (removeEmptyLines) {
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                if (((StringLocated)it.next()).getString().length() != 0) continue;
                it.remove();
            }
        }
        return new BlocLines(copy);
    }

    public BlocLines removeEmptyColumns() {
        if (!BlocLines.firstColumnRemovable(this.lines)) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        do {
            for (int i = 0; i < copy.size(); ++i) {
                StringLocated s = (StringLocated)copy.get(i);
                if (s.getString().length() <= 0) continue;
                copy.set(i, s.sub(1, s.getString().length()));
            }
        } while (BlocLines.firstColumnRemovable(copy));
        return new BlocLines(copy);
    }

    private static boolean firstColumnRemovable(List<StringLocated> data) {
        boolean allEmpty = true;
        for (StringLocated s : data) {
            if (s.getString().length() == 0) continue;
            allEmpty = false;
            char c = s.getString().charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !allEmpty;
    }

    public char getLastChar() {
        StringLocated s = this.lines.get(this.lines.size() - 1);
        return s.getString().charAt(s.getString().length() - 1);
    }

    public BlocLines removeStartingAndEnding2(String data) {
        if (this.lines.size() == 0) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.set(0, new StringLocated(data, null));
        int n = copy.size() - 1;
        StringLocated s = (StringLocated)copy.get(n);
        copy.set(n, s.sub(0, s.getString().length() - 1));
        return new BlocLines(copy);
    }

    public BlocLines toSingleLineWithHiddenNewLine() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated line : this.lines) {
            sb.append(line.getString());
            sb.append(BackSlash.hiddenNewLine());
        }
        return BlocLines.singleString(sb.substring(0, sb.length() - 1).toString());
    }

    public BlocLines trimSmart(int referenceLine) {
        if (this.lines.size() <= referenceLine) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        int nbStartingSpace = BlocLines.nbStartingSpace(((StringLocated)copy.get(referenceLine)).getString());
        for (int i = referenceLine; i < copy.size(); ++i) {
            StringLocated s = (StringLocated)copy.get(i);
            copy.set(i, BlocLines.removeStartingSpaces(s, nbStartingSpace));
        }
        return new BlocLines(copy);
    }

    private static int nbStartingSpace(CharSequence s) {
        int nb;
        for (nb = 0; nb < s.length() && BlocLines.isSpaceOrTab(s.charAt(nb)); ++nb) {
        }
        return nb;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static StringLocated removeStartingSpaces(StringLocated arg, int nbStartingSpace) {
        int i;
        if (arg.getString().length() == 0) {
            return arg;
        }
        for (i = 0; i < nbStartingSpace && i < arg.getString().length() && BlocLines.isSpaceOrTab(arg.getString().charAt(i)); ++i) {
        }
        if (i == 0) {
            return arg;
        }
        return arg.sub(i, arg.getString().length());
    }

    public BlocLines subExtract(int margeStart, int margeEnd) {
        List<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy = copy.subList(margeStart, copy.size() - margeEnd);
        return new BlocLines(copy);
    }

    public BlocLines subList(int start, int end) {
        return new BlocLines(this.lines.subList(start, end));
    }

    @Override
    public Iterator<StringLocated> iterator() {
        return this.lines.iterator();
    }

    public BlocLines eventuallyMoveBracket() {
        if (this.size() < 2) {
            return this;
        }
        String first = this.getFirst499().getTrimmed().getString();
        String second = this.get499(1).getTrimmed().getString();
        if (!first.endsWith("{") && second.equals("{")) {
            String vline = first + " {";
            ArrayList<StringLocated> result = new ArrayList<StringLocated>();
            result.add(new StringLocated(vline, null));
            result.addAll(this.lines.subList(2, this.lines.size()));
            return new BlocLines(result);
        }
        return this;
    }
}

