/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexComposed;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;

public class RegexOr
extends RegexComposed
implements IRegex {
    private final String name;

    public RegexOr(IRegex ... partial) {
        this((String)null, partial);
    }

    public RegexOr(String name, IRegex ... partials) {
        super(partials);
        this.name = name;
    }

    @Override
    protected String getFullSlow() {
        StringBuilder sb = new StringBuilder("(");
        if (this.name == null) {
            sb.append("?:");
        }
        for (IRegex p : this.partials) {
            sb.append(p.getPattern());
            sb.append("|");
        }
        sb.setLength(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected int getStartCount() {
        return 1;
    }

    @Override
    public final Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        String fullGroup = this.name == null ? null : it.next();
        result.putAll(super.createPartialMatch(it));
        if (this.name != null) {
            RegexPartialMatch m = new RegexPartialMatch(this.name);
            m.add(fullGroup);
            result.put(this.name, m);
        }
        return result;
    }

    @Override
    public boolean match(StringLocated full) {
        throw new UnsupportedOperationException();
    }
}

