/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.AbstractAtom;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class AtomOpenIcon
extends AbstractAtom
implements Atom {
    private final OpenIcon openIcon;
    private final double factor;
    private final Url url;
    private final HtmlColor color;

    public AtomOpenIcon(HtmlColor newColor, double scale, OpenIcon openIcon, FontConfiguration fontConfiguration, Url url) {
        this.url = url;
        this.openIcon = openIcon;
        this.factor = scale * fontConfiguration.getSize2D() / 12.0;
        this.color = newColor == null ? fontConfiguration.getColor() : newColor;
    }

    private TextBlock asTextBlock() {
        return TextBlockUtils.withMargin(this.openIcon.asTextBlock(this.color, this.factor), 1.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asTextBlock().calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -3.0 * this.factor;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asTextBlock().drawU(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }
}

