/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GridTextBlockSimple
implements TextBlock {
    protected final LinkedElement[][] data;

    public GridTextBlockSimple(int lines, int cols) {
        this.data = new LinkedElement[lines][cols];
    }

    protected boolean isPresent(int i, int j) {
        if (i == -1) {
            return false;
        }
        return this.data[i][j] != null;
    }

    public void drawGrid(UGraphic ug) {
    }

    @Override
    public void drawU(UGraphic ug) {
        this.drawGrid(ug);
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data[i].length; ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                if (this.data[i][j] != null) {
                    this.data[i][j].drawMe(ug.apply(new UTranslate(x, y)), colWidth, lineHeight);
                }
                x += colWidth;
            }
            y += lineHeight;
        }
    }

    protected double colWidth(StringBounder stringBounder, int j) {
        double width = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][j] == null) continue;
            width = Math.max(width, this.data[i][j].naturalDimension(stringBounder).getWidth());
        }
        return width;
    }

    public double lineHeight(StringBounder stringBounder, int i) {
        double height = 0.0;
        for (int j = 0; j < this.data[i].length; ++j) {
            if (this.data[i][j] == null) continue;
            height = Math.max(height, this.data[i][j].naturalDimension(stringBounder).getHeight());
        }
        return height;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.data.length == 0) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        double height = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            height += this.lineHeight(stringBounder, i);
        }
        double width = 0.0;
        for (int j = 0; j < this.data[0].length; ++j) {
            width += this.colWidth(stringBounder, j);
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        throw new UnsupportedOperationException("member=" + member + " " + this.getClass().toString());
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void add(int i, int j, LinkedElement value) {
        this.data[i][j] = value;
    }
}

