/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Month;

public class ComplementDate
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexOr(this.toRegexA(suffix), this.toRegexB(suffix), this.toRegexC(suffix), this.toRegexD(suffix));
    }

    private IRegex toRegexA(String suffix) {
        return new RegexConcat(new RegexLeaf("ADAY" + suffix, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AMONTH" + suffix, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AYEAR" + suffix, "([\\d]{4})"));
    }

    private IRegex toRegexB(String suffix) {
        return new RegexConcat(new RegexLeaf("BYEAR" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY" + suffix, "([\\d]{1,2})"));
    }

    private IRegex toRegexC(String suffix) {
        return new RegexConcat(new RegexLeaf("CMONTH" + suffix, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CDAY" + suffix, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CYEAR" + suffix, "([\\d]{4})"));
    }

    private IRegex toRegexD(String suffix) {
        return new RegexConcat(new RegexLeaf("DCOUNT" + suffix, "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("after"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("start"));
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        if (arg.get("ADAY" + suffix, 0) != null) {
            return Failable.ok(this.resultA(arg, suffix));
        }
        if (arg.get("BDAY" + suffix, 0) != null) {
            return Failable.ok(this.resultB(arg, suffix));
        }
        if (arg.get("CDAY" + suffix, 0) != null) {
            return Failable.ok(this.resultC(arg, suffix));
        }
        if (arg.get("DCOUNT" + suffix, 0) != null) {
            return Failable.ok(this.resultD(system, arg, suffix));
        }
        throw new IllegalStateException();
    }

    private Complement resultD(GanttDiagram system, RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DCOUNT" + suffix, 0));
        return system.getStartingDate(day);
    }

    private Complement resultA(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("ADAY" + suffix, 0));
        String month = arg.get("AMONTH" + suffix, 0);
        int year = Integer.parseInt(arg.get("AYEAR" + suffix, 0));
        return DayAsDate.create(year, month, day);
    }

    private Complement resultB(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("BDAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("BMONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("BYEAR" + suffix, 0));
        return DayAsDate.create(year, month, day);
    }

    private Complement resultC(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("CDAY" + suffix, 0));
        String month = arg.get("CMONTH" + suffix, 0);
        int year = Integer.parseInt(arg.get("CYEAR" + suffix, 0));
        return DayAsDate.create(year, month, day);
    }
}

