/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignment messagePosition;
    private final boolean niceArrow;
    private final boolean belowForResponse;
    public static final double spaceCrossX = 6.0;
    public static final double diamCircle = 8.0;
    public static final double thinCircle = 1.5;

    public ComponentRoseArrow(Style style, HtmlColor foregroundColor, FontConfiguration font, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, HorizontalAlignment messagePosition, ISkinSimple spriteContainer, HorizontalAlignment textHorizontalAlignment, LineBreakStrategy maxMessageSize, boolean niceArrow, boolean belowForResponse) {
        super(style, foregroundColor, font, stringsToDisplay, arrowConfiguration, spriteContainer, textHorizontalAlignment, maxMessageSize);
        if (SkinParam.USE_STYLES()) {
            messagePosition = style.getHorizontalAlignment();
        }
        this.messagePosition = messagePosition;
        this.niceArrow = niceArrow;
        this.belowForResponse = belowForResponse;
    }

    @Override
    public void drawInternalU(UGraphic ug, Area area) {
        double textPos;
        double yText;
        double posArrow;
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UChangeColor(this.getForegroundColor()));
        ArrowDressing dressing1 = this.getArrowConfiguration().getDressing1();
        ArrowDressing dressing2 = this.getArrowConfiguration().getDressing2();
        double start = 0.0;
        double len = dimensionToUse.getWidth() - 1.0;
        double pos1 = start + 1.0;
        double pos2 = len - 1.0;
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() == ArrowHead.NONE) {
            len -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() != ArrowHead.NONE) {
            len -= 5.5;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NONE) {
            start += 4.0;
            len -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NORMAL) {
            start += 9.5;
            len -= 9.5;
        }
        if (dressing2.getPart() == ArrowPart.FULL && dressing2.getHead() == ArrowHead.NORMAL) {
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing1.getPart() == ArrowPart.FULL && dressing1.getHead() == ArrowHead.NORMAL) {
            start += (double)(this.getArrowDeltaX() / 2);
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing2.getHead() == ArrowHead.CROSSX) {
            len -= 12.0;
        }
        if (dressing1.getHead() == ArrowHead.CROSSX) {
            start += 12.0;
            len -= 12.0;
        }
        if (this.isBelowForResponse()) {
            posArrow = 0.0;
            yText = this.getMarginY();
        } else {
            posArrow = this.getTextHeight(stringBounder);
            yText = 0.0;
        }
        this.drawDressing1(ug.apply(new UTranslate(0.0, posArrow)), pos1, dressing1, this.getArrowConfiguration().getDecoration1());
        this.drawDressing2(ug.apply(new UTranslate(0.0, posArrow)), pos2, dressing2, this.getArrowConfiguration().getDecoration2());
        this.getArrowConfiguration().applyStroke(ug).apply(new UTranslate(start, posArrow)).draw(new ULine(len, 0.0));
        ArrowDirection direction2 = this.getDirection2();
        if (this.messagePosition == HorizontalAlignment.CENTER) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        } else if (this.messagePosition == HorizontalAlignment.RIGHT) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = dimensionToUse.getWidth() - textWidth - (double)this.getMarginX2() - (double)(direction2 == ArrowDirection.LEFT_TO_RIGHT_NORMAL ? this.getArrowDeltaX() : 0);
        } else {
            textPos = this.getMarginX1() + (direction2 == ArrowDirection.RIGHT_TO_LEFT_REVERSE || direction2 == ArrowDirection.BOTH_DIRECTION ? this.getArrowDeltaX() : 0);
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(textPos, yText)));
    }

    private boolean isBelowForResponse() {
        return this.belowForResponse && this.getDirection2() == ArrowDirection.RIGHT_TO_LEFT_REVERSE;
    }

    private void drawDressing1(UGraphic ug, double x, ArrowDressing dressing, ArrowDecoration decoration) {
        if (decoration == ArrowDecoration.CIRCLE) {
            UEllipse circle = new UEllipse(8.0, 8.0);
            ug.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor())).apply(new UTranslate(x - 4.0 - 1.5, -4.75)).draw(circle);
            x += 5.5;
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x - 1.0, 0.0)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x - 1.0, 0.0)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(new UStroke(2.0));
            ug.apply(new UTranslate(6.0, -this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(6.0, this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonReverse(dressing.getPart());
            ug.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UTranslate(x, 0.0)).draw(polygon);
        }
    }

    private void drawDressing2(UGraphic ug, double x, ArrowDressing dressing, ArrowDecoration decoration) {
        if (decoration == ArrowDecoration.CIRCLE) {
            ug = ug.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor()));
            UEllipse circle = new UEllipse(8.0, 8.0);
            ug.apply(new UTranslate(x - 4.0 + 1.5, -4.75)).draw(circle);
            ug = ug.apply(new UStroke());
            x -= 5.5;
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x, 0.0)).draw(new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x, 0.0)).draw(new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(new UStroke(2.0));
            ug.apply(new UTranslate(x - 6.0 - (double)this.getArrowDeltaX(), -this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(x - 6.0 - (double)this.getArrowDeltaX(), this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
            ug = ug.apply(new UStroke());
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonNormal(dressing.getPart(), x);
            ug.apply(new UChangeBackColor(this.getForegroundColor())).draw(polygon);
        }
    }

    private UPolygon getPolygonNormal(ArrowPart part, double x2) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(x2, 0.0);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), 0.0);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), 1.0);
            polygon.addPoint(x2, 1.0);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(x2, 0.0);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(x2 - (double)this.getArrowDeltaX() + 4.0, 0.0);
            }
        }
        return polygon;
    }

    private UPolygon getPolygonReverse(ArrowPart part) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(this.getArrowDeltaX(), 0.0);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), 1.0);
            polygon.addPoint(0.0, 1.0);
            polygon.addPoint(this.getArrowDeltaX(), this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(this.getArrowDeltaX(), this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(this.getArrowDeltaX() - 4, 0.0);
            }
        }
        return polygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        double y = this.getYPoint(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(this.getPaddingX(), y);
        }
        return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), y);
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        double y = this.getYPoint(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), y);
        }
        return new Point2D.Double(this.getPaddingX(), y);
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        if (this.isBelowForResponse()) {
            return this.getPaddingY();
        }
        return this.getTextHeight(stringBounder) + this.getPaddingY();
    }

    private final ArrowDirection getDirection2() {
        return this.getArrowConfiguration().getArrowDirection();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + (double)this.getArrowDeltaX();
    }
}

