/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ListSpriteDiagram
extends UmlDiagram {
    public ListSpriteDiagram(ISkinSimple skinParam) {
        super(skinParam);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.HELP;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        TextBlock result = this.getTable();
        double margin = 10.0;
        double dpiFactor = 1.0;
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlock getTable() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double x = 0.0;
                double y = 0.0;
                double rawHeight = 0.0;
                for (String n : ListSpriteDiagram.this.getSkinParam().getAllSpriteNames()) {
                    Sprite sprite = ListSpriteDiagram.this.getSkinParam().getSprite(n);
                    TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, ListSpriteDiagram.this.getSkinParam());
                    TextBlock tb = sprite.asTextBlock(HtmlColorUtils.BLACK, 1.0);
                    tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
                    tb.drawU(ug.apply(new UTranslate(x, y)));
                    Dimension2D dim = tb.calculateDimension(ug.getStringBounder());
                    rawHeight = Math.max(rawHeight, dim.getHeight());
                    x += dim.getWidth();
                    if (!((x += 30.0) > 1024.0)) continue;
                    x = 0.0;
                    y += rawHeight + 50.0;
                    rawHeight = 0.0;
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(1024.0, 1024.0);
            }
        };
    }
}

