/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;

public class CommandStyleMultilinesCSS
extends CommandMultilines2<UmlDiagram> {
    public static final String STYLE_SELECTOR_SEPARATOR2 = "-&";
    private static final String NAME_USER = "[\\w()]+?";
    private static final Pattern2 userName = MyPattern.cmpile("^[.:]?([\\w()]+?)([%s]+\\*)?[%s]*\\{$");
    private static final Pattern2 propertyAndValue = MyPattern.cmpile("^([\\w]+):?[%s]+(.*?);?$");
    private static final Pattern2 closeBracket = MyPattern.cmpile("^\\}$");

    public CommandStyleMultilinesCSS() {
        super(CommandStyleMultilinesCSS.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\</style\\>[%s]*$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleMultilinesCSS.class.getName(), RegexLeaf.start(), new RegexLeaf("\\<style\\>"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(UmlDiagram diagram, BlocLines lines) {
        if (!SkinParam.USE_STYLES()) {
            return CommandExecutionResult.ok();
        }
        StyleBuilder styleBuilder = diagram.getSkinParam().getCurrentStyleBuilder();
        for (Style modifiedStyle : this.getDeclaredStyles(lines.subExtract(1, 1), styleBuilder)) {
            diagram.getSkinParam().muteStyle(modifiedStyle);
        }
        return CommandExecutionResult.ok();
    }

    public Collection<Style> getDeclaredStyles(BlocLines lines, AutomaticCounter counter) {
        ArrayList<Style> result = new ArrayList<Style>();
        ArrayList<String> context = new ArrayList<String>();
        ArrayList maps = new ArrayList();
        boolean inComment = false;
        for (StringLocated s : lines) {
            Matcher2 mUserName;
            String trimmed = s.getTrimmed().getString();
            if (trimmed.startsWith("/*") || trimmed.startsWith("/'")) {
                inComment = true;
                continue;
            }
            if (trimmed.endsWith("*/") || trimmed.endsWith("'/")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            int x = trimmed.lastIndexOf("//");
            if (x != -1) {
                trimmed = trimmed.substring(0, x).trim();
            }
            if ((mUserName = userName.matcher(trimmed)).find()) {
                boolean isRecurse;
                String n = mUserName.group(1);
                boolean bl = isRecurse = mUserName.group(2) != null;
                if (isRecurse) {
                    n = n + "*";
                }
                context.add(n);
                maps.add(new EnumMap(PName.class));
                continue;
            }
            Matcher2 mPropertyAndValue = propertyAndValue.matcher(trimmed);
            if (mPropertyAndValue.find()) {
                PName key = PName.getFromName(mPropertyAndValue.group(1));
                String value = mPropertyAndValue.group(2);
                if (key == null) continue;
                ((Map)maps.get(maps.size() - 1)).put(key, new ValueImpl(value, counter));
                continue;
            }
            Matcher2 mCloseBracket = closeBracket.matcher(trimmed);
            if (!mCloseBracket.find() || context.size() <= 0) continue;
            StyleSignature signature = this.contextToSignature(context);
            Style style = new Style(signature, (Map<PName, Value>)((Map)maps.get(maps.size() - 1)));
            result.add(style);
            context.remove(context.size() - 1);
            maps.remove(maps.size() - 1);
        }
        return Collections.unmodifiableList(result);
    }

    private StyleSignature contextToSignature(List<String> context) {
        StyleSignature result = StyleSignature.empty();
        boolean star = false;
        for (String s : context) {
            if (s.endsWith("*")) {
                star = true;
                s = s.substring(0, s.length() - 1);
            }
            result = result.add(s);
        }
        if (star) {
            result = result.addStar();
        }
        return result;
    }
}

