/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.style.CommandStyleMultilinesCSS;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;

public class StyleLoader {
    private final SkinParam skinParam;
    private StyleBuilder styleBuilder;

    public StyleLoader(SkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public StyleBuilder loadSkin(String filename) throws IOException {
        this.styleBuilder = new StyleBuilder(this.skinParam);
        InputStream internalIs = null;
        File localFile = new File(filename);
        Log.info("Trying to load style " + filename);
        if (!localFile.exists()) {
            localFile = FileSystem.getInstance().getFile(filename);
        }
        if (localFile.exists()) {
            Log.info("File found : " + localFile.getAbsolutePath());
            internalIs = new FileInputStream(localFile);
        } else {
            Log.info("File not found : " + localFile.getAbsolutePath());
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
            if (internalIs != null) {
                Log.info("... but " + filename + " found inside the .jar");
            }
        }
        if (internalIs == null) {
            return null;
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        this.loadSkinInternal(lines2);
        return this.styleBuilder;
    }

    private void loadSkinInternal(BlocLines lines) {
        CommandStyleMultilinesCSS cmd2 = new CommandStyleMultilinesCSS();
        for (Style newStyle : cmd2.getDeclaredStyles(lines, this.styleBuilder)) {
            this.styleBuilder.put(newStyle.getSignature(), newStyle);
        }
    }
}

