/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;

public class StyleSignature {
    private final Set<String> names = new LinkedHashSet<String>();

    public static StyleSignature build(String name) {
        StyleSignature result = new StyleSignature();
        StringTokenizer st = new StringTokenizer(name.toLowerCase(), "-&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.endsWith("*")) {
                throw new IllegalArgumentException();
            }
            result.names.add(token);
        }
        return result;
    }

    public StyleSignature(String s) {
        if (s.contains("*") || s.contains("&") || s.contains("-")) {
            throw new IllegalArgumentException();
        }
        this.names.add(s.toLowerCase());
    }

    public static StyleSignature empty() {
        return new StyleSignature();
    }

    private StyleSignature() {
    }

    private StyleSignature(Collection<String> copy) {
        this.names.addAll(copy);
    }

    public StyleSignature add(String s) {
        if (s == null) {
            return this;
        }
        if (s.contains("*") || s.contains("&") || s.contains("-")) {
            throw new IllegalArgumentException();
        }
        HashSet<String> result = new HashSet<String>(this.names);
        result.add(s.toLowerCase());
        return new StyleSignature(result);
    }

    public StyleSignature addStar() {
        HashSet<String> result = new HashSet<String>(this.names);
        result.add("*");
        return new StyleSignature(result);
    }

    public boolean isStarred() {
        return this.names.contains("*");
    }

    public boolean equals(Object arg) {
        StyleSignature other = (StyleSignature)arg;
        return this.names.equals(other.names);
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String n : this.names) {
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(n);
        }
        return result.toString();
    }

    public boolean matchAll(StyleSignature other) {
        if (other.isStarred() && !this.names.contains("*")) {
            return false;
        }
        for (String token : this.names) {
            if (token.equals("*") || other.names.contains(token)) continue;
            return false;
        }
        return true;
    }

    public final Set<String> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public static StyleSignature of(SName ... names) {
        ArrayList<String> result = new ArrayList<String>();
        for (SName name : names) {
            result.add(name.name().toLowerCase());
        }
        return new StyleSignature(result);
    }

    public StyleSignature withStereotype(Stereotype stereotype) {
        ArrayList<String> result = new ArrayList<String>(this.names);
        if (stereotype != null) {
            for (String name : stereotype.getStyleNames()) {
                result.add(name.toLowerCase());
            }
        }
        result.add(SName.stereotype.name().toLowerCase());
        return new StyleSignature(result);
    }

    public StyleSignature with(Stereotype stereotype) {
        ArrayList<String> result = new ArrayList<String>(this.names);
        if (stereotype != null) {
            for (String name : stereotype.getStyleNames()) {
                result.add(name.toLowerCase());
            }
        }
        return new StyleSignature(result);
    }

    public StyleSignature mergeWith(List<Style> others) {
        ArrayList<String> copy = new ArrayList<String>(this.names);
        for (Style other : others) {
            for (String s : other.getSignature().getNames()) {
                copy.add(s);
            }
        }
        return new StyleSignature(copy);
    }

    public StyleSignature mergeWith(StyleSignature other) {
        ArrayList<String> copy = new ArrayList<String>(this.names);
        copy.addAll(other.names);
        return new StyleSignature(copy);
    }

    public Style getMergedStyle(StyleBuilder styleBuilder) {
        if (styleBuilder == null) {
            return null;
        }
        return styleBuilder.getMergedStyle(this);
    }

    public boolean match(Stereotype stereotype) {
        for (String s : stereotype.getMultipleLabels()) {
            if (!this.names.contains(s)) continue;
            return true;
        }
        return false;
    }
}

