/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Sub2;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.PreprocessorInclude;
import net.sourceforge.plantuml.preproc2.PreprocessorIncludeStrategy;
import net.sourceforge.plantuml.preproc2.ReadLineQuoteComment;
import net.sourceforge.plantuml.tim.ConditionalContext;
import net.sourceforge.plantuml.tim.EaterAffectation;
import net.sourceforge.plantuml.tim.EaterAffectationDefine;
import net.sourceforge.plantuml.tim.EaterAssert;
import net.sourceforge.plantuml.tim.EaterDeclareFunction;
import net.sourceforge.plantuml.tim.EaterDumpMemory;
import net.sourceforge.plantuml.tim.EaterElseIf;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.EaterIf;
import net.sourceforge.plantuml.tim.EaterIfdef;
import net.sourceforge.plantuml.tim.EaterIfndef;
import net.sourceforge.plantuml.tim.EaterImport;
import net.sourceforge.plantuml.tim.EaterInclude;
import net.sourceforge.plantuml.tim.EaterIncludeDef;
import net.sourceforge.plantuml.tim.EaterIncludesub;
import net.sourceforge.plantuml.tim.EaterLegacyDefine;
import net.sourceforge.plantuml.tim.EaterLegacyDefineLong;
import net.sourceforge.plantuml.tim.EaterLog;
import net.sourceforge.plantuml.tim.EaterStartsub;
import net.sourceforge.plantuml.tim.EaterUndef;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.TrieImpl;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.AlwaysFalse;
import net.sourceforge.plantuml.tim.stdlib.AlwaysTrue;
import net.sourceforge.plantuml.tim.stdlib.CallUserFunction;
import net.sourceforge.plantuml.tim.stdlib.DateFunction;
import net.sourceforge.plantuml.tim.stdlib.Dirpath;
import net.sourceforge.plantuml.tim.stdlib.FileExists;
import net.sourceforge.plantuml.tim.stdlib.Filename;
import net.sourceforge.plantuml.tim.stdlib.FunctionExists;
import net.sourceforge.plantuml.tim.stdlib.GetVariableValue;
import net.sourceforge.plantuml.tim.stdlib.Getenv;
import net.sourceforge.plantuml.tim.stdlib.IntVal;
import net.sourceforge.plantuml.tim.stdlib.InvokeVoidFunction;
import net.sourceforge.plantuml.tim.stdlib.LogicalNot;
import net.sourceforge.plantuml.tim.stdlib.RetrieveVoidFunction;
import net.sourceforge.plantuml.tim.stdlib.SetVariableValue;
import net.sourceforge.plantuml.tim.stdlib.Strlen;
import net.sourceforge.plantuml.tim.stdlib.Strpos;
import net.sourceforge.plantuml.tim.stdlib.Substr;
import net.sourceforge.plantuml.tim.stdlib.VariableExists;

public class TContext {
    private final List<StringLocated> resultList = new ArrayList<StringLocated>();
    private final List<StringLocated> debug = new ArrayList<StringLocated>();
    private final Map<TFunctionSignature, TFunction> functions2 = new HashMap<TFunctionSignature, TFunction>();
    private final Set<TFunctionSignature> functionsFinal = new HashSet<TFunctionSignature>();
    private final Trie functions3 = new TrieImpl();
    private ImportedFiles importedFiles;
    private final String charset;
    private TFunctionImpl pendingFunction;
    private Sub2 pendingSub;
    private boolean inLongComment;
    private final Map<String, Sub2> subs = new HashMap<String, Sub2>();
    private final DefinitionsContainer definitionsContainer;
    private final Set<FileWithSuffix> filesUsedCurrent = new HashSet<FileWithSuffix>();
    private String pendingAdd = null;

    private void addStandardFunctions(Defines defines) {
        this.addFunction(new Strlen());
        this.addFunction(new Substr());
        this.addFunction(new FileExists());
        this.addFunction(new Getenv());
        this.addFunction(new Dirpath(defines));
        this.addFunction(new Filename(defines));
        this.addFunction(new DateFunction());
        this.addFunction(new Strpos());
        this.addFunction(new InvokeVoidFunction());
        this.addFunction(new AlwaysFalse());
        this.addFunction(new AlwaysTrue());
        this.addFunction(new LogicalNot());
        this.addFunction(new FunctionExists());
        this.addFunction(new VariableExists());
        this.addFunction(new CallUserFunction());
        this.addFunction(new RetrieveVoidFunction());
        this.addFunction(new SetVariableValue());
        this.addFunction(new GetVariableValue());
        this.addFunction(new IntVal());
    }

    public TContext(ImportedFiles importedFiles, Defines defines, String charset, DefinitionsContainer definitionsContainer) {
        this.definitionsContainer = definitionsContainer;
        this.importedFiles = importedFiles;
        this.charset = charset;
        this.addStandardFunctions(defines);
    }

    public Knowledge asKnowledge(final TMemory memory) {
        return new Knowledge(){

            @Override
            public TVariable getVariable(String name) {
                return memory.getVariable(name);
            }

            @Override
            public TFunction getFunction(TFunctionSignature name) {
                return TContext.this.getFunctionSmart(name);
            }
        };
    }

    public TFunction getFunctionSmart(TFunctionSignature searched) {
        TFunction func = this.functions2.get(searched);
        if (func != null) {
            return func;
        }
        for (TFunction candidate : this.functions2.values()) {
            if (!candidate.getSignature().sameNameAs(searched) || !candidate.canCover(searched.getNbArg())) continue;
            return candidate;
        }
        return null;
    }

    public void executeOneLine(TMemory memory, TLineType type, StringLocated s, TFunctionType fromType) throws EaterException {
        this.debug.add(s);
        assert (type == TLineType.getFromLine(s.getString()));
        if (!this.inLongComment && type == TLineType.STARTSUB) {
            if (this.pendingSub != null) {
                throw new EaterException("Cannot nest sub");
            }
            EaterStartsub eater = new EaterStartsub(s.getTrimmed().getString());
            eater.execute(this, memory);
            this.pendingSub = new Sub2(eater.getSubname());
            this.subs.put(eater.getSubname(), this.pendingSub);
            return;
        }
        if (!this.inLongComment && type == TLineType.ENDSUB) {
            if (this.pendingSub == null) {
                throw new EaterException("No corresponding !startsub");
            }
            Sub2 newly = this.pendingSub;
            this.pendingSub = null;
            this.runSub(memory, newly);
            return;
        }
        if (!this.inLongComment && type == TLineType.INCLUDESUB) {
            this.executeIncludesub(memory, s);
            return;
        }
        if (this.pendingSub != null) {
            this.pendingSub.add(s);
            return;
        }
        if (this.getPendingFunction() != null) {
            if (!this.inLongComment && type == TLineType.END_FUNCTION) {
                this.executeEndfunction();
            } else {
                this.getPendingFunction().addBody(s);
            }
            return;
        }
        if (this.inLongComment && s.getTrimmed().getString().endsWith("'/")) {
            this.inLongComment = false;
            return;
        }
        if (type == TLineType.COMMENT_LONG_START) {
            this.inLongComment = true;
            return;
        }
        if (this.inLongComment) {
            return;
        }
        if (type == TLineType.COMMENT_SIMPLE) {
            return;
        }
        s = s.removeInnerComment();
        if (type == TLineType.IF) {
            this.executeIf(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.IFDEF) {
            this.executeIfdef(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.IFNDEF) {
            this.executeIfndef(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.ELSE) {
            this.executeElse(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.ELSEIF) {
            this.executeElseIf(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.ENDIF) {
            this.executeEndif(memory, s.getTrimmed().getString());
            return;
        }
        ConditionalContext conditionalContext = memory.peekConditionalContext();
        if (conditionalContext != null && !memory.areAllIfOk()) {
            return;
        }
        if (type == TLineType.DUMP_MEMORY) {
            this.executeDumpMemory(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.ASSERT) {
            this.executeAssert(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.UNDEF) {
            this.executeUndef(memory, s);
            return;
        }
        if (fromType != TFunctionType.RETURN && type == TLineType.PLAIN) {
            this.addPlain(memory, s);
            return;
        }
        if (fromType == TFunctionType.RETURN && type == TLineType.RETURN) {
            return;
        }
        if (type == TLineType.LEGACY_DEFINE) {
            this.executeLegacyDefine(memory, s);
            return;
        }
        if (type == TLineType.LEGACY_DEFINELONG) {
            this.executeLegacyDefineLong(memory, s);
            return;
        }
        if (type == TLineType.AFFECTATION_DEFINE) {
            this.executeAffectationDefine(memory, s.getTrimmed().getString());
            return;
        }
        if (type == TLineType.AFFECTATION) {
            this.executeAffectation(memory, s.getTrimmed().getString());
            return;
        }
        if (fromType == null && type == TLineType.DECLARE_FUNCTION) {
            this.executeDeclareFunction(memory, s);
            return;
        }
        if (fromType == null && type == TLineType.END_FUNCTION) {
            CommandExecutionResult.error("error endfunc");
            return;
        }
        if (type == TLineType.INCLUDE) {
            this.executeInclude(memory, s);
            return;
        }
        if (type == TLineType.INCLUDE_DEF) {
            this.executeIncludeDef(memory, s);
            return;
        }
        if (type == TLineType.IMPORT) {
            this.executeImport(memory, s);
            return;
        }
        if (type == TLineType.LOG) {
            this.executeLog(memory, s);
            return;
        }
        throw new EaterException("Parsing Error");
    }

    private void addPlain(TMemory memory, StringLocated s) throws EaterException {
        StringLocated tmp = this.applyFunctionsAndVariables(memory, s);
        if (tmp != null) {
            if (this.pendingAdd != null) {
                tmp = new StringLocated(this.pendingAdd + tmp.getString(), tmp.getLocation());
                this.pendingAdd = null;
            }
            this.resultList.add(tmp);
        }
    }

    private void executeAffectationDefine(TMemory memory, String s) throws EaterException {
        new EaterAffectationDefine(s).execute(this, memory);
    }

    private void executeAffectation(TMemory memory, String s) throws EaterException {
        new EaterAffectation(s).execute(this, memory);
    }

    private void executeIf(TMemory memory, String s) throws EaterException {
        EaterIf condition = new EaterIf(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue();
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
    }

    private void executeElseIf(TMemory memory, String s) throws EaterException {
        ConditionalContext poll = memory.peekConditionalContext();
        if (poll == null) {
            throw new EaterException("No if related to this else");
        }
        poll.enteringElseIf();
        if (!poll.hasBeenBurn()) {
            EaterElseIf condition = new EaterElseIf(s);
            condition.execute(this, memory);
            boolean isTrue = condition.isTrue();
            if (isTrue) {
                poll.nowInSomeElseIf();
            }
        }
    }

    private void executeDumpMemory(TMemory memory, String s) throws EaterException {
        EaterDumpMemory condition = new EaterDumpMemory(s);
        condition.execute(this, memory);
    }

    private void executeAssert(TMemory memory, String s) throws EaterException {
        EaterAssert condition = new EaterAssert(s);
        condition.execute(this, memory);
    }

    private void executeIfdef(TMemory memory, String s) throws EaterException {
        EaterIfdef condition = new EaterIfdef(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue(this, memory);
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
    }

    private void executeIfndef(TMemory memory, String s) throws EaterException {
        EaterIfndef condition = new EaterIfndef(s);
        condition.execute(this, memory);
        boolean isTrue = condition.isTrue(this, memory);
        memory.addConditionalContext(ConditionalContext.fromValue(isTrue));
    }

    private void executeElse(TMemory memory, String s) throws EaterException {
        ConditionalContext poll = memory.peekConditionalContext();
        if (poll == null) {
            throw new EaterException("No if related to this else");
        }
        poll.nowInElse();
    }

    private void executeEndif(TMemory memory, String s) throws EaterException {
        ConditionalContext poll = memory.pollConditionalContext();
        if (poll == null) {
            throw new EaterException("No if related to this endif");
        }
    }

    private void executeDeclareFunction(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0068");
        }
        EaterDeclareFunction declareFunction = new EaterDeclareFunction(s);
        declareFunction.execute(this, memory);
        boolean finalFlag = declareFunction.getFinalFlag();
        TFunctionSignature declaredSignature = declareFunction.getFunction().getSignature();
        TFunction previous = this.functions2.get(declaredSignature);
        if (previous != null && (finalFlag || this.functionsFinal.contains(declaredSignature))) {
            throw new EaterException("This function is already defined");
        }
        if (finalFlag) {
            this.functionsFinal.add(declaredSignature);
        }
        if (declareFunction.getFunction().hasBody()) {
            this.addFunction(declareFunction.getFunction());
        } else {
            this.pendingFunction = declareFunction.getFunction();
        }
    }

    private void executeUndef(TMemory memory, StringLocated s) throws EaterException {
        EaterUndef undef = new EaterUndef(s);
        undef.execute(this, memory);
    }

    private void executeLegacyDefine(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0048");
        }
        EaterLegacyDefine legacyDefine = new EaterLegacyDefine(s);
        legacyDefine.execute(this, memory);
        TFunction function = legacyDefine.getFunction();
        this.functions2.put(function.getSignature(), function);
        this.functions3.add(function.getSignature().getFunctionName() + "(");
    }

    private void executeLegacyDefineLong(TMemory memory, StringLocated s) throws EaterException {
        if (this.pendingFunction != null) {
            throw new EaterException("already0068");
        }
        EaterLegacyDefineLong legacyDefineLong = new EaterLegacyDefineLong(s);
        legacyDefineLong.execute(this, memory);
        this.pendingFunction = legacyDefineLong.getFunction();
    }

    private StringLocated applyFunctionsAndVariables(TMemory memory, StringLocated located) throws EaterException {
        if (memory.isEmpty() && this.functions2.size() == 0) {
            return located;
        }
        String s = located.getString();
        String result = this.applyFunctionsAndVariables(memory, s);
        if (result == null) {
            return null;
        }
        return new StringLocated(result, located.getLocation());
    }

    public String applyFunctionsAndVariables(TMemory memory, String s) throws EaterException {
        if (memory.isEmpty() && this.functions2.size() == 0) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String presentFunction = this.getFunctionNameAt(s, i);
            if (presentFunction != null) {
                String sub = s.substring(i);
                EaterFunctionCall call = new EaterFunctionCall(sub, this.isLegacyDefine(presentFunction), this.isUnquoted(presentFunction));
                call.execute(this, memory);
                TFunction function = this.getFunctionSmart(new TFunctionSignature(presentFunction, call.getValues().size()));
                if (function == null) {
                    throw new EaterException("Function not found " + presentFunction);
                }
                if (function.getFunctionType() == TFunctionType.VOID) {
                    this.pendingAdd = result.toString();
                    this.executeVoid3(memory, sub, function);
                    return null;
                }
                if (function.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
                    this.pendingAdd = s.substring(0, i);
                    this.executeVoid3(memory, sub, function);
                    return null;
                }
                assert (function.getFunctionType() == TFunctionType.RETURN || function.getFunctionType() == TFunctionType.LEGACY_DEFINE);
                TValue functionReturn = function.executeReturn(this, memory, call.getValues());
                result.append(functionReturn.toString());
                i += call.getCurrentPosition() - 1;
                continue;
            }
            String presentVariable = TContext.getVarnameAt(memory, s, i);
            if (presentVariable != null) {
                block15: {
                    if (result.toString().endsWith("##")) {
                        result.setLength(result.length() - 2);
                    }
                    TValue value = memory.getVariable(presentVariable).getValue();
                    i += presentVariable.length() - 1;
                    if (value.isJson()) {
                        JsonValue jsonValue = (JsonObject)value.toJson();
                        ++i;
                        while (true) {
                            char n;
                            if ((n = s.charAt(i)) != '.') {
                                if (jsonValue.isString()) {
                                    result.append(jsonValue.asString());
                                } else {
                                    result.append(jsonValue.toString());
                                }
                                break block15;
                            }
                            ++i;
                            StringBuilder fieldName = new StringBuilder();
                            while (Character.isJavaIdentifierPart(s.charAt(i))) {
                                fieldName.append(s.charAt(i));
                                ++i;
                            }
                            jsonValue = jsonValue.get(fieldName.toString());
                        }
                    }
                    result.append(value.toString());
                }
                if (i + 2 >= s.length() || s.charAt(i + 1) != '#' || s.charAt(i + 2) != '#') continue;
                i += 2;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private void executeVoid3(TMemory memory, String s, TFunction function) throws EaterException {
        function.executeVoid(this, memory, s);
    }

    private void executeImport(TMemory memory, StringLocated s) throws EaterException {
        EaterImport _import = new EaterImport(s.getTrimmed().getString());
        _import.execute(this, memory);
        try {
            File file = FileSystem.getInstance().getFile(this.applyFunctionsAndVariables(memory, _import.getLocation()));
            if (file.exists() && !file.isDirectory()) {
                this.importedFiles.add(file);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EaterException("Cannot import " + e.getMessage());
        }
        throw new EaterException("Cannot import");
    }

    private void executeLog(TMemory memory, StringLocated s) throws EaterException {
        EaterLog log = new EaterLog(s.getTrimmed().getString());
        log.execute(this, memory);
    }

    /*
     * Unable to fully structure code
     */
    private void executeIncludesub(TMemory memory, StringLocated s) throws EaterException {
        include = new EaterIncludesub(s.getTrimmed().getString());
        include.execute(this, memory);
        location = include.getLocation();
        idx = location.indexOf(33);
        sub = null;
        if (OptionFlags.ALLOW_INCLUDE && idx != -1) {
            filename = location.substring(0, idx);
            blocname = location.substring(idx + 1);
            try {
                f2 = new FileWithSuffix(this.importedFiles, filename, null);
                if (!f2.fileOk()) ** GOTO lbl22
                reader = f2.getReader(this.charset);
                readerline = ReadLineReader.create(reader, location, s.getLocation());
                readerline = new UncommentReadLine(readerline);
                readerline = new ReadLineQuoteComment(true).applyFilter(readerline);
                sub = Sub2.fromFile(readerline, blocname, this, memory);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new EaterException("cannot include " + e);
            }
        } else {
            sub = this.subs.get(location);
        }
lbl22:
        // 3 sources

        if (sub == null) {
            throw new EaterException("cannot include " + location);
        }
        this.runSub(memory, sub);
    }

    private void runSub(TMemory memory, Sub2 sub) throws EaterException {
        for (StringLocated sl : sub.lines()) {
            this.executeOneLine(memory, TLineType.getFromLine(sl.getString()), sl, null);
        }
    }

    private void executeIncludeDef(TMemory memory, StringLocated s) throws EaterException {
        EaterIncludeDef include = new EaterIncludeDef(s.getTrimmed().getString());
        include.execute(this, memory);
        String definitionName = include.getLocation();
        List<String> definition = this.definitionsContainer.getDefinition2(definitionName);
        ReadLine reader2 = new ReadLineList(definition, s.getLocation());
        try {
            reader2 = new ReadLineQuoteComment(true).applyFilter(reader2);
            while (true) {
                StringLocated sl;
                if ((sl = reader2.readLine()) == null) {
                    return;
                }
                this.executeOneLine(memory, TLineType.getFromLine(sl.getString()), sl, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EaterException("" + e);
        }
    }

    private void executeInclude(TMemory memory, StringLocated s) throws EaterException {
        EaterInclude include = new EaterInclude(s.getTrimmed().getString());
        include.execute(this, memory);
        String location = include.getLocation();
        PreprocessorIncludeStrategy strategy = include.getPreprocessorIncludeStrategy();
        int idx = location.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = location.substring(idx + 1);
            location = location.substring(0, idx);
        }
        ReadLine reader2 = null;
        ImportedFiles saveImportedFiles = null;
        try {
            FileWithSuffix f2;
            if (location.startsWith("http://") || location.startsWith("https://")) {
                URL url = new URL(location);
                reader2 = PreprocessorInclude.getReaderIncludeUrl2(url, s, suf, this.charset);
            }
            if (location.startsWith("<") && location.endsWith(">")) {
                reader2 = PreprocessorInclude.getReaderStdlibInclude(s, location.substring(1, location.length() - 1));
            } else if (OptionFlags.ALLOW_INCLUDE && (f2 = new FileWithSuffix(this.importedFiles, location, suf)).fileOk()) {
                if (strategy == PreprocessorIncludeStrategy.DEFAULT && this.filesUsedCurrent.contains(f2)) {
                    return;
                }
                if (strategy == PreprocessorIncludeStrategy.ONCE && this.filesUsedCurrent.contains(f2)) {
                    throw new EaterException("This file has already been included");
                }
                if (StartDiagramExtractReader.containsStartDiagram(f2, s, this.charset)) {
                    reader2 = StartDiagramExtractReader.build(f2, s, this.charset);
                } else {
                    Reader reader = f2.getReader(this.charset);
                    reader2 = ReadLineReader.create(reader, location, s.getLocation());
                }
                saveImportedFiles = this.importedFiles;
                this.importedFiles = this.importedFiles.withCurrentDir(f2.getParentFile());
                assert (reader2 != null);
                this.filesUsedCurrent.add(f2);
            }
            if (reader2 != null) {
                reader2 = new ReadLineQuoteComment(true).applyFilter(reader2);
                try {
                    while (true) {
                        StringLocated sl;
                        if ((sl = reader2.readLine()) == null) {
                            return;
                        }
                        this.executeOneLine(memory, TLineType.getFromLine(sl.getString()), sl, null);
                    }
                }
                finally {
                    if (saveImportedFiles != null) {
                        this.importedFiles = saveImportedFiles;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EaterException("cannot include " + e);
        }
        throw new EaterException("cannot include " + location);
    }

    public boolean isLegacyDefine(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().getFunctionType().isLegacy()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnquoted(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().isUnquoted()) continue;
            return true;
        }
        return false;
    }

    public boolean doesFunctionExist(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functions2.entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private static String getVarnameAt(TMemory memory, String s, int pos) {
        if (pos > 0 && TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos - 1)) && !TContext.justAfterBackslashN(s, pos)) {
            return null;
        }
        String varname = memory.variablesNames3().getLonguestMatchStartingIn(s.substring(pos));
        if (varname.length() == 0) {
            return null;
        }
        if (pos + varname.length() == s.length() || !TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos + varname.length()))) {
            return varname;
        }
        return null;
    }

    private static boolean justAfterBackslashN(String s, int pos) {
        return pos > 1 && s.charAt(pos - 2) == '\\' && s.charAt(pos - 1) == 'n';
    }

    private String getFunctionNameAt(String s, int pos) {
        if (pos > 0 && TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos - 1)) && !TContext.justAfterBackslashN(s, pos)) {
            return null;
        }
        String fname = this.functions3.getLonguestMatchStartingIn(s.substring(pos));
        if (fname.length() == 0) {
            return null;
        }
        return fname.substring(0, fname.length() - 1);
    }

    public List<StringLocated> getResultList() {
        return this.resultList;
    }

    public List<StringLocated> getDebug() {
        return this.debug;
    }

    public final TFunctionImpl getPendingFunction() {
        return this.pendingFunction;
    }

    private void addFunction(TFunction func) {
        if (func.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
            ((TFunctionImpl)func).finalizeEnddefinelong();
        }
        this.functions2.put(func.getSignature(), func);
        this.functions3.add(func.getSignature().getFunctionName() + "(");
    }

    public void executeEndfunction() {
        this.addFunction(this.pendingFunction);
        this.pendingFunction = null;
    }

    public String extractFromResultList(int n1) {
        StringBuilder sb = new StringBuilder();
        while (this.resultList.size() > n1) {
            sb.append(this.resultList.get(n1).getString());
            this.resultList.remove(n1);
            if (this.resultList.size() <= n1) continue;
            sb.append("\\n");
        }
        return sb.toString();
    }
}

