/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.ugraphic.visio.VisioShape;

public class VisioText
implements VisioShape {
    private final int id;
    private final String text;
    private final int fontSize;
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    private final double coefFont = 150.0;

    public static VisioText createInches(int id, String text, int fontSize, double x, double y, double width, double height) {
        double coef = 1.8;
        return new VisioText(id, text, fontSize, VisioText.toInches(x), VisioText.toInches(y + 2.5), VisioText.toInches(width * 1.8), VisioText.toInches(height * 1.8));
    }

    private static double toInches(double val) {
        return val / 72.0;
    }

    private VisioText(int id, String text, int fontSize, double x, double y, double width, double height) {
        this.id = id;
        this.text = text;
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.fontSize = fontSize;
    }

    @Override
    public void print(OutputStream os) throws IOException {
        this.out(os, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='1' FillStyle='1' TextStyle='3'>");
        this.out(os, "<XForm>");
        this.out(os, "<PinX>" + this.x + "</PinX>");
        this.out(os, "<PinY>" + this.y + "</PinY>");
        this.out(os, "<Width>" + this.width + "</Width>");
        this.out(os, "<Height>" + this.height + "</Height>");
        this.out(os, "<LocPinX F='Width*0'>0</LocPinX>");
        this.out(os, "<LocPinY F='Height*0'>0</LocPinY>");
        this.out(os, "<Angle>0</Angle>");
        this.out(os, "<FlipX>0</FlipX>");
        this.out(os, "<FlipY>0</FlipY>");
        this.out(os, "<ResizeMode>0</ResizeMode>");
        this.out(os, "</XForm>");
        this.out(os, "<TextBlock>");
        this.out(os, "<VerticalAlign>0</VerticalAlign>");
        this.out(os, "</TextBlock>");
        this.out(os, "<Char IX='" + this.id + "'>");
        this.out(os, "<Font F='Inh'>0</Font>");
        this.out(os, "<Color F='Inh'>0</Color>");
        this.out(os, "<Style F='Inh'>0</Style>");
        this.out(os, "<Case F='Inh'>0</Case>");
        this.out(os, "<Pos F='Inh'>0</Pos>");
        this.out(os, "<FontScale F='Inh'>1</FontScale>");
        this.out(os, "<Locale F='Inh'>0</Locale>");
        this.out(os, "<Size Unit='PT'>" + (double)this.fontSize / 150.0 + "</Size>");
        this.out(os, "<DblUnderline F='Inh'>0</DblUnderline>");
        this.out(os, "<Overline F='Inh'>0</Overline>");
        this.out(os, "<Strikethru F='Inh'>0</Strikethru>");
        this.out(os, "<Perpendicular F='Inh'>0</Perpendicular>");
        this.out(os, "<Letterspace F='Inh'>0</Letterspace>");
        this.out(os, "<ColorTrans F='Inh'>0</ColorTrans>");
        this.out(os, "</Char>");
        this.out(os, "<Para IX='" + this.id + "'>");
        this.out(os, "<HorzAlign>0</HorzAlign>");
        this.out(os, "</Para>");
        this.out(os, "<Text><cp IX='" + this.id + "'/><pp IX='" + this.id + "'/>" + this.text + "</Text>");
        this.out(os, "</Shape>");
    }

    @Override
    public VisioShape yReverse(double maxY) {
        double y2 = maxY - this.y;
        return new VisioText(this.id, this.text, this.fontSize, this.x, y2, this.width, this.height);
    }

    private void out(OutputStream os, String s) throws IOException {
        os.write(s.getBytes());
        os.write("\n".getBytes());
    }
}

