/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class OldProxyServlet
extends HttpServlet {
    private static final Pattern PROXY_PATTERN = Pattern.compile("/\\w+/proxy/((\\d+)/)?((\\w+)/)?(http://.*)");
    private String format;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uri = request.getRequestURI();
        Matcher proxyMatcher = PROXY_PATTERN.matcher(uri);
        if (proxyMatcher.matches()) {
            String num = proxyMatcher.group(2);
            this.format = proxyMatcher.group(4);
            String sourceURL = proxyMatcher.group(5);
            this.handleImageProxy(response, num, sourceURL);
        } else {
            request.setAttribute("net.sourceforge.plantuml.servlet.decoded", (Object)("ERROR Invalid proxy syntax : " + uri));
            request.removeAttribute("net.sourceforge.plantuml.servlet.encoded");
            RequestDispatcher dispatcher = request.getRequestDispatcher("/index.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void handleImageProxy(HttpServletResponse response, String num, String source) throws IOException {
        SourceStringReader reader = new SourceStringReader(this.getSource(source));
        int n = num == null ? 0 : Integer.parseInt(num);
        reader.generateImage((OutputStream)response.getOutputStream(), n, new FileFormatOption(this.getOutputFormat(), false));
    }

    private String getSource(String uri) throws IOException {
        CookieModule.setCookiePolicyHandler(null);
        Pattern p = Pattern.compile("http://[^/]+(/?.*)");
        Matcher m = p.matcher(uri);
        if (!m.find()) {
            throw new IOException(uri);
        }
        URL url = new URL(uri);
        HTTPConnection httpConnection = new HTTPConnection(url);
        try {
            HTTPResponse resp = httpConnection.Get(m.group(1));
            return resp.getText();
        }
        catch (ModuleException e) {
            throw new IOException(e.toString());
        }
        catch (ParseException e) {
            throw new IOException(e.toString());
        }
    }

    private FileFormat getOutputFormat() {
        if (this.format == null) {
            return FileFormat.PNG;
        }
        if (this.format.equals("svg")) {
            return FileFormat.SVG;
        }
        if (this.format.equals("eps")) {
            return FileFormat.EPS;
        }
        if (this.format.equals("epstext")) {
            return FileFormat.EPS_TEXT;
        }
        if (this.format.equals("txt")) {
            return FileFormat.ATXT;
        }
        return FileFormat.PNG;
    }
}

