/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.api.PlantumlUtils;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.png.MetadataTag;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlantUmlServlet
extends HttpServlet {
    private static final String DEFAULT_ENCODED_TEXT = "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000";
    public static final Pattern URL_PATTERN = Pattern.compile("^.*[^a-zA-Z0-9\\-\\_]([a-zA-Z0-9\\-\\_]+)");
    private static final Pattern RECOVER_UML_PATTERN = Pattern.compile("/uml/(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String text = request.getParameter("text");
        String metadata = request.getParameter("metadata");
        if (metadata != null) {
            InputStream img = null;
            try {
                img = PlantUmlServlet.getImage((URL)new URL(metadata));
                MetadataTag metadataTag = new MetadataTag(img, "plantuml");
                String data = metadataTag.getData();
                if (data != null) {
                    text = data;
                }
            }
            finally {
                if (img != null) {
                    img.close();
                }
            }
        }
        try {
            text = this.getTextFromUrl(request, text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (text == null || text.trim().isEmpty()) {
            this.redirectNow(request, response, "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000");
            return;
        }
        String encoded = this.getTranscoder().encode(text);
        request.setAttribute("decoded", (Object)text);
        request.setAttribute("encoded", (Object)encoded);
        if (text != null && PlantumlUtils.hasCMapData((String)text)) {
            request.setAttribute("mapneeded", (Object)Boolean.TRUE);
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher("/index.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String text = request.getParameter("text");
        String encoded = "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000";
        try {
            text = this.getTextFromUrl(request, text);
            encoded = this.getTranscoder().encode(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.redirectNow(request, response, encoded);
    }

    private String getTextFromUrl(HttpServletRequest request, String text) throws IOException {
        String url = request.getParameter("url");
        Matcher recoverUml = RECOVER_UML_PATTERN.matcher(request.getRequestURI().substring(request.getContextPath().length()));
        if (recoverUml.matches()) {
            String data = recoverUml.group(1);
            text = this.getTranscoder().decode(data);
        } else if (url != null && !url.trim().isEmpty()) {
            Matcher m1 = URL_PATTERN.matcher(url);
            if (m1.find()) {
                url = m1.group(1);
            }
            text = this.getTranscoder().decode(url);
        }
        return text;
    }

    private void redirectNow(HttpServletRequest request, HttpServletResponse response, String encoded) throws IOException {
        String result = request.getContextPath() + "/uml/" + encoded;
        response.sendRedirect(result);
    }

    private Transcoder getTranscoder() {
        return TranscoderUtil.getDefaultTranscoder();
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        if (url.getProtocol().startsWith("https")) {
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(10000);
            con.connect();
            return con;
        }
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setReadTimeout(10000);
        con.connect();
        return con;
    }

    public static InputStream getImage(URL url) throws IOException {
        InputStream is = null;
        HttpURLConnection con = PlantUmlServlet.getConnection((URL)url);
        is = con.getInputStream();
        return is;
    }

    static {
        OptionFlags.ALLOW_INCLUDE = false;
        if ("true".equalsIgnoreCase(System.getenv("ALLOW_PLANTUML_INCLUDE"))) {
            OptionFlags.ALLOW_INCLUDE = true;
        }
    }
}

