/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.List;
import javax.imageio.IIOException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.servlet.DiagramResponse;

public class ProxyServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        URL srcUrl;
        String fmt = request.getParameter("fmt");
        String source = request.getParameter("src");
        String index = request.getParameter("idx");
        try {
            srcUrl = new URL(source);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return;
        }
        String diagmarkup = this.getSource(srcUrl);
        SourceStringReader reader = new SourceStringReader(diagmarkup);
        int n = index == null ? 0 : Integer.parseInt(index);
        List blocks = reader.getBlocks();
        BlockUml block = (BlockUml)blocks.get(n);
        Diagram diagram = block.getDiagram();
        UmlSource umlSrc = diagram.getSource();
        String uml = umlSrc.getPlainString();
        DiagramResponse dr = new DiagramResponse(response, this.getOutputFormat(fmt), request);
        try {
            dr.sendDiagram(uml, 0);
        }
        catch (IIOException iIOException) {
            // empty catch block
        }
        dr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSource(URL url) throws IOException {
        try {
            String line;
            HttpURLConnection con = this.getConnection(url);
            BufferedReader rd = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line + '\n');
            }
            rd.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Object rd = null;
        }
        return "";
    }

    private FileFormat getOutputFormat(String format) {
        if (format == null) {
            return FileFormat.PNG;
        }
        if (format.equals("svg")) {
            return FileFormat.SVG;
        }
        if (format.equals("eps")) {
            return FileFormat.EPS;
        }
        if (format.equals("epstext")) {
            return FileFormat.EPS_TEXT;
        }
        if (format.equals("txt")) {
            return FileFormat.UTXT;
        }
        return FileFormat.PNG;
    }

    private HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if (con instanceof HttpsURLConnection) {
            // empty if block
        }
        con.setRequestMethod("GET");
        String token = System.getenv("HTTP_AUTHORIZATION");
        if (token != null) {
            con.setRequestProperty("Authorization", token);
        }
        con.setReadTimeout(10000);
        con.connect();
        return con;
    }

    private void printHttpsCert(HttpsURLConnection con) {
        if (con != null) {
            try {
                Certificate[] certs;
                System.out.println("Response Code : " + con.getResponseCode());
                System.out.println("Cipher Suite : " + con.getCipherSuite());
                System.out.println("\n");
                for (Certificate cert : certs = con.getServerCertificates()) {
                    System.out.println("Cert Type : " + cert.getType());
                    System.out.println("Cert Hash Code : " + cert.hashCode());
                    System.out.println("Cert Public Key Algorithm : " + cert.getPublicKey().getAlgorithm());
                    System.out.println("Cert Public Key Format : " + cert.getPublicKey().getFormat());
                    System.out.println("\n");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

