/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.servlet.DiagramResponse;
import net.sourceforge.plantuml.servlet.utility.UmlExtractor;

public abstract class UmlDiagramService
extends HttpServlet {
    private static final Pattern RECOVER_UML_PATTERN = Pattern.compile("/\\w+/(\\d+/)?(.*)");

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uml;
        String[] sourceAndIdx = this.getSourceAndIdx(request);
        int idx = Integer.parseInt(sourceAndIdx[1]);
        try {
            uml = UmlExtractor.getUmlSource((String)sourceAndIdx[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.sendError(400, "Bad Request");
            return;
        }
        this.doDiagramResponse(request, response, uml, idx);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String line;
        String[] sourceAndIdx = this.getSourceAndIdx(request);
        int idx = Integer.parseInt(sourceAndIdx[1]);
        StringBuilder uml = new StringBuilder();
        BufferedReader in = request.getReader();
        while ((line = in.readLine()) != null) {
            uml.append(line).append('\n');
        }
        this.doDiagramResponse(request, response, uml.toString(), idx);
    }

    private void doDiagramResponse(HttpServletRequest request, HttpServletResponse response, String uml, int idx) throws IOException {
        DiagramResponse dr = new DiagramResponse(response, this.getOutputFormat(), request);
        try {
            dr.sendDiagram(uml, idx);
        }
        catch (IIOException iIOException) {
            // empty catch block
        }
        dr = null;
    }

    public final String[] getSourceAndIdx(HttpServletRequest request) {
        String data;
        Matcher recoverUml = RECOVER_UML_PATTERN.matcher(request.getRequestURI().substring(request.getContextPath().length()));
        if (recoverUml.matches() && (data = recoverUml.group(2)).length() >= 4) {
            String idx = recoverUml.group(1);
            idx = idx == null ? "0" : idx.substring(0, idx.length() - 1);
            return new String[]{data, idx};
        }
        return new String[]{"", "0"};
    }

    public abstract FileFormat getOutputFormat();
}

