/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet.utility;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;

public class UmlExtractor {
    public static String getUmlSource(String source) {
        String uml;
        String text;
        try {
            text = URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            text = "' invalid encoded string";
        }
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        try {
            text = transcoder.decode(text);
        }
        catch (IOException ioe) {
            text = "' unable to decode string";
        }
        if (text.startsWith("@start")) {
            uml = text;
        } else {
            StringBuilder plantUmlSource = new StringBuilder();
            plantUmlSource.append("@startuml\n");
            plantUmlSource.append(text);
            if (!text.endsWith("\n")) {
                plantUmlSource.append("\n");
            }
            plantUmlSource.append("@enduml");
            uml = plantUmlSource.toString();
        }
        return uml;
    }

    protected UmlExtractor() {
        throw new UnsupportedOperationException();
    }
}

