/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.URLEncoder;
import net.sourceforge.plantuml.code.Upf9Encoder;

public class TranscoderImpl
implements Transcoder {
    private final Compression compression;
    private final URLEncoder urlEncoder;
    private final StringCompressor stringCompressor;
    private final Format format;

    private TranscoderImpl(URLEncoder urlEncoder, StringCompressor stringCompressor, Compression compression, Format format) {
        this.compression = compression;
        this.urlEncoder = urlEncoder;
        this.stringCompressor = stringCompressor;
        this.format = format;
    }

    public static Transcoder utf8(URLEncoder urlEncoder, StringCompressor stringCompressor, Compression compression) {
        return new TranscoderImpl(urlEncoder, stringCompressor, compression, Format.UTF8);
    }

    public static Transcoder upf9(URLEncoder urlEncoder, StringCompressor stringCompressor, Compression compression) {
        return new TranscoderImpl(urlEncoder, stringCompressor, compression, Format.UPF9);
    }

    @Override
    public String encode(String text) throws IOException {
        String stringAnnoted = this.stringCompressor.compress(text);
        byte[] data = this.format == Format.UTF8 ? stringAnnoted.getBytes("UTF-8") : Upf9Encoder.getBytes(stringAnnoted);
        byte[] compressedData = this.compression.compress(data);
        return this.urlEncoder.encode(compressedData);
    }

    @Override
    public String decode(String code) throws NoPlantumlCompressionException {
        try {
            byte[] compressedData = this.urlEncoder.decode(code);
            ByteArray data = this.compression.decompress(compressedData);
            String string = this.format == Format.UTF8 ? data.toUFT8String() : data.toUPF9String();
            return this.stringCompressor.decompress(string);
        }
        catch (Exception e) {
            System.err.println("Cannot decode string");
            throw new NoPlantumlCompressionException(e);
        }
    }

    static enum Format {
        UTF8,
        UPF9;

    }
}

