/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.PrintScale;

public class CommandPrintScale
extends SingleLineCommand2<GanttDiagram> {
    public CommandPrintScale() {
        super(CommandPrintScale.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPrintScale.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("projectscale"), new RegexLeaf("ganttscale"), new RegexLeaf("printscale")), RegexLeaf.spaceOneOrMore(), new RegexOr("SCALE", new RegexLeaf("monthly"), new RegexLeaf("daily"), new RegexLeaf("weekly")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) {
        String scaleString = arg.get("SCALE", 0);
        PrintScale scale = PrintScale.fromString(scaleString);
        diagram.setPrintScale(scale);
        return CommandExecutionResult.ok();
    }
}

