/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.Wink;

public class GCalendar {
    private final Day start;

    public GCalendar(Day start) {
        this.start = start;
    }

    public Day toDayAsDate(Wink day) {
        Day result = this.start;
        int target = day.getWink();
        for (int work = 0; work < target; ++work) {
            result = result.next();
        }
        return result;
    }

    public Wink fromDayAsDate(Day day) {
        if (day.compareTo(this.start) < 0) {
            throw new IllegalArgumentException();
        }
        Wink result = new Wink(0);
        while (!this.toDayAsDate(result).equals(day)) {
            result = result.increment();
        }
        return result;
    }

    public Day getStartingDate() {
        return this.start;
    }
}

