/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverRectangleSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        URectangle rect = (URectangle)ushape;
        double rx = rect.getRx();
        double ry = rect.getRy();
        double width = rect.getWidth();
        double height = rect.getHeight();
        HColor back = param.getBackcolor();
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
            svg.setFillColor("url(#" + id + ")");
            DriverRectangleSvg.applyColor(svg, mapper, param);
        } else {
            String backcolor = mapper.toSvg(back);
            svg.setFillColor(backcolor);
            DriverRectangleSvg.applyColor(svg, mapper, param);
        }
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
            if (height <= 0.0) {
                return;
            }
        }
        svg.svgRectangle(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow(), rect.getComment());
    }

    public static void applyColor(SvgGraphics svg, ColorMapper mapper, UParam param) {
        HColor color = param.getColor();
        if (color instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)color;
            String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
            svg.setStrokeColor("url(#" + id + ")");
        } else {
            svg.setStrokeColor(mapper.toSvg(color));
        }
    }
}

