/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smetana.core.CType;
import smetana.core.JUtils;

public class Bucket {
    public final String name;
    public final CType ctype;
    private final boolean inlineStruct;

    private Bucket addPrefix(String prefix) {
        return new Bucket(prefix + "." + this.name, this.ctype, this.inlineStruct);
    }

    public static Bucket buildEnum(String name, List<String> definition) {
        return new Bucket(name, new CType("enum"), false);
    }

    Bucket(String name, String type, boolean inlineStruct) {
        this(name, new CType(type), inlineStruct);
    }

    private Bucket(String name, CType ctype, boolean inlineStruct) {
        this.name = name;
        this.ctype = ctype;
        this.inlineStruct = inlineStruct;
    }

    public String toString() {
        return "[" + this.ctype + "==" + this.name + "]";
    }

    public boolean inlineStruct() {
        return this.inlineStruct;
    }

    public boolean functionPointer() {
        if (this.ctype == null) {
            return false;
        }
        return this.ctype.functionPointer();
    }

    public static Map<String, Bucket> buildSome(Iterator<String> it) {
        String def = it.next();
        JUtils.LOG("DEF1=" + def);
        def = def.replaceAll("unsigned int", "int");
        def = def.replaceAll("unsigned long", "int");
        def = def.replaceAll("unsigned short", "short");
        def = def.replaceAll("unsigned char", "char");
        def = def.replaceAll("const ", "");
        def = def.replaceAll("struct ", "");
        def = def.replaceAll("\\[\\s*[+]1\\s*[+]1\\s*[+]1\\s*[+]1\\s*[+]1\\s*\\]", "[5]");
        if (def.equals("union")) {
            return Bucket.createStruct(it);
        }
        if (def.equals("struct")) {
            return Bucket.createStruct(it);
        }
        LinkedHashMap<String, Bucket> result = new LinkedHashMap<String, Bucket>();
        Pattern p1 = Pattern.compile("^(\\w+)\\s+(\\w+)$");
        Matcher m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            boolean inline = !CType.isPrimitive(type);
            result.put(m1.group(2), new Bucket(m1.group(2), type, inline));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            boolean inline = !CType.isPrimitive(type);
            result.put(m1.group(2), new Bucket(m1.group(2), type, inline));
            result.put(m1.group(3), new Bucket(m1.group(3), type, inline));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            boolean inline = !CType.isPrimitive(type);
            result.put(m1.group(2), new Bucket(m1.group(2), type, inline));
            result.put(m1.group(3), new Bucket(m1.group(3), type, inline));
            result.put(m1.group(4), new Bucket(m1.group(4), type, inline));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            boolean inline = !CType.isPrimitive(type);
            result.put(m1.group(2), new Bucket(m1.group(2), type, inline));
            result.put(m1.group(3), new Bucket(m1.group(3), type, inline));
            result.put(m1.group(4), new Bucket(m1.group(4), type, inline));
            result.put(m1.group(5), new Bucket(m1.group(5), type, inline));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            boolean inline = !CType.isPrimitive(type);
            result.put(m1.group(2), new Bucket(m1.group(2), type, inline));
            result.put(m1.group(3), new Bucket(m1.group(3), type, inline));
            result.put(m1.group(4), new Bucket(m1.group(4), type, inline));
            result.put(m1.group(5), new Bucket(m1.group(5), type, inline));
            result.put(m1.group(6), new Bucket(m1.group(6), type, inline));
            return result;
        }
        p1 = Pattern.compile("^.*(\\(\\*(\\w+)\\)).*$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(1), new Bucket(m1.group(2), def, false));
            return result;
        }
        p1 = Pattern.compile("^(void)\\s+\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(2), new Bucket(m1.group(2), "void*", false));
            return result;
        }
        p1 = Pattern.compile("^(char)\\s+\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(2), new Bucket(m1.group(2), "CString", false));
            return result;
        }
        p1 = Pattern.compile("^(int)\\s+\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(2), new Bucket(m1.group(2), "int*", false));
            return result;
        }
        p1 = Pattern.compile("^(char)\\s+\\*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(2), new Bucket(m1.group(2), "CString[]", false));
            return result;
        }
        p1 = Pattern.compile("^(void)(\\s+\\*|\\*\\s+)(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = "void*";
            result.put(m1.group(3), new Bucket(m1.group(3), "void*", false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)(\\s+\\*|\\*\\s+)(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            result.put(m1.group(3), new Bucket(m1.group(3), type, false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            result.put(m1.group(3), new Bucket(m1.group(3), type, false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            result.put(m1.group(3), new Bucket(m1.group(3), type, false));
            result.put(m1.group(4), new Bucket(m1.group(4), type, false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            result.put(m1.group(3), new Bucket(m1.group(3), type, false));
            result.put(m1.group(4), new Bucket(m1.group(4), type, false));
            result.put(m1.group(5), new Bucket(m1.group(5), type, false));
            return result;
        }
        p1 = Pattern.compile("^(unsigned|int)\\s+(\\w+):([-sizeof ntunsged()0-9*]+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(2), new Bucket(m1.group(2), "int", false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+(\\w+)\\[\\d+\\]$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            result.put(m1.group(1), new Bucket(m1.group(2), def, true));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*(\\w+)\\[\\d+\\]$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            Bucket tmp = new Bucket(m1.group(2), def, false);
            JUtils.LOG("size=" + tmp.getArrayLength());
            result.put(m1.group(1), tmp);
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1) + "*";
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*\\*(\\w+),\\s*\\*\\*(\\w+),\\s*\\*\\*(\\w+),\\s*\\*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1) + "*";
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            result.put(m1.group(3), new Bucket(m1.group(3), type, false));
            result.put(m1.group(4), new Bucket(m1.group(4), type, false));
            result.put(m1.group(5), new Bucket(m1.group(5), type, false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*\\*(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1);
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            result.put(m1.group(3), new Bucket(m1.group(3), type + "*", false));
            return result;
        }
        p1 = Pattern.compile("^(\\w+)\\*\\*\\s+(\\w+)$");
        m1 = p1.matcher(def);
        if (m1.find()) {
            String type = m1.group(1) + "*";
            result.put(m1.group(2), new Bucket(m1.group(2), type, false));
            return result;
        }
        if (def.equals("double **dist, **spring, **sum_t, ***t")) {
            return result;
        }
        if (def.equals("double *pos, dist")) {
            result.put("pos", new Bucket("pos", "double*", false));
            result.put("dist", new Bucket("dist", "double", false));
            return result;
        }
        JUtils.LOG("def=" + def);
        throw new UnsupportedOperationException(def);
    }

    private static Map<String, Bucket> createStruct(Iterator<String> it) {
        String current = it.next();
        if (!current.equals("{")) {
            throw new UnsupportedOperationException("current=" + current);
        }
        LinkedHashMap<String, Bucket> tmp = new LinkedHashMap<String, Bucket>();
        ArrayList<String> inner = new ArrayList<String>();
        while (true) {
            if ((current = it.next()).equals("union") || current.equals("struct")) {
                Map<String, Bucket> internal = Bucket.createStruct(it);
                JUtils.LOG("internal=" + internal);
                tmp.putAll(internal);
                continue;
            }
            if (current.endsWith("}")) {
                String name = it.next();
                JUtils.LOG("name=" + name);
                JUtils.LOG("inner=" + inner);
                Iterator<String> innerIt = inner.iterator();
                while (innerIt.hasNext()) {
                    tmp.putAll(Bucket.buildSome(innerIt));
                }
                LinkedHashMap<String, Bucket> result = new LinkedHashMap<String, Bucket>();
                for (Map.Entry ent : tmp.entrySet()) {
                    String n = (String)ent.getKey();
                    Bucket bucket = ((Bucket)ent.getValue()).addPrefix(name);
                    JUtils.LOG("n=" + n);
                    JUtils.LOG("bucket=" + bucket);
                    result.put(name + "." + n, bucket);
                }
                return result;
            }
            inner.add(current);
        }
    }

    public int getArrayLength() {
        if (this.ctype == null) {
            return 0;
        }
        return this.ctype.getArrayLength();
    }
}

