/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@InstrumentationTarget(value="java.io.RandomAccessFile")
public final class RandomAccessFileRMHooks {
    private FileDescriptor fd;
    private final String path;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public RandomAccessFileRMHooks() {
        this.path = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void open(String string, int n) throws FileNotFoundException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
        long l = 0L;
        long l2 = 0L;
        try {
            l2 = resourceRequest.request(1L, resourceIdImpl);
            if (l2 < 1L) {
                throw new FileNotFoundException(string + ": resource limited: too many open files");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open files");
            fileNotFoundException.initCause(resourceRequestDeniedException);
            throw fileNotFoundException;
        }
        ResourceRequest resourceRequest2 = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
        int n2 = 0;
        try {
            try {
                l = resourceRequest2.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                fileNotFoundException.initCause(resourceRequestDeniedException);
                throw fileNotFoundException;
            }
            this.open(string, n);
            n2 = 1;
        }
        finally {
            resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
            resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read() throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n = -1;
        try {
            n = this.read();
            resourceRequest.request(-(l - (long)(n == -1 ? 0 : 1)), resourceIdImpl);
        }
        catch (Throwable throwable) {
            resourceRequest.request(-(l - (long)(n == -1 ? 0 : 1)), resourceIdImpl);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray) throws IOException {
        int n;
        if (byArray == null) {
            return this.read(byArray);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        int n2 = byArray.length;
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(n2, resourceIdImpl), 0L);
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n3 = 0;
        try {
            if (l < (long)n2) {
                resourceRequest.request(-l, resourceIdImpl);
                n = this.read(byArray, 0, byArray.length);
                n3 = Math.max(n, 0);
            } else {
                n = this.read(byArray);
                n3 = Math.max(n, 0);
            }
        }
        finally {
            resourceRequest.request(-(l - (long)n3), resourceIdImpl);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            return this.read(byArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(n2, resourceIdImpl), 0L);
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        n2 = Math.min(n2, (int)l);
        int n3 = 0;
        int n4 = 0;
        try {
            n4 = this.read(byArray, n, n2);
            n3 = Math.max(n4, 0);
        }
        finally {
            resourceRequest.request(-(l - (long)n3), resourceIdImpl);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(int n) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.write(n);
            n2 = 1;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.write(byArray);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        int n = byArray.length;
        long l = 0L;
        try {
            l = resourceRequest.request(n, resourceIdImpl);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.write(byArray);
            n2 = n;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            this.write(byArray, n, n2);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(n2, resourceIdImpl);
            if (l < (long)n2) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n3 = 0;
        try {
            this.write(byArray, n, n2);
            n3 = n2;
        }
        finally {
            resourceRequest.request(-(l - (long)n3), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public final void writeBytes(String string) throws IOException {
        if (string == null) {
            this.writeBytes(string);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        int n = string.length();
        long l = 0L;
        try {
            l = resourceRequest.request(n, resourceIdImpl);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.writeBytes(string);
            n2 = n;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public final void writeChars(String string) throws IOException {
        if (string == null) {
            this.writeChars(string);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        int n = 2 * string.length();
        long l = 0L;
        try {
            l = resourceRequest.request(n, resourceIdImpl);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.writeChars(string);
            n2 = n;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void close() throws IOException {
        long l;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        try {
            l = javaIOFileDescriptorAccess.getHandle(this.fd);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(this.fd);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            l = javaIOFileDescriptorAccess.get(this.fd);
        }
        try {
            this.close();
        }
        finally {
            ResourceRequest resourceRequest;
            long l2;
            try {
                l2 = javaIOFileDescriptorAccess.getHandle(this.fd);
                if (l2 == -1L) {
                    l2 = javaIOFileDescriptorAccess.get(this.fd);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                l2 = javaIOFileDescriptorAccess.get(this.fd);
            }
            ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
            if (l2 != l) {
                resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
                resourceRequest.request(-1L, resourceIdImpl);
            }
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
            resourceRequest.request(-1L, resourceIdImpl);
        }
    }
}

