/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CompoundUnaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.tagger.common.Tagger;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.ScoredObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;

public abstract class BaseModel
implements Serializable {
    final ShiftReduceOptions op;
    final Index<Transition> transitionIndex;
    final Set<String> knownStates;
    final Set<String> rootStates;
    final Set<String> rootOnlyStates;
    private static final long serialVersionUID = -175375535849840611L;

    public BaseModel(ShiftReduceOptions op, Index<Transition> transitionIndex, Set<String> knownStates, Set<String> rootStates, Set<String> rootOnlyStates) {
        this.transitionIndex = transitionIndex;
        this.op = op;
        this.knownStates = knownStates;
        this.rootStates = rootStates;
        this.rootOnlyStates = rootOnlyStates;
    }

    public BaseModel(BaseModel other) {
        this.op = other.op;
        this.transitionIndex = other.transitionIndex;
        this.knownStates = other.knownStates;
        this.rootStates = other.rootStates;
        this.rootOnlyStates = other.rootOnlyStates;
    }

    public Transition findEmergencyTransition(State state, List<ParserConstraint> constraints) {
        if (state.stack.size() == 0) {
            return null;
        }
        if (constraints != null) {
            Tree top = state.stack.peek();
            for (ParserConstraint constraint : constraints) {
                if (ShiftReduceUtils.leftIndex(top) != constraint.start || ShiftReduceUtils.rightIndex(top) != constraint.end - 1 || ShiftReduceUtils.constraintMatchesTreeTop(top, constraint)) continue;
                for (String label : this.knownStates) {
                    if (!constraint.state.matcher(label).matches()) continue;
                    return this.op.compoundUnaries ? new CompoundUnaryTransition(Collections.singletonList(label), false) : new UnaryTransition(label, false);
                }
            }
        }
        if (ShiftReduceUtils.isTemporary(state.stack.peek()) && (state.stack.size() == 1 || ShiftReduceUtils.isTemporary(state.stack.pop().peek()))) {
            return this.op.compoundUnaries ? new CompoundUnaryTransition(Collections.singletonList(state.stack.peek().value().substring(1)), false) : new UnaryTransition(state.stack.peek().value().substring(1), false);
        }
        if (state.stack.size() == 1 && state.tokenPosition >= state.sentence.size() && !this.rootStates.contains(state.stack.peek().value())) {
            String root = this.rootStates.iterator().next();
            return this.op.compoundUnaries ? new CompoundUnaryTransition(Collections.singletonList(root), false) : new UnaryTransition(root, false);
        }
        if (state.stack.size() == 1) {
            return null;
        }
        if (ShiftReduceUtils.isTemporary(state.stack.peek())) {
            return new BinaryTransition(state.stack.peek().value().substring(1), BinaryTransition.Side.RIGHT);
        }
        if (ShiftReduceUtils.isTemporary(state.stack.pop().peek())) {
            return new BinaryTransition(state.stack.pop().peek().value().substring(1), BinaryTransition.Side.LEFT);
        }
        return null;
    }

    public abstract Collection<ScoredObject<Integer>> findHighestScoringTransitions(State var1, boolean var2, int var3, List<ParserConstraint> var4);

    public abstract void trainModel(String var1, Tagger var2, Random var3, List<Tree> var4, List<List<Transition>> var5, Treebank var6, int var7);

    abstract Set<String> tagSet();
}

