/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.util.ReflectionLoading;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Function;

public class SeqClassifierFlags
implements Serializable {
    private static final long serialVersionUID = -7076671761070232567L;
    public static final String DEFAULT_BACKGROUND_SYMBOL = "O";
    private String stringRep = "";
    public boolean useNGrams = false;
    public boolean conjoinShapeNGrams = false;
    public boolean lowercaseNGrams = false;
    public boolean dehyphenateNGrams = false;
    public boolean usePrev = false;
    public boolean useNext = false;
    public boolean useTags = false;
    public boolean useWordPairs = false;
    public boolean useGazettes = false;
    public boolean useSequences = true;
    public boolean usePrevSequences = false;
    public boolean useNextSequences = false;
    public boolean useLongSequences = false;
    public boolean useBoundarySequences = false;
    public boolean useTaggySequences = false;
    public boolean useExtraTaggySequences = false;
    public boolean dontExtendTaggy = false;
    public boolean useTaggySequencesShapeInteraction = false;
    public boolean strictlyZeroethOrder = false;
    public boolean strictlyFirstOrder = false;
    public boolean strictlySecondOrder = false;
    public boolean strictlyThirdOrder = false;
    public String entitySubclassification = "IO";
    public boolean retainEntitySubclassification = false;
    public boolean useGazettePhrases = false;
    public boolean makeConsistent = false;
    public boolean useViterbi = true;
    public int[] binnedLengths = null;
    public boolean verboseMode = false;
    public boolean useSum = false;
    public double tolerance = 1.0E-4;
    public String printFeatures = null;
    public boolean useSymTags = false;
    public boolean useSymWordPairs = false;
    public String printClassifier = "WeightHistogram";
    public int printClassifierParam = 100;
    public boolean intern = false;
    public boolean intern2 = false;
    public boolean selfTest = false;
    public boolean sloppyGazette = false;
    public boolean cleanGazette = false;
    public boolean noMidNGrams = false;
    public int maxNGramLeng = -1;
    public boolean useReverse = false;
    public boolean greekifyNGrams = false;
    public boolean useParenMatching = false;
    public boolean useLemmas = false;
    public boolean usePrevNextLemmas = false;
    public boolean normalizeTerms = false;
    public boolean normalizeTimex = false;
    public boolean useNB = false;
    public boolean useQN = true;
    public boolean useFloat = false;
    public int QNsize = 25;
    public int QNsize2 = 25;
    public int maxIterations = -1;
    public int wordShape = -1;
    public boolean useShapeStrings = false;
    public boolean useTypeSeqs = false;
    public boolean useTypeSeqs2 = false;
    public boolean useTypeSeqs3 = false;
    public boolean useDisjunctive = false;
    public int disjunctionWidth = 4;
    public boolean useDisjunctiveShapeInteraction = false;
    public boolean useDisjShape = false;
    public boolean useWord = true;
    public boolean useClassFeature = false;
    public boolean useShapeConjunctions = false;
    public boolean useWordTag = false;
    public boolean useNPHead = false;
    public boolean useNPGovernor = false;
    public boolean useHeadGov = false;
    public boolean useLastRealWord = false;
    public boolean useNextRealWord = false;
    public boolean useOccurrencePatterns = false;
    public boolean useTypeySequences = false;
    public boolean justify = false;
    public boolean normalize = false;
    public String priorType = "QUADRATIC";
    public double sigma = 1.0;
    public double epsilon = 0.01;
    public int beamSize = 30;
    public int maxLeft = 2;
    public int maxRight = 0;
    public boolean usePosition = false;
    public boolean useBeginSent = false;
    public boolean useGazFeatures = false;
    public boolean useMoreGazFeatures = false;
    public boolean useAbbr = false;
    public boolean useMinimalAbbr = false;
    public boolean useAbbr1 = false;
    public boolean useMinimalAbbr1 = false;
    public boolean useMoreAbbr = false;
    public boolean deleteBlankLines = false;
    public boolean useGENIA = false;
    public boolean useTOK = false;
    public boolean useABSTR = false;
    public boolean useABSTRFreqDict = false;
    public boolean useABSTRFreq = false;
    public boolean useFREQ = false;
    public boolean useABGENE = false;
    public boolean useWEB = false;
    public boolean useWEBFreqDict = false;
    public boolean useIsURL = false;
    public boolean useURLSequences = false;
    public boolean useIsDateRange = false;
    public boolean useEntityTypes = false;
    public boolean useEntityTypeSequences = false;
    public boolean useEntityRule = false;
    public boolean useOrdinal = false;
    public boolean useACR = false;
    public boolean useANTE = false;
    public boolean useMoreTags = false;
    public boolean useChunks = false;
    public boolean useChunkySequences = false;
    public boolean usePrevVB = false;
    public boolean useNextVB = false;
    public boolean useVB = false;
    public boolean subCWGaz = false;
    public String documentReader = "ColumnDocumentReader";
    public String map = "word=0,tag=1,answer=2";
    public boolean useWideDisjunctive = false;
    public int wideDisjunctionWidth = 10;
    public boolean useRadical = false;
    public boolean useBigramInTwoClique = false;
    public String morphFeatureFile = null;
    public boolean useReverseAffix = false;
    public int charHalfWindow = 3;
    public boolean useWord1 = false;
    public boolean useWord2 = false;
    public boolean useWord3 = false;
    public boolean useWord4 = false;
    public boolean useRad1 = false;
    public boolean useRad2 = false;
    public boolean useWordn = false;
    public boolean useCTBPre1 = false;
    public boolean useCTBSuf1 = false;
    public boolean useASBCPre1 = false;
    public boolean useASBCSuf1 = false;
    public boolean usePKPre1 = false;
    public boolean usePKSuf1 = false;
    public boolean useHKPre1 = false;
    public boolean useHKSuf1 = false;
    public boolean useCTBChar2 = false;
    public boolean useASBCChar2 = false;
    public boolean useHKChar2 = false;
    public boolean usePKChar2 = false;
    public boolean useRule2 = false;
    public boolean useDict2 = false;
    public boolean useOutDict2 = false;
    public String outDict2 = "/u/htseng/scr/chunking/segmentation/out.lexicon";
    public boolean useDictleng = false;
    public boolean useDictCTB2 = false;
    public boolean useDictASBC2 = false;
    public boolean useDictPK2 = false;
    public boolean useDictHK2 = false;
    public boolean useBig5 = false;
    public boolean useNegDict2 = false;
    public boolean useNegDict3 = false;
    public boolean useNegDict4 = false;
    public boolean useNegCTBDict2 = false;
    public boolean useNegCTBDict3 = false;
    public boolean useNegCTBDict4 = false;
    public boolean useNegASBCDict2 = false;
    public boolean useNegASBCDict3 = false;
    public boolean useNegASBCDict4 = false;
    public boolean useNegHKDict2 = false;
    public boolean useNegHKDict3 = false;
    public boolean useNegHKDict4 = false;
    public boolean useNegPKDict2 = false;
    public boolean useNegPKDict3 = false;
    public boolean useNegPKDict4 = false;
    public boolean usePre = false;
    public boolean useSuf = false;
    public boolean useRule = false;
    public boolean useHk = false;
    public boolean useMsr = false;
    public boolean useMSRChar2 = false;
    public boolean usePk = false;
    public boolean useAs = false;
    public boolean useFilter = false;
    public boolean largeChSegFile = false;
    public boolean useRad2b = false;
    public boolean keepEnglishWhitespaces = false;
    public boolean keepAllWhitespaces = false;
    public boolean sighanPostProcessing = false;
    public boolean useChPos = false;
    public String normalizationTable;
    public String dictionary;
    public String serializedDictionary;
    public String dictionary2;
    public String normTableEncoding = "GB18030";
    public String sighanCorporaDict = "/u/nlp/data/chinese-segmenter/";
    public boolean useWordShapeGaz = false;
    public String wordShapeGaz = null;
    public boolean splitDocuments = true;
    public boolean printXML;
    public boolean useSeenFeaturesOnly = false;
    public String lastNameList = "/u/nlp/data/dist.all.last";
    public String maleNameList = "/u/nlp/data/dist.male.first";
    public String femaleNameList = "/u/nlp/data/dist.female.first";
    public transient String trainFile = null;
    public transient String adaptFile = null;
    public transient String devFile = null;
    public transient String testFile = null;
    public transient String textFile = null;
    public transient String textFiles = null;
    public transient boolean readStdin = false;
    public transient String outputFile = null;
    public transient String loadClassifier = null;
    public transient String loadTextClassifier = null;
    public transient String loadJarClassifier = null;
    public transient String loadAuxClassifier = null;
    public transient String serializeTo = null;
    public transient String serializeToText = null;
    public transient int interimOutputFreq = 0;
    public transient String initialWeights = null;
    public transient List<String> gazettes = new ArrayList<String>();
    public transient String selfTrainFile = null;
    public String inputEncoding = "UTF-8";
    public boolean bioSubmitOutput = false;
    public int numRuns = 1;
    public String answerFile = null;
    public String altAnswerFile = null;
    public String dropGaz;
    public String printGazFeatures = null;
    public int numStartLayers = 1;
    public boolean dump = false;
    public boolean mergeTags;
    public boolean splitOnHead;
    public int featureCountThreshold = 0;
    public double featureWeightThreshold = 0.0;
    public String featureFactory = "edu.stanford.nlp.ie.NERFeatureFactory";
    public Object[] featureFactoryArgs = new Object[0];
    public String backgroundSymbol = "O";
    public boolean useObservedSequencesOnly = false;
    public int maxDocSize = 0;
    public boolean printProbs = false;
    public boolean printFirstOrderProbs = false;
    public boolean saveFeatureIndexToDisk = false;
    public boolean removeBackgroundSingletonFeatures = false;
    public boolean doGibbs = false;
    public int numSamples = 100;
    public boolean useNERPrior = false;
    public boolean useAcqPrior = false;
    public boolean useUniformPrior = false;
    public boolean useMUCFeatures = false;
    public double annealingRate = 0.0;
    public String annealingType = null;
    public String loadProcessedData = null;
    public boolean initViterbi = true;
    public boolean useUnknown = false;
    public boolean checkNameList = false;
    public boolean useSemPrior = false;
    public boolean useFirstWord = false;
    public boolean useNumberFeature = false;
    public int ocrFold = 0;
    public transient boolean ocrTrain = false;
    public String classifierType = "MaxEnt";
    public String svmModelFile = null;
    public String inferenceType = "Viterbi";
    public boolean useLemmaAsWord = false;
    public String type = "cmm";
    public String readerAndWriter = "edu.stanford.nlp.sequences.ColumnDocumentReaderAndWriter";
    public List<String> comboProps = new ArrayList<String>();
    public boolean usePrediction = false;
    public boolean useAltGazFeatures = false;
    public String gazFilesFile = null;
    public boolean usePrediction2 = false;
    public String baseTrainDir = ".";
    public String baseTestDir = ".";
    public String trainFiles = null;
    public String trainFileList = null;
    public String testFiles = null;
    public String trainDirs = null;
    public String testDirs = null;
    public boolean useOnlySeenWeights = false;
    public String predProp = null;
    public CoreLabel pad = new CoreLabel();
    public boolean useObservedFeaturesOnly = false;
    public String distSimLexicon = null;
    public boolean useDistSim = false;
    public int removeTopN = 0;
    public int numTimesRemoveTopN = 1;
    public double randomizedRatio = 1.0;
    public double removeTopNPercent = 0.0;
    public int purgeFeatures = -1;
    public boolean booleanFeatures = false;
    public boolean iobWrapper = false;
    public boolean iobTags = false;
    public boolean useSegmentation = false;
    public boolean memoryThrift = false;
    public boolean timitDatum = false;
    public String serializeDatasetsDir = null;
    public String loadDatasetsDir = null;
    public String pushDir = null;
    public boolean purgeDatasets = false;
    public boolean keepOBInMemory = true;
    public boolean fakeDataset = false;
    public boolean restrictTransitionsTimit = false;
    public int numDatasetsPerFile = 1;
    public boolean useTitle = false;
    public boolean lowerNewgeneThreshold = false;
    public boolean useEitherSideWord = false;
    public boolean useEitherSideDisjunctive = false;
    public boolean twoStage = false;
    public String crfType = "MaxEnt";
    public int featureThreshold = 1;
    public String featThreshFile = null;
    public double featureDiffThresh = 0.0;
    public int numTimesPruneFeatures = 0;
    public double newgeneThreshold = 0.0;
    public boolean doAdaptation = false;
    public boolean useInternal = true;
    public boolean useExternal = true;
    public double selfTrainConfidenceThreshold = 0.9;
    public int selfTrainIterations = 1;
    public int selfTrainWindowSize = 1;
    public boolean useHuber = false;
    public boolean useQuartic = false;
    public double adaptSigma = 1.0;
    public int numFolds = 1;
    public int startFold = 1;
    public int endFold = 1;
    public boolean cacheNGrams = false;
    public String outputFormat;
    public boolean useSMD = false;
    public boolean useSGDtoQN = false;
    public boolean useStochasticQN = false;
    public boolean useScaledSGD = false;
    public int scaledSGDMethod = 0;
    public int SGDPasses = -1;
    public int QNPasses = -1;
    public boolean tuneSGD = false;
    public StochasticCalculateMethods stochasticMethod = StochasticCalculateMethods.NoneSpecified;
    public double initialGain = 0.1;
    public int stochasticBatchSize = 15;
    public boolean useSGD = false;
    public double gainSGD = 0.1;
    public boolean useHybrid = false;
    public int hybridCutoffIteration = 0;
    public boolean outputIterationsToFile = false;
    public boolean testObjFunction = false;
    public boolean testVariance = false;
    public int SGD2QNhessSamples = 50;
    public boolean testHessSamples = false;
    public int CRForder = 1;
    public int CRFwindow = 2;
    public boolean estimateInitial = false;
    public transient String biasedTrainFile = null;
    public transient String confusionMatrix = null;
    public String outputEncoding = null;
    public boolean useKBest = false;
    public String searchGraphPrefix = null;
    public double searchGraphPrune = Double.POSITIVE_INFINITY;
    public int kBest = 1;
    public boolean useFeaturesC4gram;
    public boolean useFeaturesC5gram;
    public boolean useFeaturesC6gram;
    public boolean useFeaturesCpC4gram;
    public boolean useFeaturesCpC5gram;
    public boolean useFeaturesCpC6gram;
    public boolean useUnicodeType;
    public boolean useUnicodeType4gram;
    public boolean useUnicodeType5gram;
    public boolean use4Clique;
    public boolean useUnicodeBlock;
    public boolean useShapeStrings1;
    public boolean useShapeStrings3;
    public boolean useShapeStrings4;
    public boolean useShapeStrings5;
    public boolean useGoodForNamesCpC;
    public boolean useDictionaryConjunctions;
    public boolean expandMidDot;
    public int printFeaturesUpto = Integer.MAX_VALUE;
    public boolean useDictionaryConjunctions3;
    public boolean useWordUTypeConjunctions2;
    public boolean useWordUTypeConjunctions3;
    public boolean useWordShapeConjunctions2;
    public boolean useWordShapeConjunctions3;
    public boolean useMidDotShape;
    public boolean augmentedDateChars;
    public boolean suppressMidDotPostprocessing;
    public boolean printNR;
    public String classBias = null;
    public boolean printLabelValue;
    public boolean useRobustQN = false;
    public boolean combo = false;
    public boolean useGenericFeatures = false;
    public boolean verboseForTrueCasing = false;
    public String trainHierarchical = null;
    public String domain = null;
    public boolean baseline = false;
    public String transferSigmas = null;
    public boolean doFE = false;
    public boolean restrictLabels = true;
    public boolean announceObjectBankEntries = false;
    public double l1reg = 0.0;
    public String mixedCaseMapFile = "";
    public String auxTrueCaseModels = "";
    public boolean use2W = false;
    public boolean useLC = false;
    public boolean useYetMoreCpCShapes = false;
    public boolean useIfInteger = false;
    public String exportFeatures = null;
    public boolean useInPlaceSGD = false;
    public boolean useTopics = false;
    public int evaluateIters = 0;
    public String evalCmd = "";
    public boolean evaluateTrain = false;
    public int tuneSampleSize = -1;
    public boolean usePhraseFeatures = false;
    public boolean usePhraseWords = false;
    public boolean usePhraseWordTags = false;
    public boolean usePhraseWordSpecialTags = false;
    public boolean useCommonWordsFeature = false;
    public boolean useProtoFeatures = false;
    public boolean useWordnetFeatures = false;
    public String tokenFactory = "edu.stanford.nlp.process.CoreLabelTokenFactory";
    public Object[] tokenFactoryArgs = new Object[0];
    public String tokensAnnotationClassName = "edu.stanford.nlp.ling.CoreAnnotations$TokensAnnotation";
    public transient String tokenizerOptions = null;
    public transient String tokenizerFactory = null;
    public boolean useCorefFeatures = false;
    public String wikiFeatureDbFile = null;
    public boolean useNoisyNonNoisyFeature = false;
    public boolean useYear = false;
    public boolean useSentenceNumber = false;
    public boolean useLabelSource = false;
    public boolean casedDistSim = false;
    public String distSimFileFormat = "alexClark";
    public int distSimMaxBits = 8;
    public boolean numberEquivalenceDistSim = false;
    public String unknownWordDistSimClass = "null";
    public boolean useNeighborNGrams = false;
    public Function<String, String> wordFunction = null;
    public static final String DEFAULT_PLAIN_TEXT_READER = "edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter";
    public String plainTextDocumentReaderAndWriter = "edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter";
    public boolean useBagOfWords = false;
    public boolean evaluateBackground = false;
    public int numLopExpert = 1;
    public transient String initialLopScales = null;
    public transient String initialLopWeights = null;
    public boolean includeFullCRFInLOP = false;
    public boolean backpropLopTraining = false;
    public boolean randomLopWeights = false;
    public boolean randomLopFeatureSplit = false;
    public boolean nonLinearCRF = false;
    public boolean secondOrderNonLinear = false;
    public int numHiddenUnits = -1;
    public boolean useOutputLayer = true;
    public boolean useHiddenLayer = true;
    public boolean gradientDebug = false;
    public boolean checkGradient = false;
    public boolean useSigmoid = false;
    public boolean skipOutputRegularization = false;
    public boolean sparseOutputLayer = false;
    public boolean tieOutputLayer = false;
    public boolean blockInitialize = false;
    public boolean softmaxOutputLayer = false;
    public String loadBisequenceClassifierEn = null;
    public String loadBisequenceClassifierCh = null;
    public String bisequenceClassifierPropEn = null;
    public String bisequenceClassifierPropCh = null;
    public String bisequenceTestFileEn = null;
    public String bisequenceTestFileCh = null;
    public String bisequenceTestOutputEn = null;
    public String bisequenceTestOutputCh = null;
    public String bisequenceTestAlignmentFile = null;
    public String bisequenceAlignmentTestOutput = null;
    public int bisequencePriorType = 1;
    public String bisequenceAlignmentPriorPenaltyCh = null;
    public String bisequenceAlignmentPriorPenaltyEn = null;
    public double alignmentPruneThreshold = 0.0;
    public double alignmentDecodeThreshold = 0.5;
    public boolean factorInAlignmentProb = false;
    public boolean useChromaticSampling = false;
    public boolean useSequentialScanSampling = false;
    public int maxAllowedChromaticSize = 8;
    public boolean keepEmptySentences = false;
    public boolean useBilingualNERPrior = false;
    public int samplingSpeedUpThreshold = -1;
    public String entityMatrixCh = null;
    public String entityMatrixEn = null;
    public int multiThreadGibbs = 0;
    public boolean matchNERIncentive = false;
    public boolean useEmbedding = false;
    public boolean prependEmbedding = false;
    public String embeddingWords = null;
    public String embeddingVectors = null;
    public boolean transitionEdgeOnly = false;
    public double priorLambda = 0.0;
    public boolean addCapitalFeatures = false;
    public int arbitraryInputLayerSize = -1;
    public boolean noEdgeFeature = false;
    public boolean terminateOnEvalImprovement = false;
    public int terminateOnEvalImprovementNumOfEpoch = 1;
    public boolean useMemoryEvaluator = true;
    public boolean suppressTestDebug = false;
    public boolean useOWLQN = false;
    public boolean printWeights = false;
    public int totalDataSlice = 10;
    public int numOfSlices = 0;
    public boolean regularizeSoftmaxTieParam = false;
    public double softmaxTieLambda = 0.0;
    public int totalFeatureSlice = 10;
    public int numOfFeatureSlices = 0;
    public boolean addBiasToEmbedding = false;
    public boolean hardcodeSoftmaxOutputWeights = false;
    public boolean useNERPriorBIO = false;
    public String entityMatrix = null;
    public int multiThreadClassifier = 0;
    public boolean useDualDecomp = false;
    public boolean biAlignmentPriorIsPMI = true;
    public boolean dampDDStepSizeWithAlignmentProb = false;
    public boolean dualDecompAlignment = false;
    public double dualDecompInitialStepSizeAlignment = 0.1;
    public boolean dualDecompNotBIO = false;
    public String berkeleyAlignerLoadPath = null;
    public boolean useBerkeleyAlignerForViterbi = false;
    public boolean useBerkeleyCompetitivePosterior = false;
    public boolean useDenero = true;
    public double alignDDAlpha = 1.0;
    public boolean factorInBiEdgePotential = false;
    public boolean noNeighborConstraints = false;
    public boolean includeC2EViterbi = true;
    public boolean initWithPosterior = true;
    public int nerSkipFirstK = 0;
    public int nerSlowerTimes = 1;
    public boolean powerAlignProb = false;
    public boolean powerAlignProbAsAddition = false;
    public boolean initWithNERPosterior = false;
    public boolean applyNERPenalty = true;
    public boolean printFactorTable = false;
    public boolean useAdaGradFOBOS = false;
    public double initRate = 0.1;
    public boolean groupByFeatureTemplate = false;
    public boolean groupByOutputClass = false;
    public double priorAlpha = 0.0;
    public String splitWordRegex = null;
    public boolean groupByInput = false;
    public boolean groupByHiddenUnit = false;
    public String unigramLM = null;
    public String bigramLM = null;
    public int wordSegBeamSize = 1000;
    public String vocabFile = null;
    public String normalizedFile = null;
    public boolean averagePerceptron = true;
    public String loadCRFSegmenterPath = null;
    public String loadPCTSegmenterPath = null;
    public String crfSegmenterProp = null;
    public String pctSegmenterProp = null;
    public String intermediateSegmenterOut = null;
    public String intermediateSegmenterModel = null;
    public int dualDecompMaxItr = 0;
    public double dualDecompInitialStepSize = 0.1;
    public boolean dualDecompDebug = false;
    public boolean useCWSWordFeatures = false;
    public boolean useCWSWordFeaturesAll = false;
    public boolean useCWSWordFeaturesBigram = false;
    public boolean pctSegmenterLenAdjust = false;
    public boolean useTrainLexicon = false;
    public boolean useCWSFeatures = true;
    public boolean appendLC = false;
    public boolean perceptronDebug = false;
    public boolean pctSegmenterScaleByCRF = false;
    public double pctSegmenterScale = 0.0;
    public boolean separateASCIIandRange = true;
    public double dropoutRate = 0.0;
    public double dropoutScale = 1.0;
    public int multiThreadGrad = Runtime.getRuntime().availableProcessors();
    public int maxQNItr = 0;
    public boolean dropoutApprox = false;
    public String unsupDropoutFile = null;
    public double unsupDropoutScale = 1.0;
    public int startEvaluateIters = 0;
    public int multiThreadPerceptron = 1;
    public boolean lazyUpdate = false;
    public int featureCountThresh = 0;
    public transient String serializeWeightsTo = null;
    public boolean geDebug = false;
    public boolean doFeatureDiscovery = false;
    public transient String loadWeightsFrom = null;
    public transient String loadClassIndexFrom = null;
    public transient String serializeClassIndexTo = null;
    public boolean learnCHBasedOnEN = true;
    public boolean learnENBasedOnCH = false;
    public String loadWeightsFromEN = null;
    public String loadWeightsFromCH = null;
    public String serializeToEN = null;
    public String serializeToCH = null;
    public String testFileEN = null;
    public String testFileCH = null;
    public String unsupFileEN = null;
    public String unsupFileCH = null;
    public String unsupAlignFile = null;
    public String supFileEN = null;
    public String supFileCH = null;
    public transient String serializeFeatureIndexTo = null;
    public String loadFeatureIndexFromEN = null;
    public String loadFeatureIndexFromCH = null;
    public double lambdaEN = 1.0;
    public double lambdaCH = 1.0;
    public boolean alternateTraining = false;
    public boolean weightByEntropy = false;
    public boolean useKL = false;
    public boolean useHardGE = false;
    public boolean useCRFforUnsup = false;
    public boolean useGEforSup = false;
    public boolean useKnownLCWords = true;
    public String[] featureFactories = null;
    public List<Object[]> featureFactoriesArgs = null;
    public boolean useNoisyLabel = false;
    public String errorMatrix = null;
    public boolean printTrainLabels = false;
    public int labelDictionaryCutoff = -1;
    public boolean useAdaDelta = false;
    public boolean useAdaDiff = false;
    public double adaGradEps = 0.001;
    public double adaDeltaRho = 0.95;
    public boolean useRandomSeed = false;
    public boolean terminateOnAvgImprovement = false;
    public boolean strictGoodCoNLL = false;
    public boolean removeStrictGoodCoNLLDuplicates = false;
    public String priorModelFactory;
    public boolean useUndirectedDisjunctive;
    public boolean splitSlashHyphenWords;
    public int maxAdditionalKnownLCWords = 0;
    public SlashHyphenEnum slashHyphenTreatment = SlashHyphenEnum.NONE;
    public boolean useTitle2 = false;
    public boolean showNCCInfo;
    public boolean showCCInfo;
    public String crfToExamine;
    public boolean useSUTime;
    public boolean applyNumericClassifiers;
    public String combinationMode;
    public String nerModel;
    public transient List<String> phraseGazettes = null;
    public transient Properties props = null;

    public SeqClassifierFlags() {
    }

    public SeqClassifierFlags(Properties props) {
        this.setProperties(props, true);
    }

    public final void setProperties(Properties props) {
        this.setProperties(props, true);
    }

    public void setProperties(Properties props, boolean printProps) {
        this.props = props;
        StringBuilder sb = new StringBuilder(this.stringRep);
        for (String key : props.stringPropertyNames()) {
            StringTokenizer st;
            String val = props.getProperty(key);
            if (!key.isEmpty() || !val.isEmpty()) {
                if (printProps) {
                    System.err.println(key + '=' + val);
                }
                sb.append(key).append('=').append(val).append('\n');
            }
            if (key.equalsIgnoreCase("macro")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.useObservedSequencesOnly = true;
                this.readerAndWriter = "edu.stanford.nlp.sequences.CoNLLDocumentReaderAndWriter";
                this.useLongSequences = true;
                this.useTaggySequences = true;
                this.useNGrams = true;
                this.usePrev = true;
                this.useNext = true;
                this.useTags = true;
                this.useWordPairs = true;
                this.useSequences = true;
                this.usePrevSequences = true;
                this.noMidNGrams = true;
                this.useReverse = true;
                this.useTypeSeqs = true;
                this.useTypeSeqs2 = true;
                this.useTypeySequences = true;
                this.wordShape = 3;
                this.useOccurrencePatterns = true;
                this.useLastRealWord = true;
                this.useNextRealWord = true;
                this.sigma = 3.0;
                this.normalize = true;
                this.normalizeTimex = true;
                continue;
            }
            if (key.equalsIgnoreCase("goodCoNLL")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.readerAndWriter = "edu.stanford.nlp.sequences.CoNLLDocumentReaderAndWriter";
                this.useObservedSequencesOnly = true;
                this.useLongSequences = true;
                this.useTaggySequences = true;
                this.useNGrams = true;
                this.usePrev = true;
                this.useNext = true;
                this.useTags = true;
                this.useWordPairs = true;
                this.useSequences = true;
                this.usePrevSequences = true;
                this.noMidNGrams = true;
                this.useReverse = false;
                this.useTypeSeqs = true;
                this.useTypeSeqs2 = true;
                this.useTypeySequences = true;
                this.wordShape = 3;
                this.useOccurrencePatterns = true;
                this.useLastRealWord = true;
                this.useNextRealWord = true;
                this.sigma = 5.0;
                this.normalize = true;
                this.normalizeTimex = true;
                this.maxLeft = 2;
                this.useDisjunctive = true;
                this.disjunctionWidth = 4;
                this.useBoundarySequences = true;
                this.useLemmas = true;
                this.usePrevNextLemmas = true;
                this.strictGoodCoNLL = true;
                this.removeStrictGoodCoNLLDuplicates = true;
                this.inputEncoding = "iso-8859-1";
                this.useQN = true;
                this.QNsize = 15;
                continue;
            }
            if (key.equalsIgnoreCase("conllNoTags")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.readerAndWriter = "edu.stanford.nlp.sequences.ColumnDocumentReaderAndWriter";
                this.map = "word=0,answer=1";
                this.useObservedSequencesOnly = true;
                this.useLongSequences = true;
                this.useNGrams = true;
                this.usePrev = true;
                this.useNext = true;
                this.useWordPairs = true;
                this.useSequences = true;
                this.usePrevSequences = true;
                this.noMidNGrams = true;
                this.useReverse = false;
                this.useTypeSeqs = true;
                this.useTypeSeqs2 = true;
                this.useTypeySequences = true;
                this.wordShape = 3;
                this.useLastRealWord = true;
                this.useNextRealWord = true;
                this.sigma = 20.0;
                this.adaptSigma = 20.0;
                this.normalize = true;
                this.normalizeTimex = true;
                this.maxLeft = 2;
                this.useDisjunctive = true;
                this.disjunctionWidth = 4;
                this.useBoundarySequences = true;
                this.inputEncoding = "iso-8859-1";
                this.useQN = true;
                this.QNsize = 15;
                continue;
            }
            if (key.equalsIgnoreCase("notags")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.useTags = false;
                this.useSymTags = false;
                this.useTaggySequences = false;
                this.useOccurrencePatterns = false;
                continue;
            }
            if (key.equalsIgnoreCase("submit")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.useLongSequences = true;
                this.useTaggySequences = true;
                this.useNGrams = true;
                this.usePrev = true;
                this.useNext = true;
                this.useTags = true;
                this.useWordPairs = true;
                this.wordShape = 0;
                this.useSequences = true;
                this.usePrevSequences = true;
                continue;
            }
            if (key.equalsIgnoreCase("binnedLengths")) {
                if (val == null) continue;
                String[] binnedLengthStrs = val.split("[, ]+");
                this.binnedLengths = new int[binnedLengthStrs.length];
                for (int i = 0; i < this.binnedLengths.length; ++i) {
                    this.binnedLengths[i] = Integer.parseInt(binnedLengthStrs[i]);
                }
                continue;
            }
            if (key.equalsIgnoreCase("makeConsistent")) {
                this.makeConsistent = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dump")) {
                this.dump = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNGrams")) {
                this.useNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNeighborNGrams")) {
                this.useNeighborNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("wordFunction")) {
                this.wordFunction = (Function)ReflectionLoading.loadByReflection(val, new Object[0]);
                continue;
            }
            if (key.equalsIgnoreCase("conjoinShapeNGrams")) {
                this.conjoinShapeNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("lowercaseNGrams")) {
                this.lowercaseNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useIsURL")) {
                this.useIsURL = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useURLSequences")) {
                this.useURLSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEntityTypes")) {
                this.useEntityTypes = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEntityRule")) {
                this.useEntityRule = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useOrdinal")) {
                this.useOrdinal = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEntityTypeSequences")) {
                this.useEntityTypeSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useIsDateRange")) {
                this.useIsDateRange = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dehyphenateNGrams")) {
                this.dehyphenateNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("lowerNewgeneThreshold")) {
                this.lowerNewgeneThreshold = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePrev")) {
                this.usePrev = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNext")) {
                this.useNext = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTags")) {
                this.useTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordPairs")) {
                this.useWordPairs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGazettes")) {
                this.useGazettes = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("wordShape")) {
                this.wordShape = WordShapeClassifier.lookupShaper(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeStrings")) {
                this.useShapeStrings = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGoodForNamesCpC")) {
                this.useGoodForNamesCpC = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDictionaryConjunctions")) {
                this.useDictionaryConjunctions = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDictionaryConjunctions3")) {
                this.useDictionaryConjunctions3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("expandMidDot")) {
                this.expandMidDot = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSequences")) {
                this.useSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePrevSequences")) {
                this.usePrevSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNextSequences")) {
                this.useNextSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useLongSequences")) {
                this.useLongSequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBoundarySequences")) {
                this.useBoundarySequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTaggySequences")) {
                this.useTaggySequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useExtraTaggySequences")) {
                this.useExtraTaggySequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTaggySequencesShapeInteraction")) {
                this.useTaggySequencesShapeInteraction = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("strictlyZeroethOrder")) {
                this.strictlyZeroethOrder = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("strictlyFirstOrder")) {
                this.strictlyFirstOrder = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("strictlySecondOrder")) {
                this.strictlySecondOrder = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("strictlyThirdOrder")) {
                this.strictlyThirdOrder = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dontExtendTaggy")) {
                this.dontExtendTaggy = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("entitySubclassification")) {
                this.entitySubclassification = val;
                continue;
            }
            if (key.equalsIgnoreCase("useGazettePhrases")) {
                this.useGazettePhrases = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("phraseGazettes")) {
                st = new StringTokenizer(val, " ,;\t");
                if (this.phraseGazettes == null) {
                    this.phraseGazettes = new ArrayList<String>();
                }
                while (st.hasMoreTokens()) {
                    this.phraseGazettes.add(st.nextToken());
                }
                continue;
            }
            if (key.equalsIgnoreCase("useSum")) {
                this.useSum = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("verbose")) {
                this.verboseMode = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("verboseMode")) {
                this.verboseMode = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("tolerance")) {
                this.tolerance = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxIterations")) {
                this.maxIterations = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("exportFeatures")) {
                this.exportFeatures = val;
                continue;
            }
            if (key.equalsIgnoreCase("printFeatures")) {
                this.printFeatures = val;
                continue;
            }
            if (key.equalsIgnoreCase("printFeaturesUpto")) {
                this.printFeaturesUpto = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("lastNameList")) {
                this.lastNameList = val;
                continue;
            }
            if (key.equalsIgnoreCase("maleNameList")) {
                this.maleNameList = val;
                continue;
            }
            if (key.equalsIgnoreCase("femaleNameList")) {
                this.femaleNameList = val;
                continue;
            }
            if (key.equalsIgnoreCase("useSymTags")) {
                this.useSymTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSymWordPairs")) {
                this.useSymWordPairs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printClassifier")) {
                this.printClassifier = val;
                continue;
            }
            if (key.equalsIgnoreCase("printClassifierParam")) {
                this.printClassifierParam = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("intern")) {
                this.intern = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("mergetags")) {
                this.mergeTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("iobtags")) {
                this.iobTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useViterbi")) {
                this.useViterbi = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("intern2")) {
                this.intern2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("selfTest")) {
                this.selfTest = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("sloppyGazette")) {
                this.sloppyGazette = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("cleanGazette")) {
                this.cleanGazette = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("noMidNGrams")) {
                this.noMidNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useReverse")) {
                this.useReverse = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("retainEntitySubclassification")) {
                this.retainEntitySubclassification = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useLemmas")) {
                this.useLemmas = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePrevNextLemmas")) {
                this.usePrevNextLemmas = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("normalizeTerms")) {
                this.normalizeTerms = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("normalizeTimex")) {
                this.normalizeTimex = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNB")) {
                this.useNB = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useParenMatching")) {
                this.useParenMatching = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTypeSeqs")) {
                this.useTypeSeqs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTypeSeqs2")) {
                this.useTypeSeqs2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTypeSeqs3")) {
                this.useTypeSeqs3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDisjunctive")) {
                this.useDisjunctive = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUndirectedDisjunctive")) {
                this.useUndirectedDisjunctive = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("splitSlashHyphenWords")) {
                try {
                    this.slashHyphenTreatment = SlashHyphenEnum.valueOf(val.trim().toUpperCase());
                }
                catch (IllegalArgumentException | NullPointerException iae) {
                    this.slashHyphenTreatment = SlashHyphenEnum.NONE;
                }
                continue;
            }
            if (key.equalsIgnoreCase("disjunctionWidth")) {
                this.disjunctionWidth = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDisjunctiveShapeInteraction")) {
                this.useDisjunctiveShapeInteraction = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWideDisjunctive")) {
                this.useWideDisjunctive = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("wideDisjunctionWidth")) {
                this.wideDisjunctionWidth = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDisjShape")) {
                this.useDisjShape = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTitle")) {
                this.useTitle = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTitle2")) {
                this.useTitle2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("booleanFeatures")) {
                this.booleanFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useClassFeature")) {
                this.useClassFeature = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeConjunctions")) {
                this.useShapeConjunctions = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordTag")) {
                this.useWordTag = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNPHead")) {
                this.useNPHead = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNPGovernor")) {
                this.useNPGovernor = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHeadGov")) {
                this.useHeadGov = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useLastRealWord")) {
                this.useLastRealWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNextRealWord")) {
                this.useNextRealWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useOccurrencePatterns")) {
                this.useOccurrencePatterns = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTypeySequences")) {
                this.useTypeySequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("justify")) {
                this.justify = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("normalize")) {
                this.normalize = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("priorType")) {
                this.priorType = val;
                continue;
            }
            if (key.equalsIgnoreCase("sigma")) {
                this.sigma = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("epsilon")) {
                this.epsilon = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("beamSize")) {
                this.beamSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("removeTopN")) {
                this.removeTopN = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("removeTopNPercent")) {
                this.removeTopNPercent = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("randomizedRatio")) {
                this.randomizedRatio = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("numTimesRemoveTopN")) {
                this.numTimesRemoveTopN = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxLeft")) {
                this.maxLeft = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxRight")) {
                this.maxRight = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxNGramLeng")) {
                this.maxNGramLeng = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGazFeatures")) {
                this.useGazFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAltGazFeatures")) {
                this.useAltGazFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMoreGazFeatures")) {
                this.useMoreGazFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbbr")) {
                this.useAbbr = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMinimalAbbr")) {
                this.useMinimalAbbr = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbbr1")) {
                this.useAbbr1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMinimalAbbr1")) {
                this.useMinimalAbbr1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("documentReader")) {
                System.err.println("You are using an outdated flag: -documentReader " + val);
                System.err.println("Please use -readerAndWriter instead.");
                continue;
            }
            if (key.equalsIgnoreCase("deleteBlankLines")) {
                this.deleteBlankLines = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("answerFile")) {
                this.answerFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("altAnswerFile")) {
                this.altAnswerFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadClassifier") || key.equalsIgnoreCase("model")) {
                this.loadClassifier = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadTextClassifier")) {
                this.loadTextClassifier = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadJarClassifier")) {
                this.loadJarClassifier = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadAuxClassifier")) {
                this.loadAuxClassifier = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeTo")) {
                this.serializeTo = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeToText")) {
                this.serializeToText = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeDatasetsDir")) {
                this.serializeDatasetsDir = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadDatasetsDir")) {
                this.loadDatasetsDir = val;
                continue;
            }
            if (key.equalsIgnoreCase("pushDir")) {
                this.pushDir = val;
                continue;
            }
            if (key.equalsIgnoreCase("purgeDatasets")) {
                this.purgeDatasets = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("keepOBInMemory")) {
                this.keepOBInMemory = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("fakeDataset")) {
                this.fakeDataset = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("numDatasetsPerFile")) {
                this.numDatasetsPerFile = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("trainFile")) {
                this.trainFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("biasedTrainFile")) {
                this.biasedTrainFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("classBias")) {
                this.classBias = val;
                continue;
            }
            if (key.equalsIgnoreCase("confusionMatrix")) {
                this.confusionMatrix = val;
                continue;
            }
            if (key.equalsIgnoreCase("adaptFile")) {
                this.adaptFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("devFile")) {
                this.devFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("testFile")) {
                this.testFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("outputFile")) {
                this.outputFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("textFile")) {
                this.textFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("readStdin")) {
                this.readStdin = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("initialWeights")) {
                this.initialWeights = val;
                continue;
            }
            if (key.equalsIgnoreCase("interimOutputFreq")) {
                this.interimOutputFreq = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("inputEncoding")) {
                this.inputEncoding = val;
                continue;
            }
            if (key.equalsIgnoreCase("outputEncoding")) {
                this.outputEncoding = val;
                continue;
            }
            if (key.equalsIgnoreCase("encoding")) {
                this.inputEncoding = val;
                this.outputEncoding = val;
                continue;
            }
            if (key.equalsIgnoreCase("gazette")) {
                this.useGazettes = true;
                st = new StringTokenizer(val, " ,;\t");
                if (this.gazettes == null) {
                    this.gazettes = new ArrayList<String>();
                }
                while (st.hasMoreTokens()) {
                    this.gazettes.add(st.nextToken());
                }
                continue;
            }
            if (key.equalsIgnoreCase("useQN")) {
                this.useQN = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("QNsize")) {
                this.QNsize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("QNsize2")) {
                this.QNsize2 = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("l1reg")) {
                this.useQN = false;
                this.l1reg = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFloat")) {
                this.useFloat = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("trainMap")) {
                System.err.println("trainMap and testMap are no longer valid options - please use map instead.");
                throw new RuntimeException();
            }
            if (key.equalsIgnoreCase("testMap")) {
                System.err.println("trainMap and testMap are no longer valid options - please use map instead.");
                throw new RuntimeException();
            }
            if (key.equalsIgnoreCase("map")) {
                this.map = val;
                continue;
            }
            if (key.equalsIgnoreCase("useMoreAbbr")) {
                this.useMoreAbbr = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePrevVB")) {
                this.usePrevVB = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNextVB")) {
                this.useNextVB = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useVB")) {
                if (!Boolean.parseBoolean(val)) continue;
                this.useVB = true;
                this.usePrevVB = true;
                this.useNextVB = true;
                continue;
            }
            if (key.equalsIgnoreCase("useChunks")) {
                this.useChunks = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useChunkySequences")) {
                this.useChunkySequences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("greekifyNGrams")) {
                this.greekifyNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("restrictTransitionsTimit")) {
                this.restrictTransitionsTimit = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMoreTags")) {
                this.useMoreTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBeginSent")) {
                this.useBeginSent = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePosition")) {
                this.usePosition = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGenia")) {
                this.useGENIA = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbstr")) {
                this.useABSTR = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWeb")) {
                this.useWEB = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAnte")) {
                this.useANTE = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAcr")) {
                this.useACR = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTok")) {
                this.useTOK = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbgene")) {
                this.useABGENE = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbstrFreqDict")) {
                this.useABSTRFreqDict = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAbstrFreq")) {
                this.useABSTRFreq = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFreq")) {
                this.useFREQ = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usewebfreqdict")) {
                this.useWEBFreqDict = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("bioSubmitOutput")) {
                this.bioSubmitOutput = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("subCWGaz")) {
                this.subCWGaz = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("splitOnHead")) {
                this.splitOnHead = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("featureCountThreshold")) {
                this.featureCountThreshold = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWord")) {
                this.useWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("memoryThrift")) {
                this.memoryThrift = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("timitDatum")) {
                this.timitDatum = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("splitDocuments")) {
                System.err.println("You are using an outdated flag: -splitDocuments");
                System.err.println("Please use -maxDocSize -1 instead.");
                this.splitDocuments = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("featureWeightThreshold")) {
                this.featureWeightThreshold = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("backgroundSymbol")) {
                this.backgroundSymbol = val;
                continue;
            }
            if (key.equalsIgnoreCase("featureFactory")) {
                String[] tokens = val.split("\\s*,\\s*");
                int numFactories = tokens.length;
                if (numFactories == 1) {
                    this.featureFactory = SeqClassifierFlags.getFeatureFactory(val);
                }
                this.featureFactories = new String[numFactories];
                this.featureFactoriesArgs = new ArrayList<Object[]>(numFactories);
                for (int i = 0; i < numFactories; ++i) {
                    this.featureFactories[i] = SeqClassifierFlags.getFeatureFactory(tokens[i]);
                    this.featureFactoriesArgs.add(new Object[0]);
                }
                continue;
            }
            if (key.equalsIgnoreCase("printXML")) {
                System.err.println("printXML is disused; perhaps try using the -outputFormat xml option.");
                continue;
            }
            if (key.equalsIgnoreCase("useSeenFeaturesOnly")) {
                this.useSeenFeaturesOnly = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBagOfWords")) {
                this.useBagOfWords = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRadical")) {
                this.useRadical = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBigramInTwoClique")) {
                this.useBigramInTwoClique = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useReverseAffix")) {
                this.useReverseAffix = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("charHalfWindow")) {
                this.charHalfWindow = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("purgeFeatures")) {
                this.purgeFeatures = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("ocrFold")) {
                this.ocrFold = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("morphFeatureFile")) {
                this.morphFeatureFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("svmModelFile")) {
                this.svmModelFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("useDictleng")) {
                this.useDictleng = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDict2")) {
                this.useDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useOutDict2")) {
                this.useOutDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("outDict2")) {
                this.outDict2 = val;
                continue;
            }
            if (key.equalsIgnoreCase("useDictCTB2")) {
                this.useDictCTB2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDictASBC2")) {
                this.useDictASBC2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDictPK2")) {
                this.useDictPK2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDictHK2")) {
                this.useDictHK2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWord1")) {
                this.useWord1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWord2")) {
                this.useWord2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWord3")) {
                this.useWord3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWord4")) {
                this.useWord4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRad1")) {
                this.useRad1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRad2")) {
                this.useRad2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRad2b")) {
                this.useRad2b = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordn")) {
                this.useWordn = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCTBPre1")) {
                this.useCTBPre1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCTBSuf1")) {
                this.useCTBSuf1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useASBCPre1")) {
                this.useASBCPre1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useASBCSuf1")) {
                this.useASBCSuf1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHKPre1")) {
                this.useHKPre1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHKSuf1")) {
                this.useHKSuf1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePKPre1")) {
                this.usePKPre1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePKSuf1")) {
                this.usePKSuf1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCTBChar2")) {
                this.useCTBChar2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePrediction")) {
                this.usePrediction = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useASBCChar2")) {
                this.useASBCChar2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHKChar2")) {
                this.useHKChar2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePKChar2")) {
                this.usePKChar2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRule2")) {
                this.useRule2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBig5")) {
                this.useBig5 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegDict2")) {
                this.useNegDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegDict3")) {
                this.useNegDict3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegDict4")) {
                this.useNegDict4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegCTBDict2")) {
                this.useNegCTBDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegCTBDict3")) {
                this.useNegCTBDict3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegCTBDict4")) {
                this.useNegCTBDict4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegASBCDict2")) {
                this.useNegASBCDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegASBCDict3")) {
                this.useNegASBCDict3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegASBCDict4")) {
                this.useNegASBCDict4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegPKDict2")) {
                this.useNegPKDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegPKDict3")) {
                this.useNegPKDict3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegPKDict4")) {
                this.useNegPKDict4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegHKDict2")) {
                this.useNegHKDict2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegHKDict3")) {
                this.useNegHKDict3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNegHKDict4")) {
                this.useNegHKDict4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePre")) {
                this.usePre = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSuf")) {
                this.useSuf = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRule")) {
                this.useRule = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAs")) {
                this.useAs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePk")) {
                this.usePk = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHk")) {
                this.useHk = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMsr")) {
                this.useMsr = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMSRChar2")) {
                this.useMSRChar2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesC4gram")) {
                this.useFeaturesC4gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesC5gram")) {
                this.useFeaturesC5gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesC6gram")) {
                this.useFeaturesC6gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesCpC4gram")) {
                this.useFeaturesCpC4gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesCpC5gram")) {
                this.useFeaturesCpC5gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFeaturesCpC6gram")) {
                this.useFeaturesCpC6gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUnicodeType")) {
                this.useUnicodeType = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUnicodeBlock")) {
                this.useUnicodeBlock = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUnicodeType4gram")) {
                this.useUnicodeType4gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUnicodeType5gram")) {
                this.useUnicodeType5gram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeStrings1")) {
                this.useShapeStrings1 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeStrings3")) {
                this.useShapeStrings3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeStrings4")) {
                this.useShapeStrings4 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useShapeStrings5")) {
                this.useShapeStrings5 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordUTypeConjunctions2")) {
                this.useWordUTypeConjunctions2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordUTypeConjunctions3")) {
                this.useWordUTypeConjunctions3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordShapeConjunctions2")) {
                this.useWordShapeConjunctions2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordShapeConjunctions3")) {
                this.useWordShapeConjunctions3 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMidDotShape")) {
                this.useMidDotShape = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("augmentedDateChars")) {
                this.augmentedDateChars = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("suppressMidDotPostprocessing")) {
                this.suppressMidDotPostprocessing = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printNR")) {
                this.printNR = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("use4Clique")) {
                this.use4Clique = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFilter")) {
                this.useFilter = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("largeChSegFile")) {
                this.largeChSegFile = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("keepEnglishWhitespaces")) {
                this.keepEnglishWhitespaces = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("keepAllWhitespaces")) {
                this.keepAllWhitespaces = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("sighanPostProcessing")) {
                this.sighanPostProcessing = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useChPos")) {
                this.useChPos = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("sighanCorporaDict")) {
                this.sighanCorporaDict = val;
                continue;
            }
            if (key.equalsIgnoreCase("useObservedSequencesOnly")) {
                this.useObservedSequencesOnly = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxDocSize")) {
                this.maxDocSize = Integer.parseInt(val);
                this.splitDocuments = true;
                continue;
            }
            if (key.equalsIgnoreCase("printProbs")) {
                this.printProbs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printFirstOrderProbs")) {
                this.printFirstOrderProbs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("saveFeatureIndexToDisk")) {
                this.saveFeatureIndexToDisk = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("removeBackgroundSingletonFeatures")) {
                this.removeBackgroundSingletonFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("doGibbs")) {
                this.doGibbs = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMUCFeatures")) {
                this.useMUCFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("initViterbi")) {
                this.initViterbi = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("checkNameList")) {
                this.checkNameList = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useFirstWord")) {
                this.useFirstWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useUnknown")) {
                this.useUnknown = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("cacheNGrams")) {
                this.cacheNGrams = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useNumberFeature")) {
                this.useNumberFeature = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("annealingRate")) {
                this.annealingRate = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("annealingType")) {
                if (val.equalsIgnoreCase("linear") || val.equalsIgnoreCase("exp") || val.equalsIgnoreCase("exponential")) {
                    this.annealingType = val;
                    continue;
                }
                System.err.println("unknown annealingType: " + val + ".  Please use linear|exp|exponential");
                continue;
            }
            if (key.equalsIgnoreCase("numSamples")) {
                this.numSamples = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("inferenceType")) {
                this.inferenceType = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadProcessedData")) {
                this.loadProcessedData = val;
                continue;
            }
            if (key.equalsIgnoreCase("normalizationTable")) {
                this.normalizationTable = val;
                continue;
            }
            if (key.equalsIgnoreCase("dictionary")) {
                if (!((val = val.trim()).length() <= 0 || "true".equals(val) || "null".equals(val) || "false".equals("val"))) {
                    this.dictionary = val;
                    continue;
                }
                this.dictionary = null;
                continue;
            }
            if (key.equalsIgnoreCase("serDictionary")) {
                if (!((val = val.trim()).length() <= 0 || "true".equals(val) || "null".equals(val) || "false".equals("val"))) {
                    this.serializedDictionary = val;
                    continue;
                }
                this.serializedDictionary = null;
                continue;
            }
            if (key.equalsIgnoreCase("dictionary2")) {
                if (!((val = val.trim()).length() <= 0 || "true".equals(val) || "null".equals(val) || "false".equals("val"))) {
                    this.dictionary2 = val;
                    continue;
                }
                this.dictionary2 = null;
                continue;
            }
            if (key.equalsIgnoreCase("normTableEncoding")) {
                this.normTableEncoding = val;
                continue;
            }
            if (key.equalsIgnoreCase("useLemmaAsWord")) {
                this.useLemmaAsWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("type")) {
                this.type = val;
                continue;
            }
            if (key.equalsIgnoreCase("readerAndWriter")) {
                this.readerAndWriter = val;
                continue;
            }
            if (key.equalsIgnoreCase("plainTextDocumentReaderAndWriter")) {
                this.plainTextDocumentReaderAndWriter = val;
                continue;
            }
            if (key.equalsIgnoreCase("gazFilesFile")) {
                this.gazFilesFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("baseTrainDir")) {
                this.baseTrainDir = val;
                continue;
            }
            if (key.equalsIgnoreCase("baseTestDir")) {
                this.baseTestDir = val;
                continue;
            }
            if (key.equalsIgnoreCase("trainFiles")) {
                this.trainFiles = val;
                continue;
            }
            if (key.equalsIgnoreCase("trainFileList")) {
                this.trainFileList = val;
                continue;
            }
            if (key.equalsIgnoreCase("trainDirs")) {
                this.trainDirs = val;
                continue;
            }
            if (key.equalsIgnoreCase("testDirs")) {
                this.testDirs = val;
                continue;
            }
            if (key.equalsIgnoreCase("testFiles")) {
                this.testFiles = val;
                continue;
            }
            if (key.equalsIgnoreCase("textFiles")) {
                this.textFiles = val;
                continue;
            }
            if (key.equalsIgnoreCase("usePrediction2")) {
                this.usePrediction2 = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useObservedFeaturesOnly")) {
                this.useObservedFeaturesOnly = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("iobWrapper")) {
                this.iobWrapper = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDistSim")) {
                this.useDistSim = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("casedDistSim")) {
                this.casedDistSim = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("distSimFileFormat")) {
                this.distSimFileFormat = val;
                continue;
            }
            if (key.equalsIgnoreCase("distSimMaxBits")) {
                this.distSimMaxBits = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("numberEquivalenceDistSim")) {
                this.numberEquivalenceDistSim = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("unknownWordDistSimClass")) {
                this.unknownWordDistSimClass = val;
                continue;
            }
            if (key.equalsIgnoreCase("useOnlySeenWeights")) {
                this.useOnlySeenWeights = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("predProp")) {
                this.predProp = val;
                continue;
            }
            if (key.equalsIgnoreCase("distSimLexicon")) {
                this.distSimLexicon = val;
                continue;
            }
            if (key.equalsIgnoreCase("useSegmentation")) {
                this.useSegmentation = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useInternal")) {
                this.useInternal = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useExternal")) {
                this.useExternal = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEitherSideWord")) {
                this.useEitherSideWord = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEitherSideDisjunctive")) {
                this.useEitherSideDisjunctive = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("featureDiffThresh")) {
                this.featureDiffThresh = Double.parseDouble(val);
                if (props.getProperty("numTimesPruneFeatures") != null) continue;
                this.numTimesPruneFeatures = 1;
                continue;
            }
            if (key.equalsIgnoreCase("numTimesPruneFeatures")) {
                this.numTimesPruneFeatures = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("newgeneThreshold")) {
                this.newgeneThreshold = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("adaptFile")) {
                this.adaptFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("doAdaptation")) {
                this.doAdaptation = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("selfTrainFile")) {
                this.selfTrainFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("selfTrainIterations")) {
                this.selfTrainIterations = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("selfTrainWindowSize")) {
                this.selfTrainWindowSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("selfTrainConfidenceThreshold")) {
                this.selfTrainConfidenceThreshold = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("numFolds")) {
                this.numFolds = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("startFold")) {
                this.startFold = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("endFold")) {
                this.endFold = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("adaptSigma")) {
                this.adaptSigma = Double.parseDouble(val);
                continue;
            }
            if (key.startsWith("prop") && !key.equals("prop")) {
                this.comboProps.add(val);
                continue;
            }
            if (key.equalsIgnoreCase("outputFormat")) {
                this.outputFormat = val;
                continue;
            }
            if (key.equalsIgnoreCase("useSMD")) {
                this.useSMD = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useScaledSGD")) {
                this.useScaledSGD = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("scaledSGDMethod")) {
                this.scaledSGDMethod = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("tuneSGD")) {
                this.tuneSGD = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("StochasticCalculateMethod")) {
                if (val.equalsIgnoreCase("AlgorithmicDifferentiation")) {
                    this.stochasticMethod = StochasticCalculateMethods.AlgorithmicDifferentiation;
                    continue;
                }
                if (val.equalsIgnoreCase("IncorporatedFiniteDifference")) {
                    this.stochasticMethod = StochasticCalculateMethods.IncorporatedFiniteDifference;
                    continue;
                }
                if (!val.equalsIgnoreCase("ExternalFinitedifference")) continue;
                this.stochasticMethod = StochasticCalculateMethods.ExternalFiniteDifference;
                continue;
            }
            if (key.equalsIgnoreCase("initialGain")) {
                this.initialGain = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("stochasticBatchSize")) {
                this.stochasticBatchSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("SGD2QNhessSamples")) {
                this.SGD2QNhessSamples = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSGD")) {
                this.useSGD = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useInPlaceSGD")) {
                this.useInPlaceSGD = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSGDtoQN")) {
                this.useSGDtoQN = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("SGDPasses")) {
                this.SGDPasses = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("QNPasses")) {
                this.QNPasses = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("gainSGD")) {
                this.gainSGD = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHybrid")) {
                this.useHybrid = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("hybridCutoffIteration")) {
                this.hybridCutoffIteration = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useStochasticQN")) {
                this.useStochasticQN = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("outputIterationsToFile")) {
                this.outputIterationsToFile = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("testObjFunction")) {
                this.testObjFunction = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("testVariance")) {
                this.testVariance = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("CRForder")) {
                this.CRForder = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("CRFwindow")) {
                this.CRFwindow = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("testHessSamples")) {
                this.testHessSamples = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("estimateInitial")) {
                this.estimateInitial = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printLabelValue")) {
                this.printLabelValue = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("searchGraphPrefix")) {
                this.searchGraphPrefix = val;
                continue;
            }
            if (key.equalsIgnoreCase("searchGraphPrune")) {
                this.searchGraphPrune = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("kBest")) {
                this.useKBest = true;
                this.kBest = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRobustQN")) {
                this.useRobustQN = true;
                continue;
            }
            if (key.equalsIgnoreCase("combo")) {
                this.combo = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("verboseForTrueCasing")) {
                this.verboseForTrueCasing = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("trainHierarchical")) {
                this.trainHierarchical = val;
                continue;
            }
            if (key.equalsIgnoreCase("domain")) {
                this.domain = val;
                continue;
            }
            if (key.equalsIgnoreCase("baseline")) {
                this.baseline = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("doFE")) {
                this.doFE = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("restrictLabels")) {
                this.restrictLabels = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("transferSigmas")) {
                this.transferSigmas = val;
                continue;
            }
            if (key.equalsIgnoreCase("announceObjectBankEntries")) {
                this.announceObjectBankEntries = true;
                continue;
            }
            if (key.equalsIgnoreCase("mixedCaseMapFile")) {
                this.mixedCaseMapFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("auxTrueCaseModels")) {
                this.auxTrueCaseModels = val;
                continue;
            }
            if (key.equalsIgnoreCase("use2W")) {
                this.use2W = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useLC")) {
                this.useLC = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useYetMoreCpCShapes")) {
                this.useYetMoreCpCShapes = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useIfInteger")) {
                this.useIfInteger = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("twoStage")) {
                this.twoStage = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("evaluateIters")) {
                this.evaluateIters = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("evalCmd")) {
                this.evalCmd = val;
                continue;
            }
            if (key.equalsIgnoreCase("evaluateTrain")) {
                this.evaluateTrain = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("evaluateBackground")) {
                this.evaluateBackground = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("tuneSampleSize")) {
                this.tuneSampleSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTopics")) {
                this.useTopics = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePhraseFeatures")) {
                this.usePhraseFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePhraseWords")) {
                this.usePhraseWords = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePhraseWordTags")) {
                this.usePhraseWordTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("usePhraseWordSpecialTags")) {
                this.usePhraseWordSpecialTags = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useProtoFeatures")) {
                this.useProtoFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useWordnetFeatures")) {
                this.useWordnetFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("wikiFeatureDbFile")) {
                this.wikiFeatureDbFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("tokenizerOptions")) {
                this.tokenizerOptions = val;
                continue;
            }
            if (key.equalsIgnoreCase("tokenizerFactory")) {
                this.tokenizerFactory = val;
                continue;
            }
            if (key.equalsIgnoreCase("useCommonWordsFeature")) {
                this.useCommonWordsFeature = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useYear")) {
                this.useYear = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSentenceNumber")) {
                this.useSentenceNumber = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useLabelSource")) {
                this.useLabelSource = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("tokenFactory")) {
                this.tokenFactory = val;
                continue;
            }
            if (key.equalsIgnoreCase("tokensAnnotationClassName")) {
                this.tokensAnnotationClassName = val;
                continue;
            }
            if (key.equalsIgnoreCase("numLopExpert")) {
                this.numLopExpert = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("initialLopScales")) {
                this.initialLopScales = val;
                continue;
            }
            if (key.equalsIgnoreCase("initialLopWeights")) {
                this.initialLopWeights = val;
                continue;
            }
            if (key.equalsIgnoreCase("includeFullCRFInLOP")) {
                this.includeFullCRFInLOP = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("backpropLopTraining")) {
                this.backpropLopTraining = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("randomLopWeights")) {
                this.randomLopWeights = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("randomLopFeatureSplit")) {
                this.randomLopFeatureSplit = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("nonLinearCRF")) {
                this.nonLinearCRF = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("secondOrderNonLinear")) {
                this.secondOrderNonLinear = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("numHiddenUnits")) {
                this.numHiddenUnits = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useOutputLayer")) {
                this.useOutputLayer = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHiddenLayer")) {
                this.useHiddenLayer = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("gradientDebug")) {
                this.gradientDebug = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("checkGradient")) {
                this.checkGradient = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSigmoid")) {
                this.useSigmoid = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("skipOutputRegularization")) {
                this.skipOutputRegularization = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("sparseOutputLayer")) {
                this.sparseOutputLayer = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("tieOutputLayer")) {
                this.tieOutputLayer = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("blockInitialize")) {
                this.blockInitialize = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("softmaxOutputLayer")) {
                this.softmaxOutputLayer = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("loadBisequenceClassifierEn")) {
                this.loadBisequenceClassifierEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceClassifierPropEn")) {
                this.bisequenceClassifierPropEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadBisequenceClassifierCh")) {
                this.loadBisequenceClassifierCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceClassifierPropCh")) {
                this.bisequenceClassifierPropCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceTestFileEn")) {
                this.bisequenceTestFileEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceTestFileCh")) {
                this.bisequenceTestFileCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceTestOutputEn")) {
                this.bisequenceTestOutputEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceTestOutputCh")) {
                this.bisequenceTestOutputCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceTestAlignmentFile")) {
                this.bisequenceTestAlignmentFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceAlignmentTestOutput")) {
                this.bisequenceAlignmentTestOutput = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequencePriorType")) {
                this.bisequencePriorType = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceAlignmentPriorPenaltyCh")) {
                this.bisequenceAlignmentPriorPenaltyCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("bisequenceAlignmentPriorPenaltyEn")) {
                this.bisequenceAlignmentPriorPenaltyEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("alignmentPruneThreshold")) {
                this.alignmentPruneThreshold = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("alignmentDecodeThreshold")) {
                this.alignmentDecodeThreshold = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("factorInAlignmentProb")) {
                this.factorInAlignmentProb = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useChromaticSampling")) {
                this.useChromaticSampling = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useSequentialScanSampling")) {
                this.useSequentialScanSampling = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxAllowedChromaticSize")) {
                this.maxAllowedChromaticSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("keepEmptySentences")) {
                this.keepEmptySentences = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBilingualNERPrior")) {
                this.useBilingualNERPrior = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("samplingSpeedUpThreshold")) {
                this.samplingSpeedUpThreshold = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("entityMatrixCh")) {
                this.entityMatrixCh = val;
                continue;
            }
            if (key.equalsIgnoreCase("entityMatrixEn")) {
                this.entityMatrixEn = val;
                continue;
            }
            if (key.equalsIgnoreCase("multiThreadGibbs")) {
                this.multiThreadGibbs = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("matchNERIncentive")) {
                this.matchNERIncentive = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useEmbedding")) {
                this.useEmbedding = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("prependEmbedding")) {
                this.prependEmbedding = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("embeddingWords")) {
                this.embeddingWords = val;
                continue;
            }
            if (key.equalsIgnoreCase("embeddingVectors")) {
                this.embeddingVectors = val;
                continue;
            }
            if (key.equalsIgnoreCase("transitionEdgeOnly")) {
                this.transitionEdgeOnly = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("priorLambda")) {
                this.priorLambda = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("addCapitalFeatures")) {
                this.addCapitalFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("arbitraryInputLayerSize")) {
                this.arbitraryInputLayerSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("noEdgeFeature")) {
                this.noEdgeFeature = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("terminateOnEvalImprovement")) {
                this.terminateOnEvalImprovement = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("terminateOnEvalImprovementNumOfEpoch")) {
                this.terminateOnEvalImprovementNumOfEpoch = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useMemoryEvaluator")) {
                this.useMemoryEvaluator = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("suppressTestDebug")) {
                this.suppressTestDebug = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useOWLQN")) {
                this.useOWLQN = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printWeights")) {
                this.printWeights = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("totalDataSlice")) {
                this.totalDataSlice = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("numOfSlices")) {
                this.numOfSlices = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("regularizeSoftmaxTieParam")) {
                this.regularizeSoftmaxTieParam = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("softmaxTieLambda")) {
                this.softmaxTieLambda = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("totalFeatureSlice")) {
                this.totalFeatureSlice = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("numOfFeatureSlices")) {
                this.numOfFeatureSlices = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("addBiasToEmbedding")) {
                this.addBiasToEmbedding = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("hardcodeSoftmaxOutputWeights")) {
                this.hardcodeSoftmaxOutputWeights = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("entityMatrix")) {
                this.entityMatrix = val;
                continue;
            }
            if (key.equalsIgnoreCase("multiThreadClassifier")) {
                this.multiThreadClassifier = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDualDecomp")) {
                this.useDualDecomp = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("biAlignmentPriorIsPMI")) {
                this.biAlignmentPriorIsPMI = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dampDDStepSizeWithAlignmentProb")) {
                this.dampDDStepSizeWithAlignmentProb = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompAlignment")) {
                this.dualDecompAlignment = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompInitialStepSizeAlignment")) {
                this.dualDecompInitialStepSizeAlignment = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompNotBIO")) {
                this.dualDecompNotBIO = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("berkeleyAlignerLoadPath")) {
                this.berkeleyAlignerLoadPath = val;
                continue;
            }
            if (key.equalsIgnoreCase("useBerkeleyAlignerForViterbi")) {
                this.useBerkeleyAlignerForViterbi = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useBerkeleyCompetitivePosterior")) {
                this.useBerkeleyCompetitivePosterior = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useDenero")) {
                this.useDenero = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("alignDDAlpha")) {
                this.alignDDAlpha = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("factorInBiEdgePotential")) {
                this.factorInBiEdgePotential = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("noNeighborConstraints")) {
                this.noNeighborConstraints = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("includeC2EViterbi")) {
                this.includeC2EViterbi = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("initWithPosterior")) {
                this.initWithPosterior = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("nerSlowerTimes")) {
                this.nerSlowerTimes = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("nerSkipFirstK")) {
                this.nerSkipFirstK = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("powerAlignProb")) {
                this.powerAlignProb = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("powerAlignProbAsAddition")) {
                this.powerAlignProbAsAddition = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("initWithNERPosterior")) {
                this.initWithNERPosterior = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("applyNERPenalty")) {
                this.applyNERPenalty = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGenericFeatures")) {
                this.useGenericFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("printFactorTable")) {
                this.printFactorTable = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAdaGradFOBOS")) {
                this.useAdaGradFOBOS = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("initRate")) {
                this.initRate = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("groupByFeatureTemplate")) {
                this.groupByFeatureTemplate = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("groupByOutputClass")) {
                this.groupByOutputClass = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("priorAlpha")) {
                this.priorAlpha = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("splitWordRegex")) {
                this.splitWordRegex = val;
                continue;
            }
            if (key.equalsIgnoreCase("groupByInput")) {
                this.groupByInput = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("groupByHiddenUnit")) {
                this.groupByHiddenUnit = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("unigramLM")) {
                this.unigramLM = val;
                continue;
            }
            if (key.equalsIgnoreCase("bigramLM")) {
                this.bigramLM = val;
                continue;
            }
            if (key.equalsIgnoreCase("wordSegBeamSize")) {
                this.wordSegBeamSize = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("vocabFile")) {
                this.vocabFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("normalizedFile")) {
                this.normalizedFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("averagePerceptron")) {
                this.averagePerceptron = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("loadCRFSegmenterPath")) {
                this.loadCRFSegmenterPath = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadPCTSegmenterPath")) {
                this.loadPCTSegmenterPath = val;
                continue;
            }
            if (key.equalsIgnoreCase("crfSegmenterProp")) {
                this.crfSegmenterProp = val;
                continue;
            }
            if (key.equalsIgnoreCase("pctSegmenterProp")) {
                this.pctSegmenterProp = val;
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompMaxItr")) {
                this.dualDecompMaxItr = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompInitialStepSize")) {
                this.dualDecompInitialStepSize = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("dualDecompDebug")) {
                this.dualDecompDebug = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("intermediateSegmenterOut")) {
                this.intermediateSegmenterOut = val;
                continue;
            }
            if (key.equalsIgnoreCase("intermediateSegmenterModel")) {
                this.intermediateSegmenterModel = val;
                continue;
            }
            if (key.equalsIgnoreCase("useCWSWordFeatures")) {
                this.useCWSWordFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCWSWordFeaturesAll")) {
                this.useCWSWordFeaturesAll = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCWSWordFeaturesBigram")) {
                this.useCWSWordFeaturesBigram = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("pctSegmenterLenAdjust")) {
                this.pctSegmenterLenAdjust = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useTrainLexicon")) {
                this.useTrainLexicon = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCWSFeatures")) {
                this.useCWSFeatures = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("appendLC")) {
                this.appendLC = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("perceptronDebug")) {
                this.perceptronDebug = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("pctSegmenterScaleByCRF")) {
                this.pctSegmenterScaleByCRF = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("pctSegmenterScale")) {
                this.pctSegmenterScale = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("separateASCIIandRange")) {
                this.separateASCIIandRange = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("dropoutRate")) {
                this.dropoutRate = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("dropoutScale")) {
                this.dropoutScale = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("multiThreadGrad")) {
                this.multiThreadGrad = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("maxQNItr")) {
                this.maxQNItr = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("dropoutApprox")) {
                this.dropoutApprox = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("unsupDropoutFile")) {
                this.unsupDropoutFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("unsupDropoutScale")) {
                this.unsupDropoutScale = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("startEvaluateIters")) {
                this.startEvaluateIters = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("multiThreadPerceptron")) {
                this.multiThreadPerceptron = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("lazyUpdate")) {
                this.lazyUpdate = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("featureCountThresh")) {
                this.featureCountThresh = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("serializeWeightsTo")) {
                this.serializeWeightsTo = val;
                continue;
            }
            if (key.equalsIgnoreCase("geDebug")) {
                this.geDebug = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("doFeatureDiscovery")) {
                this.doFeatureDiscovery = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("loadWeightsFrom")) {
                this.loadWeightsFrom = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadClassIndexFrom")) {
                this.loadClassIndexFrom = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeClassIndexTo")) {
                this.serializeClassIndexTo = val;
                continue;
            }
            if (key.equalsIgnoreCase("learnCHBasedOnEN")) {
                this.learnCHBasedOnEN = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("learnENBasedOnCH")) {
                this.learnENBasedOnCH = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("loadWeightsFromEN")) {
                this.loadWeightsFromEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadWeightsFromCH")) {
                this.loadWeightsFromCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeToEN")) {
                this.serializeToEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeToCH")) {
                this.serializeToCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("testFileEN")) {
                this.testFileEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("testFileCH")) {
                this.testFileCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("unsupFileEN")) {
                this.unsupFileEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("unsupFileCH")) {
                this.unsupFileCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("unsupAlignFile")) {
                this.unsupAlignFile = val;
                continue;
            }
            if (key.equalsIgnoreCase("supFileEN")) {
                this.supFileEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("supFileCH")) {
                this.supFileCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("serializeFeatureIndexTo")) {
                this.serializeFeatureIndexTo = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadFeatureIndexFromEN")) {
                this.loadFeatureIndexFromEN = val;
                continue;
            }
            if (key.equalsIgnoreCase("loadFeatureIndexFromCH")) {
                this.loadFeatureIndexFromCH = val;
                continue;
            }
            if (key.equalsIgnoreCase("lambdaEN")) {
                this.lambdaEN = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("lambdaCH")) {
                this.lambdaCH = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("alternateTraining")) {
                this.alternateTraining = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("weightByEntropy")) {
                this.weightByEntropy = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useKL")) {
                this.useKL = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useHardGE")) {
                this.useHardGE = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useCRFforUnsup")) {
                this.useCRFforUnsup = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useGEforSup")) {
                this.useGEforSup = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useKnownLCWords")) {
                System.err.println("useKnownLCWords is deprecated; see maxAdditionalKnownLCWords (true = -1, false = 0");
                this.maxAdditionalKnownLCWords = Boolean.parseBoolean(val) ? -1 : 0;
                continue;
            }
            if (key.equalsIgnoreCase("useNoisyLabel")) {
                this.useNoisyLabel = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("errorMatrix")) {
                this.errorMatrix = val;
                continue;
            }
            if (key.equalsIgnoreCase("printTrainLabels")) {
                this.printTrainLabels = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("labelDictionaryCutoff")) {
                this.labelDictionaryCutoff = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAdaDelta")) {
                this.useAdaDelta = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("useAdaDiff")) {
                this.useAdaDiff = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("adaGradEps")) {
                this.adaGradEps = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("adaDeltaRho")) {
                this.adaDeltaRho = Double.parseDouble(val);
                continue;
            }
            if (key.equalsIgnoreCase("useRandomSeed")) {
                this.useRandomSeed = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("terminateOnAvgImprovement")) {
                this.terminateOnAvgImprovement = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("strictGoodCoNLL")) {
                this.strictGoodCoNLL = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("removeStrictGoodCoNLLDuplicates")) {
                this.removeStrictGoodCoNLLDuplicates = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("priorModelFactory")) {
                this.priorModelFactory = val;
                continue;
            }
            if (key.equalsIgnoreCase("maxAdditionalKnownLCWords")) {
                this.maxAdditionalKnownLCWords = Integer.parseInt(val);
                continue;
            }
            if (key.equalsIgnoreCase("showNCCInfo")) {
                this.showNCCInfo = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("showCCInfo")) {
                this.showCCInfo = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("crfToExamine")) {
                this.crfToExamine = val;
                continue;
            }
            if (key.equalsIgnoreCase("ner.useSUTime")) {
                this.useSUTime = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("ner.applyNumericClassifiers")) {
                this.applyNumericClassifiers = Boolean.parseBoolean(val);
                continue;
            }
            if (key.equalsIgnoreCase("ner.combinationMode")) {
                this.combinationMode = val;
                continue;
            }
            if (key.equalsIgnoreCase("ner.model")) {
                this.nerModel = val;
                continue;
            }
            if (key.isEmpty() || key.equals("prop")) continue;
            System.err.println("Unknown property: |" + key + '|');
        }
        if (this.startFold > this.numFolds) {
            System.err.println("startFold > numFolds -> setting startFold to 1");
            this.startFold = 1;
        }
        if (this.endFold > this.numFolds) {
            System.err.println("endFold > numFolds -> setting to numFolds");
            this.endFold = this.numFolds;
        }
        if (this.combo) {
            this.splitDocuments = false;
        }
        this.stringRep = sb.toString();
    }

    private static String getFeatureFactory(String val) {
        if (val.equalsIgnoreCase("SuperSimpleFeatureFactory")) {
            val = "edu.stanford.nlp.sequences.SuperSimpleFeatureFactory";
        } else if (val.equalsIgnoreCase("NERFeatureFactory")) {
            val = "edu.stanford.nlp.ie.NERFeatureFactory";
        } else if (val.equalsIgnoreCase("GazNERFeatureFactory")) {
            val = "edu.stanford.nlp.sequences.GazNERFeatureFactory";
        } else if (val.equalsIgnoreCase("IncludeAllFeatureFactory")) {
            val = "edu.stanford.nlp.sequences.IncludeAllFeatureFactory";
        } else if (val.equalsIgnoreCase("PhraseFeatureFactory")) {
            val = "edu.stanford.nlp.article.extraction.PhraseFeatureFactory";
        } else if (val.equalsIgnoreCase("EmbeddingFeatureFactory")) {
            val = "edu.stanford.nlp.ie.EmbeddingFeatureFactory";
        }
        return val;
    }

    public String toString() {
        return this.stringRep;
    }

    public String getNotNullTrueStringRep() {
        try {
            Field[] f;
            StringBuilder rep = new StringBuilder();
            String joiner = "\n";
            for (Field ff : f = this.getClass().getFields()) {
                String name = ff.getName();
                Class<?> type = ff.getType();
                if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                    boolean val = ff.getBoolean(this);
                    if (!val) continue;
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(String.class)) {
                    String val = (String)ff.get(this);
                    if (val == null) continue;
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Double.class)) {
                    Double val = (Double)ff.get(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Double.TYPE)) {
                    double val = ff.getDouble(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Integer.class)) {
                    Integer val = (Integer)ff.get(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Integer.TYPE)) {
                    int val = ff.getInt(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Float.class)) {
                    Float val = (Float)ff.get(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Float.TYPE)) {
                    float val = ff.getFloat(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Byte.class)) {
                    Byte val = (Byte)ff.get(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Byte.TYPE)) {
                    byte val = ff.getByte(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Character.TYPE)) {
                    char val = ff.getChar(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (type.equals(Long.class)) {
                    Long val = (Long)ff.get(this);
                    rep.append(joiner).append(name).append('=').append(val);
                    continue;
                }
                if (!type.equals(Long.TYPE)) continue;
                long val = ff.getLong(this);
                rep.append(joiner).append(name).append('=').append(val);
            }
            return rep.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static enum SlashHyphenEnum {
        NONE,
        WFRAG,
        WORD,
        BOTH;

    }
}

