/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.parser.ViterbiParserWithOptions;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.international.pennchinese.CHTBTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;

public class ChineseGrammaticalStructure
extends GrammaticalStructure {
    private static HeadFinder shf = new ChineseSemanticHeadFinder();
    private static final long serialVersionUID = 8877651855167458256L;

    public ChineseGrammaticalStructure(Tree t) {
        this(t, new ChineseTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public ChineseGrammaticalStructure(Tree t, Predicate<String> puncFilter) {
        this(t, puncFilter, shf);
    }

    public ChineseGrammaticalStructure(Tree t, HeadFinder hf) {
        this(t, null, hf);
    }

    public ChineseGrammaticalStructure(Tree t, Predicate<String> puncFilter, HeadFinder hf) {
        super(t, ChineseGrammaticalRelations.values(), ChineseGrammaticalRelations.valuesLock(), null, hf, puncFilter, Filters.acceptFilter());
    }

    public ChineseGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, GrammaticalStructure.Extras includeExtras) {
        ChineseGrammaticalStructure.collapsePrepAndPoss(list);
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        Map map = Generics.newHashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), Generics.newHashSet());
            }
            ((Set)map.get(typedDep.gov())).add(typedDep);
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            IndexedWord td1Dep = td1.dep();
            String td1DepPOS = td1Dep.tag();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                if (td1.reln() != GrammaticalRelation.DEPENDENT || td2.reln() != GrammaticalRelation.DEPENDENT || !td1DepPOS.equals("P")) continue;
                GrammaticalRelation td3reln = ChineseGrammaticalRelations.valueOf(td1Dep.value());
                if (td3reln == null) {
                    td3reln = GrammaticalRelation.valueOf(Language.Chinese, td1Dep.value());
                }
                TypedDependency td3 = new TypedDependency(td3reln, td1.gov(), td2.dep());
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (!td1.reln().equals(GrammaticalRelation.KILL)) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln().equals(GrammaticalRelation.KILL)) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            if (td.reln().equals(GrammaticalRelation.KILL)) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void AddTreesFromFile(String treeFileName, String encoding, Treebank tb) {
        ChineseTreebankParserParams ctpp = new ChineseTreebankParserParams();
        try {
            Tree t;
            TreeReaderFactory trf = ctpp.treeReaderFactory();
            TreeReader tr = trf.newTreeReader(new InputStreamReader((InputStream)new FileInputStream(treeFileName), encoding));
            while ((t = tr.readTree()) != null) {
                tb.add(t);
            }
            tr.close();
        }
        catch (IOException e) {
            throw new RuntimeException("File problem: " + e);
        }
    }

    public static void main(String[] args) {
        boolean keepPunct;
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String encoding = props.getProperty("encoding", "utf-8");
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String treeFileName = props.getProperty("treeFile");
        String treeDirname = props.getProperty("treeDir");
        String sentFileName = props.getProperty("sentFile");
        boolean conllx = props.getProperty("conllx") != null;
        boolean basic = props.getProperty("basic") != null;
        boolean nonCollapsed = props.getProperty("nonCollapsed") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean bl = keepPunct = props.getProperty("keepPunct") != null;
        if (conllx) {
            keepPunct = true;
        }
        String hf = props.getProperty("hf");
        String parserModel = props.getProperty("parserModel", "/u/nlp/data/lexparser/chineseFactored.ser.gz");
        if (!basic && !collapsed) {
            if (conllx) {
                basic = true;
            } else {
                collapsed = true;
            }
        }
        try {
            if (hf != null) {
                shf = (HeadFinder)Class.forName(hf).newInstance();
                System.err.println("Using " + hf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to use HeadFinder: " + hf);
        }
        if (args.length == 0) {
            System.err.printf("Usage:\n\t%s [optional flags] -treeFile treeFile\n\nOr:\n\t%s [optional flags] -sentFile sentFile\n", ChineseGrammaticalStructure.class.getName(), ChineseGrammaticalStructure.class.getName());
            System.err.println("\nOptional flags:");
            System.err.println("\t-parseTree  : print phrase-structure parse tree");
            System.err.println("\t-basic : basic non-collapsed dependencies preserving a tree structure");
            System.err.println("\t-collapsed : collapsed dependencies");
            System.err.println("\t-conllx : conllx formatted dependencies, can be used with either basic\n\t or collaped dependencies, but basic is recommended");
        } else {
            if (treeDirname != null && treeFileName != null) {
                throw new RuntimeException("Only one of treeDirname or treeFileName should be set");
            }
            if (treeDirname != null) {
                String[] files;
                File dir = new File(treeDirname);
                for (String file : files = dir.list()) {
                    ChineseGrammaticalStructure.AddTreesFromFile(treeDirname + "/" + file, encoding, tb);
                }
            } else if (treeFileName != null) {
                ChineseGrammaticalStructure.AddTreesFromFile(treeFileName, encoding, tb);
            } else if (sentFileName != null) {
                ViterbiParserWithOptions lp;
                try {
                    Class[] classes = new Class[]{String.class};
                    Constructor<?> constr = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getConstructor(classes);
                    String[] opts = new String[]{"-retainTmpSubcategories"};
                    lp = (ViterbiParserWithOptions)constr.newInstance(parserModel);
                    lp.setOptionFlags(opts);
                }
                catch (Exception cnfe) {
                    cnfe.printStackTrace();
                    return;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(sentFileName));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot find " + sentFileName);
                    System.exit(1);
                }
                try {
                    String line;
                    System.out.println("Processing sentence file " + sentFileName);
                    while ((line = reader.readLine()) != null) {
                        CHTBTokenizer chtb = new CHTBTokenizer(new StringReader(line));
                        List words = chtb.tokenize();
                        lp.parse(words);
                        Tree tree = lp.getBestParse();
                        ((AbstractCollection)tb).add(tree);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception reading key file " + sentFileName, e);
                }
            }
        }
        for (Tree t : tb) {
            Predicate<Object> puncFilter = keepPunct ? Filters.acceptFilter() : new ChineseTreebankLanguagePack().punctuationWordRejectFilter();
            ChineseGrammaticalStructure gs = new ChineseGrammaticalStructure(t, puncFilter);
            if (parseTree) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
            }
            if (basic) {
                if (collapsed || nonCollapsed) {
                    System.out.println("------------- basic dependencies ---------------");
                }
                ChineseGrammaticalStructure.printDependencies(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), t, conllx, false);
            }
            if (nonCollapsed) {
                if (basic || collapsed) {
                    System.out.println("------------- noncollapsed dependencies ---------------");
                }
                ChineseGrammaticalStructure.printDependencies(gs, gs.typedDependencies(GrammaticalStructure.Extras.MAXIMAL), t, conllx, false);
            }
            if (!collapsed) continue;
            if (basic || nonCollapsed) {
                System.out.println("----------- collapsed dependencies -----------");
            }
            ChineseGrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), t, conllx, false);
        }
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName) throws IOException {
        return ChineseGrammaticalStructure.readCoNLLXGrammaticalStructureCollection(fileName, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static ChineseGrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields) {
        return (ChineseGrammaticalStructure)ChineseGrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static class FromDependenciesFactory
    implements GrammaticalStructureFromDependenciesFactory {
        @Override
        public ChineseGrammaticalStructure build(List<TypedDependency> tdeps, TreeGraphNode root) {
            return new ChineseGrammaticalStructure(tdeps, root);
        }
    }
}

