/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class ConfigTrustManager
implements X509TrustManager {
    private static SSLSocketFactory ssf = null;
    private X509TrustManager defaultTM = null;
    private X509TrustManager nativeTM = null;

    public ConfigTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManager[] trustManagerArray = this.generateTrustManager(false);
        TrustManager[] trustManagerArray2 = this.generateTrustManager(true);
        if (trustManagerArray.length > 0) {
            this.defaultTM = (X509TrustManager)trustManagerArray[0];
        }
        if (trustManagerArray2.length > 0) {
            this.nativeTM = (X509TrustManager)trustManagerArray2[0];
        }
    }

    public static void resetHttpsFactory(HttpsURLConnection httpsURLConnection) {
        try {
            if (ssf == null) {
                ConfigTrustManager configTrustManager = new ConfigTrustManager();
                TrustManager[] trustManagerArray = new TrustManager[]{configTrustManager};
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, trustManagerArray, null);
                ssf = sSLContext.getSocketFactory();
            }
            if (ssf != null) {
                Trace.securityPrintln("Reset SSLSocketFactory using Config TrustManager");
                httpsURLConnection.setSSLSocketFactory(ssf);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.defaultTM.getAcceptedIssuers();
        X509Certificate[] x509CertificateArray2 = this.nativeTM.getAcceptedIssuers();
        X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length + x509CertificateArray2.length];
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray.length);
        System.arraycopy(x509CertificateArray2, 0, x509CertificateArray3, x509CertificateArray.length, x509CertificateArray2.length);
        return x509CertificateArray3;
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        if (this.defaultTM == null && this.nativeTM == null) {
            throw new CertificateException("Both TrustManager are null");
        }
        if (this.defaultTM != null) {
            try {
                this.defaultTM.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                Trace.securityPrintln("Default TrustManager check failed");
                if (this.nativeTM == null) {
                    Trace.securityPrintln("No native TrustManager available");
                    throw certificateException;
                }
                bl = true;
            }
        }
        if (this.nativeTM != null && (bl || this.defaultTM == null)) {
            try {
                Trace.securityPrintln("Using native TrustManager");
                this.nativeTM.checkServerTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                Trace.securityPrintln("Native(IE browser) TrustManager check failed");
                throw certificateException;
            }
        }
    }

    private TrustManager[] generateTrustManager(boolean bl) {
        String string = "";
        try {
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
            if (bl) {
                KeyStore keyStore = KeyStore.getInstance("Windows-ROOT");
                keyStore.load(null, string.toCharArray());
                trustManagerFactory.init(keyStore);
            } else {
                trustManagerFactory.init((KeyStore)null);
            }
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

