/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.WordTagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class WordTag
implements Label,
HasWord,
HasTag,
Comparable<WordTag> {
    private String word;
    private String tag;
    private static final String DIVIDER = "/";
    private static final long serialVersionUID = -1859527239216813742L;

    public WordTag(String word, String tag) {
        this.setWord(word);
        this.setTag(tag);
    }

    public WordTag(String word) {
        this(word, null);
    }

    public <E extends Label & HasTag> WordTag(E word) {
        this(word.value(), ((HasTag)word).tag());
    }

    private WordTag() {
    }

    public WordTag(Label word, Label tag) {
        this(word.value(), tag.value());
    }

    public static WordTag valueOf(String s) {
        WordTag result = new WordTag();
        result.setFromString(s);
        return result;
    }

    public static WordTag valueOf(String s, String tagDivider) {
        WordTag result = new WordTag();
        result.setFromString(s, tagDivider);
        return result;
    }

    @Override
    public String value() {
        return this.word;
    }

    @Override
    public String word() {
        return this.value();
    }

    @Override
    public void setValue(String value) {
        this.word = value;
    }

    @Override
    public String tag() {
        return this.tag;
    }

    @Override
    public void setWord(String word) {
        this.setValue(word);
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String toString() {
        return this.toString(DIVIDER);
    }

    public String toString(String divider) {
        String tag = this.tag();
        if (tag == null) {
            return this.word();
        }
        return this.word() + divider + tag;
    }

    @Override
    public void setFromString(String wordTagString) {
        this.setFromString(wordTagString, DIVIDER);
    }

    public void setFromString(String wordTagString, String divider) {
        int where = wordTagString.lastIndexOf(divider);
        if (where >= 0) {
            this.setWord(wordTagString.substring(0, where).intern());
            this.setTag(wordTagString.substring(where + 1).intern());
        } else {
            this.setWord(wordTagString.intern());
            this.setTag(null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WordTag)) {
            return false;
        }
        WordTag wordTag = (WordTag)o;
        if (this.tag != null ? !this.tag.equals(wordTag.tag) : wordTag.tag != null) {
            return false;
        }
        return !(this.word != null ? !this.word.equals(wordTag.word) : wordTag.word != null);
    }

    public int hashCode() {
        int result = this.word != null ? this.word.hashCode() : 0;
        result = 29 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(WordTag wordTag) {
        int first;
        int n = first = this.word != null ? this.word().compareTo(wordTag.word()) : 0;
        if (first != 0) {
            return first;
        }
        if (this.tag() == null) {
            if (wordTag.tag() == null) {
                return 0;
            }
            return -1;
        }
        return this.tag().compareTo(wordTag.tag());
    }

    @Override
    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    public void read(DataInputStream in) {
        try {
            this.word = in.readUTF();
            this.tag = in.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(DataOutputStream out2) {
        try {
            out2.writeUTF(this.word);
            out2.writeUTF(this.tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class LabelFactoryHolder {
        private static final LabelFactory lf = new WordTagFactory();

        private LabelFactoryHolder() {
        }
    }
}

