/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IterableIterator;
import edu.stanford.nlp.util.logging.Color;
import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import edu.stanford.nlp.util.logging.RedwoodPrintStream;
import edu.stanford.nlp.util.logging.Style;
import edu.stanford.nlp.util.logging.VisibilityHandler;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class Redwood {
    public static final Flag ERR = Flag.ERROR;
    public static final Flag WARN = Flag.WARN;
    public static final Flag DBG = Flag.DEBUG;
    public static final Flag FORCE = Flag.FORCE;
    public static final Flag STDOUT = Flag.STDOUT;
    public static final Flag STDERR = Flag.STDERR;
    protected static final PrintStream realSysOut = System.out;
    protected static final PrintStream realSysErr = System.err;
    private static RecordHandlerTree handlers = new RecordHandlerTree();
    private static int depth = 0;
    private static final Stack<String> titleStack = new Stack();
    private static boolean isClosed = false;
    private static final Map<Long, Queue<Runnable>> threadedLogQueue = Generics.newHashMap();
    private static long currentThread = -1L;
    private static final Queue<Long> threadsWaiting = new LinkedList<Long>();
    private static boolean isThreaded = false;
    private static final ReentrantLock control = new ReentrantLock();
    public static final boolean supportsAnsi;

    private Redwood() {
    }

    private static void queueTask(long threadId, Runnable toRun) {
        assert (control.isHeldByCurrentThread());
        assert (threadId != currentThread);
        if (!threadedLogQueue.containsKey(threadId)) {
            threadedLogQueue.put(threadId, new LinkedList());
        }
        Queue<Runnable> threadLogQueue = threadedLogQueue.get(threadId);
        threadLogQueue.offer(toRun);
        if (!threadsWaiting.contains(threadId)) {
            threadsWaiting.offer(threadId);
            assert (threadedLogQueue.get(threadId) != null && !threadedLogQueue.get(threadId).isEmpty());
        }
    }

    private static void releaseThreadControl(long threadId) {
        assert (!isThreaded || control.isHeldByCurrentThread());
        assert (currentThread < 0L || currentThread == threadId);
        currentThread = -1L;
    }

    private static void attemptThreadControl(long threadId, Runnable r) {
        boolean tookLock = false;
        if (!control.isHeldByCurrentThread()) {
            control.lock();
            tookLock = true;
        }
        Redwood.attemptThreadControlThreadsafe(threadId);
        if (threadId == currentThread) {
            r.run();
        } else {
            Redwood.queueTask(threadId, r);
        }
        assert (control.isHeldByCurrentThread());
        if (tookLock) {
            control.unlock();
        }
    }

    private static void attemptThreadControlThreadsafe(long threadId) {
        assert (control.isHeldByCurrentThread());
        boolean hopeless = true;
        if (currentThread < 0L) {
            if (threadsWaiting.isEmpty()) {
                currentThread = threadId;
            } else {
                currentThread = threadsWaiting.poll();
                hopeless = false;
                assert (threadedLogQueue.get(currentThread) == null || !threadedLogQueue.get(currentThread).isEmpty());
            }
        } else if (currentThread == threadId) {
            threadsWaiting.remove(currentThread);
        } else if (currentThread >= 0L) {
            threadsWaiting.remove(currentThread);
        } else assert (false);
        long activeThread = currentThread;
        Queue<Runnable> backlog = threadedLogQueue.get(currentThread);
        if (backlog != null) {
            while (!backlog.isEmpty() && currentThread >= 0L) {
                backlog.poll().run();
            }
            if (currentThread < 0L && !backlog.isEmpty()) {
                threadsWaiting.offer(activeThread);
                hopeless = false;
            }
        }
        if (!hopeless && currentThread != threadId) {
            Redwood.attemptThreadControlThreadsafe(threadId);
        }
        assert (!threadsWaiting.contains(currentThread));
        assert (control.isHeldByCurrentThread());
    }

    protected static RecordHandlerTree rootHandler() {
        return handlers;
    }

    protected static void clearHandlers() {
        handlers = new RecordHandlerTree();
    }

    @Deprecated
    private static <E extends LogRecordHandler> E getHandler(Class<E> clazz) {
        for (LogRecordHandler cand : handlers) {
            if (clazz != cand.getClass()) continue;
            return (E)cand;
        }
        return null;
    }

    protected static void captureSystemStreams(boolean captureOut, boolean captureErr) {
        if (captureOut) {
            System.setOut(new RedwoodPrintStream(STDOUT, realSysOut));
        } else {
            System.setOut(realSysOut);
        }
        if (captureErr) {
            System.setErr(new RedwoodPrintStream(STDERR, realSysErr));
        } else {
            System.setErr(realSysErr);
        }
    }

    protected static void restoreSystemStreams() {
        System.setOut(realSysOut);
        System.setErr(realSysErr);
    }

    public static void log(Object ... args) {
        if (args.length == 0) {
            return;
        }
        if (isClosed) {
            return;
        }
        final Object content = args[args.length - 1];
        final Object[] tags = new Object[args.length - 1];
        System.arraycopy(args, 0, tags, 0, args.length - 1);
        final long timestamp = System.currentTimeMillis();
        if (isThreaded) {
            Runnable log = new Runnable(){

                @Override
                public void run() {
                    assert (!isThreaded || control.isHeldByCurrentThread());
                    Record toPass = new Record(content, tags, depth, timestamp);
                    handlers.process(toPass, MessageType.SIMPLE, depth, toPass.timesstamp);
                    assert (!isThreaded || control.isHeldByCurrentThread());
                }
            };
            long threadId = Thread.currentThread().getId();
            Redwood.attemptThreadControl(threadId, log);
        } else {
            Record toPass = new Record(content, tags, depth, timestamp);
            Redwood.handlers.process(toPass, MessageType.SIMPLE, Redwood.depth, toPass.timesstamp);
        }
    }

    public static void logf(String format, Object ... args) {
        Redwood.log(new Formatter().format(format, args));
    }

    public static void startTrack(final Object ... args) {
        if (isClosed) {
            return;
        }
        final int len = args.length == 0 ? 0 : args.length - 1;
        final String content = args.length == 0 ? "" : args[len];
        final Object[] tags = new Object[len];
        final long timestamp = System.currentTimeMillis();
        System.arraycopy(args, 0, tags, 0, len);
        Runnable startTrack = new Runnable(){

            @Override
            public void run() {
                assert (!isThreaded || control.isHeldByCurrentThread());
                Record toPass = new Record(content, tags, depth, timestamp);
                depth += 1;
                titleStack.push(args.length == 0 ? "" : args[len].toString());
                handlers.process(toPass, MessageType.START_TRACK, depth, toPass.timesstamp);
                assert (!isThreaded || control.isHeldByCurrentThread());
            }
        };
        if (isThreaded) {
            long threadId = Thread.currentThread().getId();
            Redwood.attemptThreadControl(threadId, startTrack);
        } else {
            startTrack.run();
        }
    }

    public static void forceTrack(Object name) {
        Redwood.startTrack(new Object[]{FORCE, name});
    }

    public static void forceTrack() {
        Redwood.startTrack(new Object[]{FORCE, ""});
    }

    public static void endTrack(final String title) {
        if (isClosed) {
            return;
        }
        final long timestamp = System.currentTimeMillis();
        Runnable endTrack = new Runnable(){

            @Override
            public void run() {
                assert (!isThreaded || control.isHeldByCurrentThread());
                String expected = (String)titleStack.pop();
                if (!isThreaded && !expected.equalsIgnoreCase(title)) {
                    throw new IllegalArgumentException("Track names do not match: expected: " + expected + " found: " + title);
                }
                depth -= 1;
                handlers.process(null, MessageType.END_TRACK, depth, timestamp);
                assert (!isThreaded || control.isHeldByCurrentThread());
            }
        };
        if (isThreaded) {
            long threadId = Thread.currentThread().getId();
            Redwood.attemptThreadControl(threadId, endTrack);
        } else {
            endTrack.run();
        }
    }

    public static void endTrack() {
        Redwood.endTrack("");
    }

    public static void startThreads(String title) {
        if (isThreaded) {
            throw new IllegalStateException("Cannot nest Redwood threaded environments");
        }
        Redwood.startTrack(new Object[]{FORCE, "Threads( " + title + " )"});
        isThreaded = true;
    }

    public static void finishThread() {
        final long threadId = Thread.currentThread().getId();
        Runnable finish = new Runnable(){

            @Override
            public void run() {
                Redwood.releaseThreadControl(threadId);
            }
        };
        if (isThreaded) {
            Redwood.attemptThreadControl(threadId, finish);
        } else {
            Redwood.log(new Object[]{Flag.WARN, "finishThreads() called outside of threaded environment"});
        }
    }

    public static void endThreads(String check) {
        isThreaded = false;
        if (currentThread != -1L) {
            Redwood.log(new Object[]{Flag.WARN, "endThreads() called, but thread " + currentThread + " has not finished (exception in thread?)"});
        }
        assert (!control.isHeldByCurrentThread());
        boolean cleanPass = false;
        while (!cleanPass) {
            cleanPass = true;
            Iterator<Object> i$ = threadedLogQueue.keySet().iterator();
            while (i$.hasNext()) {
                long l = (Long)i$.next();
                assert (currentThread < 0L);
                if (threadedLogQueue.get(l) == null || threadedLogQueue.get(l).isEmpty()) continue;
                cleanPass = false;
                Queue<Runnable> backlog = threadedLogQueue.get(l);
                currentThread = l;
                while (currentThread >= 0L) {
                    if (backlog.isEmpty()) {
                        Redwood.log(new Object[]{Flag.WARN, "Forgot to call finishThread() on thread " + currentThread});
                    }
                    assert (!control.isHeldByCurrentThread());
                    backlog.poll().run();
                }
                threadsWaiting.remove(l);
            }
        }
        while (threadsWaiting.size() > 0) {
            assert (currentThread < 0L);
            assert (control.tryLock());
            assert (!threadsWaiting.isEmpty());
            control.lock();
            Redwood.attemptThreadControlThreadsafe(-1L);
            control.unlock();
        }
        for (Map.Entry entry : threadedLogQueue.entrySet()) {
            assert (((Queue)entry.getValue()).isEmpty());
        }
        assert (threadsWaiting.isEmpty());
        assert (currentThread == -1L);
        Redwood.endTrack("Threads( " + check + " )");
    }

    public static RedwoodChannels channels(Object ... channelNames) {
        return new RedwoodChannels(channelNames);
    }

    public static void hideChannelsEverywhere(Object ... channels) {
        for (LogRecordHandler handler : handlers) {
            if (!(handler instanceof VisibilityHandler)) continue;
            VisibilityHandler visHandler = (VisibilityHandler)handler;
            for (Object channel : channels) {
                visHandler.alsoHide(channel);
            }
        }
    }

    public static void stop() {
        isClosed = true;
        Thread.yield();
        Thread.yield();
        while (depth > 0) {
            Redwood.handlers.process(null, MessageType.END_TRACK, --Redwood.depth, System.currentTimeMillis());
        }
        Redwood.handlers.process(null, MessageType.SHUTDOWN, 0, System.currentTimeMillis());
    }

    protected static void formatTimeDifference(long diff, StringBuilder b) {
        int mili = (int)diff % 1000;
        long rest = diff / 1000L;
        int sec = (int)rest % 60;
        int min = (int)(rest /= 60L) % 60;
        int hr = (int)(rest /= 60L) % 24;
        int day = (int)(rest /= 24L);
        if (day > 0) {
            b.append(day).append(day > 1 ? " days, " : " day, ");
        }
        if (hr > 0) {
            b.append(hr).append(hr > 1 ? " hours, " : " hour, ");
        }
        if (min > 0) {
            if (min < 10) {
                b.append("0");
            }
            b.append(min).append(":");
        }
        if (min > 0 && sec < 10) {
            b.append("0");
        }
        b.append(sec).append(".").append(mili);
        if (min > 0) {
            b.append(" minutes");
        } else {
            b.append(" seconds");
        }
    }

    public static String formatTimeDifference(long diff) {
        StringBuilder b = new StringBuilder();
        Redwood.formatTimeDifference(diff, b);
        return b.toString();
    }

    public static void main(String[] args) {
        Redwood.log(new Object[]{DBG, "hello world!"});
        Redwood.hideChannelsEverywhere(new Object[]{DBG});
        Redwood.log(new Object[]{DBG, "hello debug!"});
        System.exit(1);
        LinkedList<Runnable> tasks = new LinkedList<Runnable>();
        int i = 0;
        while (i < 1000) {
            final int fI = i++;
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    Redwood.startTrack("Runnable " + fI);
                    Redwood.log(Thread.currentThread().getId());
                    Redwood.log("message " + fI + ".1");
                    Redwood.log("message " + fI + ".2");
                    Redwood.log("message " + fI + ".3");
                    Redwood.log(new Object[]{FORCE, "message " + fI + ".4"});
                    Redwood.log("message " + fI + ".5");
                    Redwood.forceTrack("Runnable " + fI + ".1");
                    Redwood.endTrack("Runnable " + fI + ".1");
                    Redwood.forceTrack("Runnable " + fI + ".2");
                    Redwood.log("a message");
                    Redwood.endTrack("Runnable " + fI + ".2");
                    Redwood.forceTrack("Runnable " + fI + ".3");
                    Redwood.log("a message");
                    Redwood.log(new Object[]{FORCE, "A forced message"});
                    Redwood.endTrack("Runnable " + fI + ".3");
                    Redwood.endTrack("Runnable " + fI);
                }
            });
        }
        Redwood.startTrack("Wrapper");
        for (i = 0; i < 100; ++i) {
            Util.threadAndRun(tasks, 100);
        }
        Redwood.endTrack("Wrapper");
        System.exit(1);
        Redwood.forceTrack("Track 1");
        Redwood.log(new Object[]{"tag", ERR, "hello world"});
        Redwood.startTrack("Hidden");
        Redwood.startTrack("Subhidden");
        Redwood.endTrack("Subhidden");
        Redwood.endTrack("Hidden");
        Redwood.startTrack(new Object[]{FORCE, "Shown"});
        Redwood.startTrack(new Object[]{FORCE, "Subshown"});
        Redwood.endTrack("Subshown");
        Redwood.endTrack("Shown");
        Redwood.log("^shown should have appeared above");
        Redwood.startTrack("Track 1.1");
        Redwood.log(new Object[]{WARN, "some", "something in 1.1"});
        Redwood.log(new Object[]{"some", ERR, "something in 1.1"});
        Redwood.log(new Object[]{FORCE, "some", WARN, "something in 1.1"});
        Redwood.log(new Object[]{WARN, FORCE, "some", "something in 1.1"});
        Redwood.logf("format string %s then int %d", "hello", 7);
        Redwood.endTrack("Track 1.1");
        Redwood.startTrack(new Object[0]);
        Redwood.log("In an anonymous track");
        Redwood.endTrack();
        Redwood.endTrack("Track 1");
        Redwood.log("outside of a track");
        Redwood.log(new Object[]{"these", "channels", "should", "be", "in", DBG, "alphabetical", "order", "a log item with lots of channels"});
        Redwood.log(new Object[]{"these", "channels", "should", "be", "in", DBG, "alphabetical", "order", "a log item\nthat spans\nmultiple\nlines"});
        Redwood.log(new Object[]{DBG, "a last log item"});
        Redwood.log(new Object[]{ERR, null});
        Redwood.forceTrack("Strict Equality");
        for (i = 0; i < 100; ++i) {
            Redwood.log("this is a message");
        }
        Redwood.endTrack("Strict Equality");
        Redwood.forceTrack("Change");
        for (i = 0; i < 10; ++i) {
            Redwood.log("this is a message");
        }
        for (i = 0; i < 10; ++i) {
            Redwood.log("this is a another message");
        }
        for (i = 0; i < 10; ++i) {
            Redwood.log("this is a third message");
        }
        for (i = 0; i < 5; ++i) {
            Redwood.log("this is a fourth message");
        }
        Redwood.log(new Object[]{FORCE, "this is a fourth message"});
        for (i = 0; i < 5; ++i) {
            Redwood.log("this is a fourth message");
        }
        Redwood.log("^middle 'fourth message' was forced");
        Redwood.endTrack("Change");
        Redwood.forceTrack("Repeated Tracks");
        for (i = 0; i < 100; ++i) {
            Redwood.startTrack("Track type 1");
            Redwood.log("a message");
            Redwood.endTrack("Track type 1");
        }
        for (i = 0; i < 100; ++i) {
            Redwood.startTrack("Track type 2");
            Redwood.log("a message");
            Redwood.endTrack("Track type 2");
        }
        for (i = 0; i < 100; ++i) {
            Redwood.startTrack("Track type 3");
            Redwood.log("a message");
            Redwood.endTrack("Track type 3");
        }
        Redwood.startTrack("Track type 3");
        Redwood.startTrack("nested");
        Redwood.log(new Object[]{FORCE, "this should show up"});
        Redwood.endTrack("nested");
        Redwood.endTrack("Track type 3");
        for (i = 0; i < 5; ++i) {
            Redwood.startTrack("Track type 3");
            Redwood.log(new Object[]{FORCE, "this should show up"});
            Redwood.endTrack("Track type 3");
        }
        Redwood.log(new Object[]{WARN, "The log message 'this should show up' should show up 6 (5+1) times above"});
        Redwood.endTrack("Repeated Tracks");
        Redwood.forceTrack("Hidden Subtracks");
        for (i = 0; i < 100; ++i) {
            Redwood.startTrack("Only has debug messages");
            Redwood.log(new Object[]{DBG, "You shouldn't see me"});
            Redwood.endTrack("Only has debug messages");
        }
        Redwood.log("You shouldn't see any other messages or 'skipped tracks' here");
        Redwood.endTrack("Hidden Subtracks");
        RedwoodConfiguration.standard().apply();
        Redwood.forceTrack("Fuzzy Equality");
        for (i = 0; i < 100; ++i) {
            Redwood.log("iter " + i + " ended with value " + (-3.4587292534E10 + Math.sqrt(i) * 3.0E9));
        }
        Redwood.endTrack("Fuzzy Equality");
        Redwood.forceTrack("Fuzzy Equality (timing)");
        for (i = 0; i < 100; ++i) {
            Redwood.log("iter " + i + " ended with value " + (-3.4587292534E10 + Math.sqrt(i) * 3.0E9));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Redwood.endTrack("Fuzzy Equality (timing)");
        Util.log("hello world");
        Util.log(new Object[]{DBG, "hello world"});
        Util.debug("hello world");
        Util.debug("atag", "hello world");
        Redwood.getHandler(ConsoleHandler.class).minLineCountForTrackNameReminder = 5;
        Redwood.startTrack("Long Track");
        for (i = 0; i < 10; ++i) {
            Redwood.log(new Object[]{FORCE, "contents of long track"});
        }
        Redwood.endTrack("Long TracK");
        Redwood.startTrack("Long Track");
        Redwood.startTrack("But really this is the long one");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (i = 0; i < 10; ++i) {
            Redwood.log(new Object[]{FORCE, "contents of long track"});
        }
        Redwood.endTrack("But really this is the long one");
        Redwood.endTrack("Long TracK");
        Redwood.getHandler(ConsoleHandler.class).minLineCountForTrackNameReminder = 50;
        ExecutorService exec = Executors.newFixedThreadPool(10);
        Redwood.startThreads("name");
        int i2 = 0;
        while (i2 < 50) {
            final int theI = i2++;
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    Redwood.startTrack("Thread " + theI + " (" + Thread.currentThread().getId() + ")");
                    for (int time = 0; time < 5; ++time) {
                        Redwood.log("tick " + time + " from " + theI + " (" + Thread.currentThread().getId() + ")");
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Redwood.endTrack("Thread " + theI + " (" + Thread.currentThread().getId() + ")");
                    Redwood.finishThread();
                }
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Redwood.endThreads("name");
        Redwood.captureSystemStreams(true, true);
        System.out.println("Hello World");
        System.err.println("This is an error!");
        for (i = 0; i < 100; ++i) {
            Redwood.log("stuff!");
        }
        Util.exit(0);
        System.out.println("I'm going to exception soon (on purpose)");
        RedwoodConfiguration.current().neatExit().apply();
        Redwood.startTrack("I should close");
        Redwood.log(new Object[]{FORCE, "so I'm nonempty..."});
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        boolean isUnix = os.contains("unix") || os.contains("linux") || os.contains("solaris");
        supportsAnsi = Boolean.getBoolean("Ansi") || isUnix;
        RedwoodConfiguration.standard().apply();
    }

    protected static enum Flag {
        ERROR,
        WARN,
        DEBUG,
        STDOUT,
        STDERR,
        FORCE;

    }

    public static class RedwoodChannels {
        private final Object[] channelNames;

        public RedwoodChannels(Object ... channelNames) {
            this.channelNames = channelNames;
        }

        public RedwoodChannels channels(Object ... moreChannelNames) {
            Object[] result = new Object[this.channelNames.length + moreChannelNames.length];
            System.arraycopy(this.channelNames, 0, result, 0, this.channelNames.length);
            System.arraycopy(moreChannelNames, 0, result, this.channelNames.length, moreChannelNames.length);
            return new RedwoodChannels(result);
        }

        public void log(Object ... obj) {
            Object[] newArgs = new Object[this.channelNames.length + obj.length];
            System.arraycopy(this.channelNames, 0, newArgs, 0, this.channelNames.length);
            System.arraycopy(obj, 0, newArgs, this.channelNames.length, obj.length);
            Redwood.log(newArgs);
        }

        public void logf(String format, Object ... args) {
            this.log(new Formatter().format(format, args));
        }

        public void prettyLog(Object obj) {
            PrettyLogger.log(this, obj);
        }

        public void prettyLog(String description, Object obj) {
            PrettyLogger.log(this, description, obj);
        }

        public void warn(Object ... objs) {
            this.log(Util.revConcat(objs, new Object[]{WARN}));
        }

        public void debug(Object ... objs) {
            this.log(Util.revConcat(objs, new Object[]{DBG}));
        }

        public void err(Object ... objs) {
            this.log(Util.revConcat(objs, new Object[]{ERR, FORCE}));
        }

        public void fatal(Object ... objs) {
            this.log(Util.revConcat(objs, new Object[]{ERR, FORCE}));
            System.exit(1);
        }
    }

    public static class Util {
        public static final Flag ERR = Flag.ERROR;
        public static final Flag WARN = Flag.WARN;
        public static final Flag DBG = Flag.DEBUG;
        public static final Flag FORCE = Flag.FORCE;
        public static final Flag STDOUT = Flag.STDOUT;
        public static final Flag STDERR = Flag.STDERR;
        public static final Style BOLD = Style.BOLD;
        public static final Style DIM = Style.DIM;
        public static final Style ITALIC = Style.ITALIC;
        public static final Style UNDERLINE = Style.UNDERLINE;
        public static final Style BLINK = Style.BLINK;
        public static final Style CROSS_OUT = Style.CROSS_OUT;
        public static final Color BLACK = Color.BLACK;
        public static final Color RED = Color.RED;
        public static final Color GREEN = Color.GREEN;
        public static final Color YELLOW = Color.YELLOW;
        public static final Color BLUE = Color.BLUE;
        public static final Color MAGENTA = Color.MAGENTA;
        public static final Color CYAN = Color.CYAN;
        public static final Color WHITE = Color.WHITE;

        private Util() {
        }

        private static Object[] revConcat(Object[] B, Object ... A) {
            Object[] C = new Object[A.length + B.length];
            System.arraycopy(A, 0, C, 0, A.length);
            System.arraycopy(B, 0, C, A.length, B.length);
            return C;
        }

        public static void prettyLog(Object obj) {
            PrettyLogger.log(obj);
        }

        public static void prettyLog(String description, Object obj) {
            PrettyLogger.log(description, obj);
        }

        public static void log(Object ... objs) {
            Redwood.log(objs);
        }

        public static void logf(String format, Object ... args) {
            Redwood.logf(format, args);
        }

        public static void warn(Object ... objs) {
            Redwood.log(Util.revConcat(objs, new Object[]{WARN}));
        }

        public static void debug(Object ... objs) {
            Redwood.log(Util.revConcat(objs, new Object[]{DBG}));
        }

        public static void err(Object ... objs) {
            Redwood.log(Util.revConcat(objs, new Object[]{ERR, FORCE}));
        }

        public static void fatal(Object ... objs) {
            Redwood.log(Util.revConcat(objs, new Object[]{ERR, FORCE}));
            System.exit(1);
        }

        public static void println(Object o) {
            System.out.println(o);
        }

        public static void exit(int exitCode) {
            Redwood.stop();
            System.exit(exitCode);
        }

        public static void exit() {
            Util.exit(0);
        }

        public static RuntimeException fail(Object msg) {
            if (msg instanceof String) {
                return new RuntimeException((String)msg);
            }
            if (msg instanceof RuntimeException) {
                return (RuntimeException)msg;
            }
            if (msg instanceof Throwable) {
                return new RuntimeException((Throwable)msg);
            }
            throw new RuntimeException(msg.toString());
        }

        public static RuntimeException fail() {
            return new RuntimeException();
        }

        public static void startTrack(Object ... objs) {
            Redwood.startTrack(objs);
        }

        public static void forceTrack(String title) {
            Redwood.startTrack(new Object[]{FORCE, title});
        }

        public static void endTrack(String check) {
            Redwood.endTrack(check);
        }

        public static void endTrack() {
            Redwood.endTrack();
        }

        public static void endTrackIfOpen(String check) {
            if (!titleStack.empty() && ((String)titleStack.peek()).equals(check)) {
                Redwood.endTrack(check);
            }
        }

        public static void endTracksUntil(String check) {
            while (!titleStack.empty() && !((String)titleStack.peek()).equals(check)) {
                Redwood.endTrack((String)titleStack.peek());
            }
        }

        public static void endTracksTo(String check) {
            Util.endTracksUntil(check);
            Util.endTrack(check);
        }

        public static void startThreads(String title) {
            Redwood.startThreads(title);
        }

        public static void finishThread() {
            Redwood.finishThread();
        }

        public static void endThreads(String check) {
            Redwood.endThreads(check);
        }

        public static RedwoodChannels channels(Object ... channels) {
            return new RedwoodChannels(channels);
        }

        public static Iterable<Runnable> thread(final String title, Iterable<Runnable> runnables) {
            final AtomicBoolean haveStarted = new AtomicBoolean(false);
            final ReentrantLock metaInfoLock = new ReentrantLock();
            final AtomicInteger numPending = new AtomicInteger(0);
            final Iterator<Runnable> iter = runnables.iterator();
            return new IterableIterator<Runnable>(new Iterator<Runnable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    Iterator iterator = iter;
                    synchronized (iterator) {
                        return iter.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized Runnable next() {
                    Runnable runnable;
                    Iterator iterator = iter;
                    synchronized (iterator) {
                        runnable = (Runnable)iter.next();
                    }
                    while (numPending.get() > 100) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    numPending.incrementAndGet();
                    Runnable toReturn = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block10: {
                                boolean threadFinished = false;
                                try {
                                    metaInfoLock.lock();
                                    if (!haveStarted.getAndSet(true)) {
                                        Util.startThreads(title);
                                    }
                                    metaInfoLock.unlock();
                                    try {
                                        runnable.run();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        System.exit(1);
                                    }
                                    catch (AssertionError e) {
                                        ((Throwable)((Object)e)).printStackTrace();
                                        System.exit(1);
                                    }
                                    Util.finishThread();
                                    threadFinished = true;
                                    int numStillPending = numPending.decrementAndGet();
                                    Iterator iterator = iter;
                                    synchronized (iterator) {
                                        if (numStillPending <= 0 && !iter.hasNext()) {
                                            Util.endThreads(title);
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    if (threadFinished) break block10;
                                    Util.finishThread();
                                }
                            }
                        }
                    };
                    return toReturn;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void remove() {
                    Iterator iterator = iter;
                    synchronized (iterator) {
                        iter.remove();
                    }
                }
            });
        }

        public static Iterable<Runnable> thread(Iterable<Runnable> runnables) {
            return Util.thread("", runnables);
        }

        public static void threadAndRun(String title, Iterable<Runnable> runnables, int numThreads) {
            if (numThreads <= 1 || isThreaded || runnables instanceof Collection && ((Collection)runnables).size() <= 1) {
                Util.startTrack("Threads (" + title + ")");
                for (Runnable toRun : runnables) {
                    toRun.run();
                }
                Util.endTrack("Threads (" + title + ")");
                return;
            }
            ExecutorService exec = Executors.newFixedThreadPool(numThreads);
            for (Runnable toRun : Util.thread(title, runnables)) {
                exec.submit(toRun);
            }
            exec.shutdown();
            try {
                exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public static void threadAndRun(String title, Iterable<Runnable> runnables) {
            Util.threadAndRun(title, runnables, Runtime.getRuntime().availableProcessors());
        }

        public static void threadAndRun(Iterable<Runnable> runnables, int numThreads) {
            Util.threadAndRun("" + numThreads, runnables, numThreads);
        }

        public static void threadAndRun(Iterable<Runnable> runnables) {
            Util.threadAndRun(runnables, Execution.threads);
        }

        public static void printChannels(int width) {
            for (LogRecordHandler handler : handlers) {
                if (!(handler instanceof OutputHandler)) continue;
                ((OutputHandler)handler).leftMargin = width;
            }
        }
    }

    public static class FileHandler
    extends OutputHandler {
        private PrintWriter printWriter;

        public FileHandler(String filename) {
            try {
                this.printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8")));
            }
            catch (IOException e) {
                Redwood.log(new Object[]{Flag.ERROR, e});
            }
        }

        @Override
        public void print(Object[] channels, String line) {
            this.printWriter.write(line == null ? "null" : line);
            this.printWriter.flush();
        }
    }

    public static class ConsoleHandler
    extends OutputHandler {
        PrintStream stream;

        private ConsoleHandler(PrintStream stream) {
            this.stream = stream;
        }

        @Override
        public void print(Object[] channels, String line) {
            this.stream.print(line);
            this.stream.flush();
        }

        @Override
        public boolean supportsAnsi() {
            return true;
        }

        public static ConsoleHandler out() {
            return new ConsoleHandler(realSysOut);
        }

        public static ConsoleHandler err() {
            return new ConsoleHandler(realSysErr);
        }
    }

    public static class Record {
        public final Object content;
        private final Object[] channels;
        public final int depth;
        public final long timesstamp;
        public final long thread = Thread.currentThread().getId();
        private boolean channelsSorted = false;

        protected Record(Object content, Object[] channels, int depth, long timestamp) {
            this.content = content;
            this.channels = channels;
            this.depth = depth;
            this.timesstamp = timestamp;
        }

        private void sort() {
            if (!this.channelsSorted && this.channels.length > 1) {
                Arrays.sort(this.channels, new Comparator<Object>(){

                    @Override
                    public int compare(Object a, Object b) {
                        if (a == FORCE) {
                            return -1;
                        }
                        if (b == FORCE) {
                            return 1;
                        }
                        if (a instanceof Flag && !(b instanceof Flag)) {
                            return -1;
                        }
                        if (b instanceof Flag && !(a instanceof Flag)) {
                            return 1;
                        }
                        return a.toString().compareTo(b.toString());
                    }
                });
            }
        }

        public boolean force() {
            this.sort();
            return this.channels.length > 0 && this.channels[0] == FORCE;
        }

        public Object[] channels() {
            this.sort();
            return this.channels;
        }

        public String toString() {
            return "Record [content=" + this.content + ", depth=" + this.depth + ", channels=" + Arrays.toString(this.channels()) + ", thread=" + this.thread + ", timesstamp=" + this.timesstamp + "]";
        }
    }

    protected static class RecordHandlerTree
    implements Iterable<LogRecordHandler> {
        private final boolean isRoot;
        private final LogRecordHandler head;
        private final List<RecordHandlerTree> children = new ArrayList<RecordHandlerTree>();

        public RecordHandlerTree() {
            this.isRoot = true;
            this.head = null;
        }

        public RecordHandlerTree(LogRecordHandler head) {
            this.isRoot = false;
            this.head = head;
        }

        public LogRecordHandler head() {
            return this.head;
        }

        public Iterator<RecordHandlerTree> children() {
            return this.children.iterator();
        }

        public void addChild(LogRecordHandler handler) {
            if (depth != 0) {
                throw new IllegalStateException("Cannot modify Redwood when within a track");
            }
            this.children.add(new RecordHandlerTree(handler));
        }

        protected void addChildTree(RecordHandlerTree tree) {
            if (depth != 0) {
                throw new IllegalStateException("Cannot modify Redwood when within a track");
            }
            this.children.add(tree);
        }

        public LogRecordHandler removeChild(LogRecordHandler handler) {
            if (depth != 0) {
                throw new IllegalStateException("Cannot modify Redwood when within a track");
            }
            Iterator<RecordHandlerTree> iter = this.children();
            while (iter.hasNext()) {
                LogRecordHandler cand = iter.next().head();
                if (cand != handler) continue;
                iter.remove();
                return cand;
            }
            return null;
        }

        public RecordHandlerTree find(LogRecordHandler toFind) {
            if (toFind == this.head()) {
                return this;
            }
            Iterator<RecordHandlerTree> iter = this.children();
            while (iter.hasNext()) {
                RecordHandlerTree cand = iter.next().find(toFind);
                if (cand == null) continue;
                return cand;
            }
            return null;
        }

        @Override
        public Iterator<LogRecordHandler> iterator() {
            return new Iterator<LogRecordHandler>(){
                private boolean seenHead;
                private final Iterator<RecordHandlerTree> childrenIter;
                private final RecordHandlerTree childOnPrix;
                private Iterator<LogRecordHandler> childIter;
                private LogRecordHandler lastReturned;
                {
                    this.seenHead = RecordHandlerTree.this.isRoot;
                    this.childrenIter = RecordHandlerTree.this.children();
                    this.childOnPrix = this.childrenIter.hasNext() ? this.childrenIter.next() : null;
                    this.childIter = this.childOnPrix == null ? null : this.childOnPrix.iterator();
                    this.lastReturned = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.childIter != null && !this.childIter.hasNext() && this.childrenIter.hasNext()) {
                        this.childIter = this.childrenIter.next().iterator();
                    }
                    return !this.seenHead || this.childIter != null && this.childIter.hasNext();
                }

                @Override
                public LogRecordHandler next() {
                    if (!this.seenHead) {
                        this.seenHead = true;
                        return RecordHandlerTree.this.head();
                    }
                    this.lastReturned = this.childIter.next();
                    return this.lastReturned;
                }

                @Override
                public void remove() {
                    if (!this.seenHead) {
                        throw new IllegalStateException("INTERNAL: this shouldn't happen...");
                    }
                    if (this.lastReturned == null) {
                        throw new IllegalStateException("Called remove() before any elements returned");
                    }
                    if (this.childOnPrix != null && this.lastReturned == this.childOnPrix.head()) {
                        this.childrenIter.remove();
                    } else if (this.childIter != null) {
                        this.childIter.remove();
                    } else {
                        throw new IllegalStateException("INTERNAL: not sure what we're removing");
                    }
                }
            };
        }

        private static List<Record> append(List<Record> lst, Record toAppend) {
            if (lst == LogRecordHandler.EMPTY) {
                lst = new ArrayList<Record>();
            }
            lst.add(toAppend);
            return lst;
        }

        private void process(Record toPass, MessageType type, int newDepth, long timestamp) {
            List<Object> toPassOn;
            block19: {
                block18: {
                    if (this.head == null) break block18;
                    switch (type) {
                        case SIMPLE: {
                            toPassOn = this.head.handle(toPass);
                            break block19;
                        }
                        case START_TRACK: {
                            toPassOn = this.head.signalStartTrack(toPass);
                            break block19;
                        }
                        case END_TRACK: {
                            toPassOn = this.head.signalEndTrack(newDepth, timestamp);
                            break block19;
                        }
                        case SHUTDOWN: {
                            toPassOn = this.head.signalShutdown();
                            break block19;
                        }
                        default: {
                            throw new IllegalStateException("MessageType was non-exhaustive: " + (Object)((Object)type));
                        }
                    }
                }
                toPassOn = new ArrayList();
                switch (type) {
                    case SIMPLE: {
                        toPassOn = RecordHandlerTree.append(toPassOn, toPass);
                        break;
                    }
                    case START_TRACK: {
                        break;
                    }
                    case END_TRACK: {
                        break;
                    }
                    case SHUTDOWN: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("MessageType was non-exhaustive: " + (Object)((Object)type));
                    }
                }
            }
            Iterator<RecordHandlerTree> iter = this.children();
            block16: while (iter.hasNext()) {
                RecordHandlerTree child = iter.next();
                for (Record record : toPassOn) {
                    child.process(record, MessageType.SIMPLE, newDepth, timestamp);
                }
                switch (type) {
                    case START_TRACK: 
                    case END_TRACK: 
                    case SHUTDOWN: {
                        child.process(toPass, type, newDepth, timestamp);
                        continue block16;
                    }
                    case SIMPLE: {
                        continue block16;
                    }
                }
                throw new IllegalStateException("MessageType was non-exhaustive: " + (Object)((Object)type));
            }
        }

        private StringBuilder toStringHelper(StringBuilder b, int depth) {
            for (int i = 0; i < depth; ++i) {
                b.append("  ");
            }
            b.append(this.head == null ? "ROOT" : this.head).append("\n");
            for (RecordHandlerTree child : this.children) {
                child.toStringHelper(b, depth + 1);
            }
            return b;
        }

        public String toString() {
            return this.toStringHelper(new StringBuilder(), 0).toString();
        }
    }

    private static enum MessageType {
        SIMPLE,
        START_TRACK,
        SHUTDOWN,
        END_TRACK;

    }
}

