/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.fusesource.lmdbjni.ByteString;
import org.fusesource.lmdbjni.Constants;
import org.fusesource.lmdbjni.Cursor;
import org.fusesource.lmdbjni.DirectBuffer;
import org.fusesource.lmdbjni.GetOp;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.LMDBException;
import org.fusesource.lmdbjni.SeekOp;
import org.fusesource.lmdbjni.Util;

public class BufferCursor
implements AutoCloseable {
    private final Cursor cursor;
    private final ByteBuffer keyByteBuffer;
    private ByteBuffer valueByteBuffer;
    private final boolean isReadOnly;
    private DirectBuffer key;
    private DirectBuffer value;
    private boolean keyDatbaseMemoryLocation = false;
    private boolean valDatbaseMemoryLocation = false;
    private int keyWriteIndex = 0;
    private int valWriteIndex = 0;
    private boolean validPosition = false;

    BufferCursor(Cursor cursor, DirectBuffer key, DirectBuffer value) {
        this.cursor = cursor;
        this.isReadOnly = cursor.isReadOnly();
        if (key.byteBuffer() == null) {
            throw new IllegalArgumentException("No ByteBuffer available for key.");
        }
        if (!key.byteBuffer().isDirect()) {
            throw new IllegalArgumentException("ByteBuffer for key must be direct.");
        }
        this.keyByteBuffer = key.byteBuffer();
        this.key = key;
        if (value.byteBuffer() == null) {
            throw new IllegalArgumentException("No ByteBuffer available for value.");
        }
        if (!value.byteBuffer().isDirect()) {
            throw new IllegalArgumentException("ByteBuffer for value must be direct.");
        }
        this.value = value;
        this.valueByteBuffer = value.byteBuffer();
    }

    BufferCursor(Cursor cursor, int maxValueSize) {
        this(cursor, new DirectBuffer(), new DirectBuffer(ByteBuffer.allocateDirect(maxValueSize)));
    }

    public int keyWriteIndex() {
        return this.keyWriteIndex;
    }

    public int valWriteIndex() {
        return this.valWriteIndex;
    }

    public boolean seekKey() {
        if (this.keyWriteIndex != 0) {
            this.key.wrap(this.key.addressOffset(), this.keyWriteIndex);
        }
        int rc = this.cursor.seekPosition(this.key, this.value, SeekOp.KEY);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean seekRange() {
        if (this.keyWriteIndex != 0) {
            this.key.wrap(this.key.addressOffset(), this.keyWriteIndex);
        }
        int rc = this.cursor.seekPosition(this.key, this.value, SeekOp.RANGE);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean seekRange(byte[] key) {
        this.keyWriteBytes(key);
        return this.seekRange();
    }

    @Deprecated
    public boolean seek(byte[] key) {
        return this.seekRange(key);
    }

    public boolean first() {
        int rc = this.cursor.position(this.key, this.value, GetOp.FIRST);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean firstDup() {
        int rc = this.cursor.position(this.key, this.value, GetOp.FIRST_DUP);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean last() {
        int rc = this.cursor.position(this.key, this.value, GetOp.LAST);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean lastDup() {
        int rc = this.cursor.position(this.key, this.value, GetOp.LAST_DUP);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean next() {
        int rc = this.cursor.position(this.key, this.value, GetOp.NEXT);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean nextDup() {
        int rc = this.cursor.position(this.key, this.value, GetOp.NEXT_DUP);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean prev() {
        int rc = this.cursor.position(this.key, this.value, GetOp.PREV);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public boolean prevDup() {
        int rc = this.cursor.position(this.key, this.value, GetOp.PREV_DUP);
        this.setDatabaseMemoryLocation(rc);
        return rc == 0;
    }

    public void delete() {
        this.cursor.delete();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    public boolean put() {
        DirectBuffer k = this.keyWriteIndex != 0 ? new DirectBuffer(this.key.addressOffset(), this.keyWriteIndex) : this.key;
        DirectBuffer v = this.valWriteIndex != 0 ? new DirectBuffer(this.value.addressOffset(), this.valWriteIndex) : this.value;
        this.keyWriteIndex = 0;
        this.valWriteIndex = 0;
        int rc = this.cursor.put(k, v, Constants.NOOVERWRITE);
        if (rc == 0) {
            return true;
        }
        if (rc == LMDBException.KEYEXIST) {
            return false;
        }
        String msg = Util.string(JNI.mdb_strerror(rc));
        throw new LMDBException(msg, rc);
    }

    public boolean overwrite() {
        DirectBuffer k = this.keyWriteIndex != 0 ? new DirectBuffer(this.key.addressOffset(), this.keyWriteIndex) : this.key;
        DirectBuffer v = this.valWriteIndex != 0 ? new DirectBuffer(this.value.addressOffset(), this.valWriteIndex) : this.value;
        this.keyWriteIndex = 0;
        this.valWriteIndex = 0;
        int rc = this.cursor.put(k, v, 0);
        if (rc == 0) {
            return true;
        }
        if (rc == LMDBException.KEYEXIST) {
            return false;
        }
        String msg = Util.string(JNI.mdb_strerror(rc));
        throw new LMDBException(msg, rc);
    }

    public void append() {
        DirectBuffer k = this.keyWriteIndex != 0 ? new DirectBuffer(this.key.addressOffset(), this.keyWriteIndex) : this.key;
        DirectBuffer v = this.valWriteIndex != 0 ? new DirectBuffer(this.value.addressOffset(), this.valWriteIndex) : this.value;
        this.keyWriteIndex = 0;
        this.valWriteIndex = 0;
        int rc = this.cursor.put(k, v, Constants.APPEND);
        if (rc != 0) {
            String msg = Util.string(JNI.mdb_strerror(rc));
            throw new LMDBException(msg, rc);
        }
    }

    public BufferCursor keyWriteBoolean(boolean data) {
        this.setSafeKeyMemoryLocation();
        this.key.putByte(this.keyWriteIndex, data ? (byte)1 : 0);
        ++this.keyWriteIndex;
        return this;
    }

    public BufferCursor keyWriteByte(int data) {
        this.setSafeKeyMemoryLocation();
        this.key.putByte(this.keyWriteIndex, (byte)data);
        ++this.keyWriteIndex;
        return this;
    }

    public BufferCursor keyWriteShort(short data) {
        this.setSafeKeyMemoryLocation();
        this.key.putShort(this.keyWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.keyWriteIndex += 2;
        return this;
    }

    public BufferCursor keyWriteInt(int data) {
        this.setSafeKeyMemoryLocation();
        this.key.putInt(this.keyWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.keyWriteIndex += 4;
        return this;
    }

    public BufferCursor keyWriteLong(long data) {
        this.setSafeKeyMemoryLocation();
        this.key.putLong(this.keyWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.keyWriteIndex += 8;
        return this;
    }

    public BufferCursor keyWriteFloat(float data) {
        this.setSafeValMemoryLocation();
        this.key.putFloat(this.keyWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.keyWriteIndex += 4;
        return this;
    }

    public BufferCursor keyWriteDouble(double data) {
        this.setSafeValMemoryLocation();
        this.key.putDouble(this.keyWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.keyWriteIndex += 8;
        return this;
    }

    public BufferCursor keyWriteUtf8(ByteString data) {
        this.setSafeKeyMemoryLocation();
        this.key.putString(this.keyWriteIndex, data);
        this.keyWriteIndex += data.size() + 1;
        return this;
    }

    public BufferCursor keyWriteUtf8(String data) {
        this.setSafeKeyMemoryLocation();
        ByteString bytes = new ByteString(data);
        this.key.putString(this.keyWriteIndex, bytes);
        this.keyWriteIndex += bytes.size() + 1;
        return this;
    }

    public BufferCursor keyWriteBytes(byte[] data) {
        this.setSafeKeyMemoryLocation();
        this.key.putBytes(this.keyWriteIndex, data);
        this.keyWriteIndex += data.length;
        return this;
    }

    public BufferCursor keyWriteBytes(byte[] data, int offset, int length) {
        this.setSafeKeyMemoryLocation();
        this.key.putBytes(this.keyWriteIndex, data, offset, length);
        this.keyWriteIndex += length;
        return this;
    }

    public BufferCursor keyWrite(DirectBuffer buffer, int capacity) {
        this.setSafeKeyMemoryLocation();
        this.key.putBytes(this.keyWriteIndex, buffer, 0, capacity);
        this.keyWriteIndex += capacity;
        return this;
    }

    public BufferCursor keyWrite(DirectBuffer buffer) {
        this.keyWrite(buffer, buffer.capacity());
        return this;
    }

    public int keyLength() {
        if (this.validPosition) {
            return this.key.capacity();
        }
        return 0;
    }

    public boolean keyBoolean(int pos) {
        this.checkForValidPosition();
        return this.key.getByte(pos) == 1;
    }

    public byte keyByte(int pos) {
        this.checkForValidPosition();
        return this.key.getByte(pos);
    }

    public short keyShort(int pos) {
        this.checkForValidPosition();
        return this.key.getShort(pos, ByteOrder.BIG_ENDIAN);
    }

    public int keyInt(int pos) {
        this.checkForValidPosition();
        return this.key.getInt(pos, ByteOrder.BIG_ENDIAN);
    }

    public long keyLong(int pos) {
        this.checkForValidPosition();
        return this.key.getLong(pos, ByteOrder.BIG_ENDIAN);
    }

    public float keyFloat(int pos) {
        this.checkForValidPosition();
        return this.key.getFloat(pos, ByteOrder.BIG_ENDIAN);
    }

    public double keyDouble(int pos) {
        this.checkForValidPosition();
        return this.key.getDouble(pos, ByteOrder.BIG_ENDIAN);
    }

    public ByteString keyUtf8(int pos) {
        this.checkForValidPosition();
        return this.key.getString(pos);
    }

    public byte[] keyBytes(int pos, int length) {
        this.checkForValidPosition();
        byte[] k = new byte[length];
        this.key.getBytes(pos, k);
        return k;
    }

    public byte[] keyBytes() {
        this.checkForValidPosition();
        byte[] k = new byte[this.key.capacity()];
        this.key.getBytes(0, k);
        return k;
    }

    public DirectBuffer keyBuffer() {
        return this.key;
    }

    public DirectBuffer keyDirectBuffer() {
        this.checkForValidPosition();
        return this.key;
    }

    public BufferCursor valWriteBoolean(boolean data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(1);
        this.value.putByte(this.valWriteIndex, data ? (byte)1 : 0);
        ++this.valWriteIndex;
        return this;
    }

    public BufferCursor valWriteByte(int data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(1);
        this.value.putByte(this.valWriteIndex, (byte)data);
        ++this.valWriteIndex;
        return this;
    }

    public BufferCursor valWriteShort(short data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(4);
        this.value.putShort(this.valWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.valWriteIndex += 2;
        return this;
    }

    public BufferCursor valWriteInt(int data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(4);
        this.value.putInt(this.valWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.valWriteIndex += 4;
        return this;
    }

    public BufferCursor valWriteLong(long data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(8);
        this.value.putLong(this.valWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.valWriteIndex += 8;
        return this;
    }

    public BufferCursor valWriteFloat(float data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(4);
        this.value.putFloat(this.valWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.valWriteIndex += 4;
        return this;
    }

    public BufferCursor valWriteDouble(double data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(8);
        this.value.putDouble(this.valWriteIndex, data, ByteOrder.BIG_ENDIAN);
        this.valWriteIndex += 8;
        return this;
    }

    public BufferCursor valWriteUtf8(String data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        ByteString bytes = new ByteString(data);
        this.ensureValueWritableBytes(bytes.size() + 1);
        this.value.putString(this.valWriteIndex, bytes);
        this.valWriteIndex += bytes.size() + 1;
        return this;
    }

    public BufferCursor valWriteUtf8(ByteString data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(data.size() + 1);
        this.value.putString(this.valWriteIndex, data);
        this.valWriteIndex += data.size() + 1;
        return this;
    }

    public BufferCursor valWriteBytes(byte[] data) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(data.length);
        this.value.putBytes(this.valWriteIndex, data);
        this.valWriteIndex += data.length;
        return this;
    }

    public BufferCursor valWriteBytes(byte[] data, int offset, int length) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(length);
        this.value.putBytes(this.valWriteIndex, data, offset, length);
        this.valWriteIndex += length;
        return this;
    }

    public BufferCursor valWrite(DirectBuffer buffer, int srcIndex, int length) {
        if (this.isReadOnly) {
            throw new LMDBException("Read only transaction", 13);
        }
        this.setSafeValMemoryLocation();
        this.ensureValueWritableBytes(length);
        this.value.putBytes(this.valWriteIndex, buffer, srcIndex, length);
        this.valWriteIndex += length;
        return this;
    }

    public BufferCursor valWrite(DirectBuffer buffer, int length) {
        return this.valWrite(buffer, 0, length);
    }

    public BufferCursor valWrite(DirectBuffer buffer) {
        this.valWrite(buffer, 0, buffer.capacity());
        return this;
    }

    public int valLength() {
        if (this.validPosition) {
            return this.value.capacity();
        }
        return 0;
    }

    public boolean valBoolean(int pos) {
        this.checkForValidPosition();
        return this.value.getByte(pos) == 1;
    }

    public byte valByte(int pos) {
        this.checkForValidPosition();
        return this.value.getByte(pos);
    }

    private void checkForValidPosition() {
        if (!this.validPosition) {
            throw new IndexOutOfBoundsException("Cursor is in an unpositioned state");
        }
    }

    public short valShort(int pos) {
        this.checkForValidPosition();
        return this.value.getShort(pos, ByteOrder.BIG_ENDIAN);
    }

    public int valInt(int pos) {
        this.checkForValidPosition();
        return this.value.getInt(pos, ByteOrder.BIG_ENDIAN);
    }

    public long valLong(int pos) {
        this.checkForValidPosition();
        return this.value.getLong(pos, ByteOrder.BIG_ENDIAN);
    }

    public byte[] valBytes(int pos, int length) {
        this.checkForValidPosition();
        byte[] v = new byte[length];
        this.value.getBytes(pos, v);
        return v;
    }

    public byte[] valBytes() {
        this.checkForValidPosition();
        byte[] v = new byte[this.value.capacity()];
        this.value.getBytes(0, v);
        return v;
    }

    public DirectBuffer valBuffer() {
        return this.value;
    }

    public float valFloat(int pos) {
        this.checkForValidPosition();
        return this.value.getFloat(pos, ByteOrder.BIG_ENDIAN);
    }

    public double valDouble(int pos) {
        this.checkForValidPosition();
        return this.value.getDouble(pos, ByteOrder.BIG_ENDIAN);
    }

    public ByteString valUtf8(int pos) {
        this.checkForValidPosition();
        return this.value.getString(pos);
    }

    public DirectBuffer valDirectBuffer() {
        this.checkForValidPosition();
        return this.value;
    }

    public void setWriteMode() {
        this.setSafeKeyMemoryLocation();
        this.setSafeValMemoryLocation();
    }

    private void setSafeKeyMemoryLocation() {
        if (this.keyDatbaseMemoryLocation) {
            this.key.wrap(this.keyByteBuffer);
            this.keyDatbaseMemoryLocation = false;
        }
    }

    private void setSafeValMemoryLocation() {
        if (this.valDatbaseMemoryLocation) {
            this.value.wrap(this.valueByteBuffer);
            this.valDatbaseMemoryLocation = false;
        }
    }

    private void setDatabaseMemoryLocation(int rc) {
        this.validPosition = rc == 0;
        this.valDatbaseMemoryLocation = true;
        this.keyDatbaseMemoryLocation = true;
        this.keyWriteIndex = 0;
        this.valWriteIndex = 0;
    }

    private void ensureValueWritableBytes(int minWritableBytes) {
        if (minWritableBytes <= this.valueByteBuffer.capacity() - this.valWriteIndex) {
            return;
        }
        int newCapacity = this.valueByteBuffer.capacity() == 0 ? 1 : this.valueByteBuffer.capacity();
        int minNewCapacity = this.valWriteIndex + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if ((newCapacity <<= 1) != 0) continue;
            throw new IllegalStateException("Maximum size of 2gb exceeded");
        }
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity).order(this.valueByteBuffer.order());
        this.valueByteBuffer.position(0);
        newBuffer.put(this.valueByteBuffer);
        this.valueByteBuffer = newBuffer;
        this.value.wrap(this.valueByteBuffer);
    }
}

