/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityRuntimeException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.XPathAPI;
import com.sun.org.apache.xml.internal.security.utils.XPathFactory;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Element element, String string, boolean bl) throws TransformationException {
        try {
            Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "XPath", 0);
            if (element2 == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node = element2.getFirstChild();
            if (node == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            String string2 = XMLUtils.getStrFromNode(node);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircumvent(string2));
            XPathFactory xPathFactory = this.getXPathFactory();
            XPathAPI xPathAPI = xPathFactory.newXPathAPI();
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element2, node, string2, xPathAPI));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (DOMException dOMException) {
            throw new TransformationException(dOMException);
        }
    }

    protected XPathFactory getXPathFactory() {
        return XPathFactory.newInstance();
    }

    private boolean needsCircumvent(String string) {
        return string.indexOf("namespace") != -1 || string.indexOf("name()") != -1;
    }

    private static class XPathNodeFilter
    implements NodeFilter {
        private final XPathAPI xPathAPI;
        private final Node xpathnode;
        private final Element xpathElement;
        private final String str;

        XPathNodeFilter(Element element, Node node, String string, XPathAPI xPathAPI) {
            this.xpathnode = node;
            this.str = string;
            this.xpathElement = element;
            this.xPathAPI = xPathAPI;
        }

        @Override
        public int isNodeInclude(Node node) {
            try {
                boolean bl = this.xPathAPI.evaluate(node, this.xpathnode, this.str, this.xpathElement);
                if (bl) {
                    return 1;
                }
                return 0;
            }
            catch (TransformerException transformerException) {
                Object[] objectArray = new Object[]{node};
                throw new XMLSecurityRuntimeException("signature.Transform.node", objectArray, transformerException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{node, node.getNodeType()};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", objectArray, exception);
            }
        }

        @Override
        public int isNodeIncludeDO(Node node, int n) {
            return this.isNodeInclude(node);
        }
    }
}

