/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.hcoref.CorefCoreAnnotations;
import edu.stanford.nlp.hcoref.CorefSystem;
import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.scoref.StatisticalCorefSystem;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CorefAnnotator
extends TextAnnotationCreator
implements Annotator {
    private static final boolean VERBOSE = false;
    private final CorefSystem hcorefSystem;
    private final StatisticalCorefSystem scorefSystem;
    private final boolean OLD_FORMAT;
    private String COREF_MODE;
    private String HYBRID_MODE = "hybrid";
    private String STATISTICAL_MODE = "statistical";
    private static final Map<Pair<Dictionaries.MentionType, Dictionaries.MentionType>, Double> COREF_THRESHOLDS = new HashMap<Pair<Dictionaries.MentionType, Dictionaries.MentionType>, Double>();

    public CorefAnnotator(Properties props) {
        try {
            this.COREF_MODE = props.getProperty("coref.mode", this.STATISTICAL_MODE);
            if (this.COREF_MODE.equals(this.HYBRID_MODE)) {
                this.hcorefSystem = new CorefSystem(props);
                this.scorefSystem = null;
            } else if (this.COREF_MODE.equals(this.STATISTICAL_MODE)) {
                this.scorefSystem = StatisticalCorefSystem.fromProps(props);
                this.hcorefSystem = null;
            } else {
                this.scorefSystem = null;
                this.hcorefSystem = null;
            }
            this.OLD_FORMAT = Boolean.parseBoolean(props.getProperty("oldCorefFormat", "false"));
        }
        catch (Exception e) {
            System.err.println("ERROR: cannot create CorefAnnotator!");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        block8: {
            try {
                if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                    System.err.println("ERROR: this coreference resolution system requires SentencesAnnotation!");
                    return;
                }
                if (CorefAnnotator.hasSpeakerAnnotations(annotation)) {
                    annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
                }
                if (this.COREF_MODE.equals(this.HYBRID_MODE)) {
                    Document corefDoc = this.hcorefSystem.docMaker.makeDocument(annotation);
                    Map<Integer, CorefChain> result = this.hcorefSystem.coref(corefDoc);
                    annotation.set(CorefCoreAnnotations.CorefChainAnnotation.class, result);
                    if (this.OLD_FORMAT) {
                        CorefAnnotator.annotateOldFormat(result, corefDoc);
                    }
                    break block8;
                }
                if (this.COREF_MODE.equals(this.STATISTICAL_MODE)) {
                    this.scorefSystem.annotate(annotation);
                    break block8;
                }
                System.err.println("ERROR: invalid selection for coreference mode!");
                throw new RuntimeException();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<Pair<IntTuple, IntTuple>> getLinks(Map<Integer, CorefChain> result) {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        CorefChain.CorefMentionComparator comparator = new CorefChain.CorefMentionComparator();
        for (CorefChain c : result.values()) {
            List<CorefChain.CorefMention> s = c.getMentionsInTextualOrder();
            for (CorefChain.CorefMention m1 : s) {
                for (CorefChain.CorefMention m2 : s) {
                    if (comparator.compare(m1, m2) != 1) continue;
                    links.add(new Pair<IntTuple, IntTuple>(m1.position, m2.position));
                }
            }
        }
        return links;
    }

    private static void annotateOldFormat(Map<Integer, CorefChain> result, Document corefDoc) {
        List<Pair<IntTuple, IntTuple>> links = CorefAnnotator.getLinks(result);
        Annotation annotation = corefDoc.annotation;
        ArrayList<Pair<IntTuple, IntTuple>> graph = new ArrayList<Pair<IntTuple, IntTuple>>();
        for (Pair<IntTuple, IntTuple> link : links) {
            int srcSent = ((IntTuple)link.first).get(0);
            int srcTok = corefDoc.getOrderedMentions().get((int)(srcSent - 1)).get((int)(((IntTuple)link.first).get((int)1) - 1)).headIndex + 1;
            int dstSent = ((IntTuple)link.second).get(0);
            int dstTok = corefDoc.getOrderedMentions().get((int)(dstSent - 1)).get((int)(((IntTuple)link.second).get((int)1) - 1)).headIndex + 1;
            IntTuple dst = new IntTuple(2);
            dst.set(0, dstSent);
            dst.set(1, dstTok);
            IntTuple src = new IntTuple(2);
            src.set(0, srcSent);
            src.set(1, srcTok);
            graph.add(new Pair<IntTuple, IntTuple>(src, dst));
        }
        annotation.set(CorefCoreAnnotations.CorefGraphAnnotation.class, graph);
        for (CorefChain corefChain : result.values()) {
            if (corefChain.getMentionsInTextualOrder().size() < 2) continue;
            Set<CoreLabel> coreferentTokens = Generics.newHashSet();
            for (CorefChain.CorefMention mention : corefChain.getMentionsInTextualOrder()) {
                CoreMap sentence = (CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(mention.sentNum - 1);
                CoreLabel token = (CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(mention.headIndex - 1);
                coreferentTokens.add(token);
            }
            for (CoreLabel token : coreferentTokens) {
                token.set(CorefCoreAnnotations.CorefClusterAnnotation.class, coreferentTokens);
            }
        }
    }

    private static boolean hasSpeakerAnnotations(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel t : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Annotator.REQUIREMENTS.get("coref");
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(COREF_REQUIREMENT);
    }

    static {
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.PROPER, Dictionaries.MentionType.PROPER), 0.3);
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.PRONOMINAL, Dictionaries.MentionType.PRONOMINAL), 0.3);
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.PROPER, Dictionaries.MentionType.PRONOMINAL), 0.1);
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.PRONOMINAL, Dictionaries.MentionType.PROPER), 1.0);
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.NOMINAL, Dictionaries.MentionType.PROPER), 1.0);
        COREF_THRESHOLDS.put(new Pair<Dictionaries.MentionType, Dictionaries.MentionType>(Dictionaries.MentionType.PROPER, Dictionaries.MentionType.NOMINAL), 1.0);
    }
}

