/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.AnnotationLookup;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Env
implements Serializable {
    Map<String, Object> variables = new HashMap<String, Object>();

    public Env() {
    }

    public Env(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void bind(String name, Object obj) {
        if (obj != null) {
            this.variables.put(name, obj);
        } else {
            this.variables.remove(name);
        }
    }

    public void unbind(String name) {
        this.bind(name, null);
    }

    public Object get(String name) {
        return this.variables.get(name);
    }

    public static Class lookupAnnotationKey(Env env, String name) {
        Object obj;
        if (env != null && (obj = env.get(name)) != null && obj instanceof Class) {
            return (Class)obj;
        }
        AnnotationLookup.KeyLookup lookup = AnnotationLookup.getCoreKey(name);
        if (lookup != null) {
            return lookup.coreKey;
        }
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

