/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Timing;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Distsim
implements Serializable {
    private static final Map<String, Distsim> lexiconMap = Generics.newHashMap();
    private final Map<String, String> lexicon;
    private final String unk;
    private boolean mapdigits;
    private static final Pattern digits = Pattern.compile("[0-9]");
    private static final long serialVersionUID = 2L;

    public Distsim(String path) {
        String[] pieces = path.split(";");
        String filename = pieces[0];
        for (int arg = 1; arg < pieces.length; ++arg) {
            if (!pieces[arg].equalsIgnoreCase("mapdigits")) {
                throw new IllegalArgumentException("Unknown argument " + pieces[arg]);
            }
            this.mapdigits = true;
        }
        this.lexicon = Generics.newHashMap();
        for (String word : ObjectBank.getLineIterator(new File(filename))) {
            String[] bits = word.split("\\s+");
            this.lexicon.put(bits[0].toLowerCase(), bits[1]);
        }
        this.unk = this.lexicon.containsKey("<unk>") ? this.lexicon.get("<unk>") : "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Distsim initLexicon(String path) {
        Map<String, Distsim> map = lexiconMap;
        synchronized (map) {
            Distsim lex = lexiconMap.get(path);
            if (lex == null) {
                Timing.startDoing("Loading distsim lexicon from " + path);
                lex = new Distsim(path);
                lexiconMap.put(path, lex);
                Timing.endDoing();
            }
            return lex;
        }
    }

    public String getMapping(String word) {
        Matcher matcher;
        String distSim = this.lexicon.get(word.toLowerCase());
        if (distSim == null && this.mapdigits && (matcher = digits.matcher(word)).find()) {
            distSim = this.lexicon.get(matcher.replaceAll("0"));
        }
        if (distSim == null) {
            distSim = this.unk;
        }
        return distSim;
    }
}

