/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.AbstractCoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyPrinter;
import edu.stanford.nlp.trees.DependencyReader;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.SimpleTree;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalPOSMapper;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class GrammaticalStructure
implements Serializable {
    private static final boolean PRINT_DEBUGGING = System.getProperty("GrammaticalStructure", null) != null;
    protected final List<TypedDependency> typedDependencies;
    protected final List<TypedDependency> allTypedDependencies;
    protected final Predicate<String> puncFilter;
    protected final Predicate<String> tagFilter;
    protected final TreeGraphNode root;
    private final Map<Integer, TreeGraphNode> indexMap = Generics.newHashMap();
    private static final long serialVersionUID = 2286294455343892678L;
    public static final String DEFAULT_PARSER_FILE = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    public static final int CoNLLX_WordField = 1;
    public static final int CoNLLX_POSField = 3;
    public static final int CoNLLX_GovField = 6;
    public static final int CoNLLX_RelnField = 7;
    public static final int CoNLLX_FieldCount = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, Lock relationsLock, TreeTransformer transformer, HeadFinder hf, Predicate<String> puncFilter, Predicate<String> tagFilter) {
        TreeGraphNode treeGraph = new TreeGraphNode(t, (TreeGraphNode)null);
        Trees.setLeafLabels(treeGraph, t.yield());
        Trees.setLeafTagsIfUnset(treeGraph);
        if (transformer != null) {
            Tree transformed = transformer.transformTree(treeGraph);
            if (!(transformed instanceof TreeGraphNode)) {
                throw new RuntimeException("Transformer did not change TreeGraphNode into another TreeGraphNode: " + transformer);
            }
            this.root = (TreeGraphNode)transformed;
        } else {
            this.root = treeGraph;
        }
        this.indexNodes(this.root);
        if (hf == null) {
            throw new AssertionError((Object)"Cannot use null HeadFinder");
        }
        this.root.percolateHeads(hf);
        if (this.root.value() == null) {
            this.root.setValue("ROOT");
        }
        this.puncFilter = puncFilter;
        this.tagFilter = tagFilter;
        NoPunctTypedDependencyFilter puncTypedDepFilter = new NoPunctTypedDependencyFilter(puncFilter, tagFilter);
        DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph = new DirectedMultiGraph<TreeGraphNode, GrammaticalRelation>();
        DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph = new DirectedMultiGraph<TreeGraphNode, GrammaticalRelation>();
        if (relationsLock != null) {
            relationsLock.lock();
        }
        try {
            GrammaticalStructure.analyzeNode(this.root, this.root, relations, hf, puncFilter, tagFilter, basicGraph, completeGraph);
        }
        finally {
            if (relationsLock != null) {
                relationsLock.unlock();
            }
        }
        GrammaticalStructure.attachStrandedNodes(this.root, this.root, false, puncFilter, tagFilter, basicGraph);
        this.typedDependencies = this.getDeps(puncTypedDepFilter, basicGraph);
        this.allTypedDependencies = Generics.newArrayList(this.typedDependencies);
        this.getExtraDeps(this.allTypedDependencies, puncTypedDepFilter, completeGraph);
    }

    private void indexNodes(TreeGraphNode tree) {
        this.indexNodes(tree, this.indexLeaves(tree, 1));
    }

    private int indexLeaves(TreeGraphNode tree, int startIndex) {
        if (tree.isLeaf()) {
            int oldIndex = tree.index();
            if (oldIndex >= 0) {
                startIndex = oldIndex;
            } else {
                tree.setIndex(startIndex);
            }
            this.addNodeToIndexMap(startIndex, tree);
            ++startIndex;
        } else {
            for (TreeGraphNode child : tree.children) {
                startIndex = this.indexLeaves(child, startIndex);
            }
        }
        return startIndex;
    }

    private int indexNodes(TreeGraphNode tree, int startIndex) {
        if (tree.index() < 0) {
            this.addNodeToIndexMap(startIndex, tree);
            tree.setIndex(startIndex++);
        }
        if (!tree.isLeaf()) {
            for (TreeGraphNode child : tree.children) {
                startIndex = this.indexNodes(child, startIndex);
            }
        }
        return startIndex;
    }

    private void addNodeToIndexMap(int index, TreeGraphNode node) {
        this.indexMap.put(index, node);
    }

    private TreeGraphNode getNodeByIndex(int index) {
        return this.indexMap.get(index);
    }

    public TreeGraphNode root() {
        return this.root;
    }

    private static void throwDepFormatException(String dep) {
        throw new RuntimeException(String.format("Dependencies should be for the format 'type(arg-idx, arg-idx)'. Could not parse '%s'", dep));
    }

    public static GrammaticalStructure fromStringReps(List<String> tokens, List<String> posTags, List<String> deps) {
        if (tokens.size() != posTags.size()) {
            throw new RuntimeException(String.format("tokens.size(): %d != pos.size(): %d%n", tokens.size(), posTags.size()));
        }
        ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokens.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokens.size());
        CoreLabel rootLabel = new CoreLabel();
        rootLabel.setValue("ROOT");
        ArrayList<IndexedWord> nodeWords = new ArrayList<IndexedWord>(tgPOSNodes.size() + 1);
        nodeWords.add(new IndexedWord(rootLabel));
        UniversalSemanticHeadFinder headFinder = new UniversalSemanticHeadFinder();
        Iterator<String> posIter = posTags.iterator();
        for (String wordString : tokens) {
            String posString = posIter.next();
            CoreLabel wordLabel = new CoreLabel();
            wordLabel.setWord(wordString);
            wordLabel.setValue(wordString);
            wordLabel.setTag(posString);
            TreeGraphNode word = new TreeGraphNode(wordLabel);
            CoreLabel tagLabel = new CoreLabel();
            tagLabel.setValue(posString);
            tagLabel.setWord(posString);
            TreeGraphNode pos = new TreeGraphNode(tagLabel);
            tgWordNodes.add(word);
            tgPOSNodes.add(pos);
            Tree[] childArr = new TreeGraphNode[]{word};
            pos.setChildren(childArr);
            word.setParent(pos);
            pos.percolateHeads(headFinder);
            nodeWords.add(new IndexedWord(wordLabel));
        }
        TreeGraphNode root = new TreeGraphNode(rootLabel);
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        root.setIndex(0);
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(deps.size());
        for (String depString : deps) {
            int childDash;
            String args;
            int argSep;
            int firstBracket = depString.indexOf(40);
            if (firstBracket == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String type = depString.substring(0, firstBracket);
            if (depString.charAt(depString.length() - 1) != ')') {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((argSep = (args = depString.substring(firstBracket + 1, depString.length() - 1)).indexOf(", ")) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String parentArg = args.substring(0, argSep);
            String childArg = args.substring(argSep + 2);
            int parentDash = parentArg.lastIndexOf(45);
            if (parentDash == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((childDash = childArg.lastIndexOf(45)) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            int parentIdx = Integer.parseInt(parentArg.substring(parentDash + 1).replace("'", ""));
            int childIdx = Integer.parseInt(childArg.substring(childDash + 1).replace("'", ""));
            GrammaticalRelation grel = new GrammaticalRelation(Language.Any, type, null, GrammaticalRelation.DEPENDENT);
            TypedDependency tdep = new TypedDependency(grel, (IndexedWord)nodeWords.get(parentIdx), (IndexedWord)nodeWords.get(childIdx));
            tdeps.add(tdep);
        }
        return new GrammaticalStructure(tdeps, root){
            private static final long serialVersionUID = 1L;
        };
    }

    public GrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        this.root = root;
        this.indexNodes(this.root);
        this.puncFilter = Filters.acceptFilter();
        this.tagFilter = Filters.acceptFilter();
        this.typedDependencies = new ArrayList<TypedDependency>(projectiveDependencies);
        this.allTypedDependencies = this.typedDependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.root.toPrettyString(0).substring(1));
        sb.append("Typed Dependencies:\n");
        sb.append(this.typedDependencies);
        return sb.toString();
    }

    private static void attachStrandedNodes(TreeGraphNode t, TreeGraphNode root, boolean attach, Predicate<String> puncFilter, Predicate<String> tagFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph) {
        TreeGraphNode parent;
        if (t.isLeaf()) {
            return;
        }
        if (attach && puncFilter.test(t.headWordNode().label().value()) && tagFilter.test(t.headWordNode().label().tag()) && !basicGraph.isEdge(parent = t.parent().highestNodeWithSameHead(), t) && basicGraph.getShortestPath(root, t, false) == null) {
            basicGraph.add(parent, t, GrammaticalRelation.DEPENDENT);
        }
        for (TreeGraphNode kid : t.children()) {
            GrammaticalStructure.attachStrandedNodes(kid, root, kid.headWordNode() != t.headWordNode(), puncFilter, tagFilter, basicGraph);
        }
    }

    private static void analyzeNode(TreeGraphNode t, TreeGraphNode root, Collection<GrammaticalRelation> relations, HeadFinder hf, Predicate<String> puncFilter, Predicate<String> tagFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph) {
        if (t.isPhrasal()) {
            TreeGraphNode tHigh = t.highestNodeWithSameHead();
            for (GrammaticalRelation egr : relations) {
                if (!egr.isApplicable(t)) continue;
                for (TreeGraphNode u : egr.getRelatedNodes(t, root, hf)) {
                    TreeGraphNode uHigh = u.highestNodeWithSameHead();
                    if (uHigh == tHigh || !puncFilter.test(uHigh.headWordNode().label().value()) || !tagFilter.test(uHigh.headWordNode().label().tag())) continue;
                    completeGraph.add(tHigh, uHigh, egr);
                    Set<TreeGraphNode> parents = basicGraph.getParents(uHigh);
                    if (parents != null && parents.size() != 0 && !parents.contains(tHigh) || basicGraph.getShortestPath(uHigh, tHigh, true) != null) continue;
                    basicGraph.add(tHigh, uHigh, egr);
                }
            }
            for (TreeGraphNode kid : t.children()) {
                GrammaticalStructure.analyzeNode(kid, root, relations, hf, puncFilter, tagFilter, basicGraph, completeGraph);
            }
        }
    }

    private void getExtraDeps(List<TypedDependency> deps, Predicate<TypedDependency> puncTypedDepFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph) {
        this.getExtras(deps);
        this.getTreeDeps(deps, completeGraph, puncTypedDepFilter, this.extraTreeDepFilter());
        Collections.sort(deps);
    }

    private List<TypedDependency> getDeps(Predicate<TypedDependency> puncTypedDepFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph) {
        List<Tree> leaves;
        ArrayList<TypedDependency> basicDep = Generics.newArrayList();
        for (TreeGraphNode gov : basicGraph.getAllVertices()) {
            for (TreeGraphNode dep : basicGraph.getChildren(gov)) {
                GrammaticalRelation reln = GrammaticalStructure.getGrammaticalRelationCommonAncestor(gov.headWordNode().label(), gov.label(), dep.headWordNode().label(), dep.label(), basicGraph.getEdges(gov, dep));
                basicDep.add(new TypedDependency(reln, new IndexedWord(gov.headWordNode().label()), new IndexedWord(dep.headWordNode().label())));
            }
        }
        TreeGraphNode dependencyRoot = new TreeGraphNode(new Word("ROOT"));
        dependencyRoot.setIndex(0);
        TreeGraphNode rootDep = this.root().headWordNode();
        if (rootDep == null && (leaves = Trees.leaves(this.root())).size() > 0) {
            Tree leaf = leaves.get(0);
            if (!(leaf instanceof TreeGraphNode)) {
                throw new AssertionError((Object)"Leaves should be TreeGraphNodes");
            }
            rootDep = (TreeGraphNode)leaf;
            if (rootDep.headWordNode() != null) {
                rootDep = rootDep.headWordNode();
            }
        }
        if (rootDep != null) {
            TypedDependency rootTypedDep = new TypedDependency(GrammaticalRelation.ROOT, new IndexedWord(dependencyRoot.label()), new IndexedWord(rootDep.label()));
            if (puncTypedDepFilter.test(rootTypedDep)) {
                basicDep.add(rootTypedDep);
            } else {
                IndexedWord root = rootTypedDep.dep();
                IndexedWord newRoot = null;
                Collections.sort(basicDep);
                for (TypedDependency td : basicDep) {
                    if (!td.gov().equals(root)) continue;
                    if (newRoot != null) {
                        td.setGov(newRoot);
                        continue;
                    }
                    td.setGov(td.gov());
                    td.setReln(GrammaticalRelation.ROOT);
                    newRoot = td.dep();
                }
            }
        }
        this.postProcessDependencies(basicDep);
        Collections.sort(basicDep);
        return basicDep;
    }

    protected Predicate<TypedDependency> extraTreeDepFilter() {
        return Filters.acceptFilter();
    }

    protected void postProcessDependencies(List<TypedDependency> basicDep) {
    }

    protected void getExtras(List<TypedDependency> basicDep) {
    }

    protected void getTreeDeps(List<TypedDependency> deps, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph, Predicate<TypedDependency> puncTypedDepFilter, Predicate<TypedDependency> extraTreeDepFilter) {
        for (TreeGraphNode gov : completeGraph.getAllVertices()) {
            for (TreeGraphNode dep : completeGraph.getChildren(gov)) {
                for (GrammaticalRelation rel : GrammaticalStructure.removeGrammaticalRelationAncestors(completeGraph.getEdges(gov, dep))) {
                    TypedDependency newDep = new TypedDependency(rel, new IndexedWord(gov.headWordNode().label()), new IndexedWord(dep.headWordNode().label()));
                    if (deps.contains(newDep) || !puncTypedDepFilter.test(newDep) || !extraTreeDepFilter.test(newDep)) continue;
                    newDep.setExtra();
                    deps.add(newDep);
                }
            }
        }
    }

    public GrammaticalRelation getGrammaticalRelation(int govIndex, int depIndex) {
        TreeGraphNode gov = this.getNodeByIndex(govIndex);
        TreeGraphNode dep = this.getNodeByIndex(depIndex);
        return this.getGrammaticalRelation(new IndexedWord(gov.label()), new IndexedWord(dep.label()));
    }

    public GrammaticalRelation getGrammaticalRelation(IndexedWord gov, IndexedWord dep) {
        ArrayList<GrammaticalRelation> labels = Generics.newArrayList();
        for (TypedDependency dependency : this.typedDependencies(Extras.MAXIMAL)) {
            if (!dependency.gov().equals(gov) || !dependency.dep().equals(dep)) continue;
            labels.add(dependency.reln());
        }
        return GrammaticalStructure.getGrammaticalRelationCommonAncestor(gov, gov, dep, dep, labels);
    }

    private static GrammaticalRelation getGrammaticalRelationCommonAncestor(AbstractCoreLabel gov, AbstractCoreLabel govH, AbstractCoreLabel dep, AbstractCoreLabel depH, List<GrammaticalRelation> labels) {
        List<GrammaticalRelation> sortedLabels;
        GrammaticalRelation reln = GrammaticalRelation.DEPENDENT;
        if (labels.size() <= 1) {
            sortedLabels = labels;
        } else {
            sortedLabels = new ArrayList<GrammaticalRelation>(labels);
            Collections.sort(sortedLabels, new NameComparator());
        }
        for (GrammaticalRelation reln2 : sortedLabels) {
            if (reln.isAncestor(reln2)) {
                reln = reln2;
                continue;
            }
            if (!PRINT_DEBUGGING || reln2.isAncestor(reln)) continue;
            System.err.println("@@@\t" + reln + "\t" + reln2 + "\t" + (String)govH.get(CoreAnnotations.ValueAnnotation.class) + "\t" + (String)depH.get(CoreAnnotations.ValueAnnotation.class));
        }
        if (PRINT_DEBUGGING && reln.equals(GrammaticalRelation.DEPENDENT)) {
            String topCat = (String)govH.get(CoreAnnotations.ValueAnnotation.class);
            String topTag = gov.tag();
            String topWord = gov.value();
            String botCat = (String)depH.get(CoreAnnotations.ValueAnnotation.class);
            String botTag = dep.tag();
            String botWord = dep.value();
            System.err.println("### dep\t" + topCat + "\t" + topTag + "\t" + topWord + "\t" + botCat + "\t" + botTag + "\t" + botWord + "\t");
        }
        return reln;
    }

    private static List<GrammaticalRelation> removeGrammaticalRelationAncestors(List<GrammaticalRelation> original) {
        ArrayList<GrammaticalRelation> filtered = Generics.newArrayList();
        for (GrammaticalRelation reln : original) {
            boolean descendantFound = false;
            for (int index = 0; index < filtered.size(); ++index) {
                GrammaticalRelation gr = (GrammaticalRelation)filtered.get(index);
                if (gr.isAncestor(reln)) {
                    filtered.remove(index);
                    --index;
                    continue;
                }
                if (!reln.isAncestor(gr)) continue;
                descendantFound = true;
            }
            if (descendantFound) continue;
            filtered.add(reln);
        }
        return filtered;
    }

    public Collection<TypedDependency> typedDependencies() {
        return this.typedDependencies(Extras.NONE);
    }

    public Collection<TypedDependency> allTypedDependencies() {
        return this.typedDependencies(Extras.MAXIMAL);
    }

    public List<TypedDependency> typedDependencies(Extras includeExtras) {
        ArrayList<TypedDependency> deps;
        if (includeExtras != Extras.NONE) {
            deps = new ArrayList<TypedDependency>(this.allTypedDependencies.size());
            for (TypedDependency dep : this.allTypedDependencies) {
                deps.add(new TypedDependency(dep));
            }
        } else {
            deps = new ArrayList(this.typedDependencies.size());
            for (TypedDependency dep : this.typedDependencies) {
                deps.add(new TypedDependency(dep));
            }
        }
        this.correctDependencies(deps);
        return deps;
    }

    @Deprecated
    public List<TypedDependency> typedDependencies(boolean includeExtras) {
        return this.typedDependencies(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public Collection<TypedDependency> typedDependenciesCollapsed() {
        return this.typedDependenciesCollapsed(Extras.NONE);
    }

    public Collection<TypedDependency> typedDependenciesCollapsedTree() {
        List<TypedDependency> tdl = this.typedDependencies(Extras.NONE);
        this.collapseDependenciesTree(tdl);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCollapsed(Extras includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, false, includeExtras);
        return tdl;
    }

    @Deprecated
    public List<TypedDependency> typedDependenciesCollapsed(boolean includeExtras) {
        return this.typedDependenciesCollapsed(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public List<TypedDependency> typedDependenciesCCprocessed(Extras includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, true, includeExtras);
        return tdl;
    }

    @Deprecated
    public List<TypedDependency> typedDependenciesCCprocessed(boolean includeExtras) {
        return this.typedDependenciesCCprocessed(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public List<TypedDependency> typedDependenciesCCprocessed() {
        return this.typedDependenciesCCprocessed(Extras.MAXIMAL);
    }

    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, Extras includeExtras) {
    }

    protected void collapseDependenciesTree(List<TypedDependency> list) {
    }

    protected void correctDependencies(List<TypedDependency> list) {
    }

    public static boolean isConnected(Collection<TypedDependency> list) {
        return GrammaticalStructure.getRoots(list).size() <= 1;
    }

    public static Collection<TypedDependency> getRoots(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> roots = new ArrayList<TypedDependency>();
        Set<IndexedWord> deps = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            deps.add(typedDep.dep());
        }
        Set<IndexedWord> govs = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            IndexedWord gov = typedDep.gov();
            if (!deps.contains(gov) && !govs.contains(gov)) {
                roots.add(typedDep);
            }
            govs.add(gov);
        }
        return roots;
    }

    public static void printDependencies(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        System.out.println(GrammaticalStructure.dependenciesToString(gs, deps, tree, conllx, extraSep));
    }

    public static String dependenciesToCoNLLXString(GrammaticalStructure gs, CoreMap sentence) {
        return GrammaticalStructure.dependenciesToCoNLLXString(gs.typedDependencies(), sentence);
    }

    public static String dependenciesToCoNLLXString(Collection<TypedDependency> deps, CoreMap sentence) {
        StringBuilder bf = new StringBuilder();
        HashMap<Integer, TypedDependency> indexedDeps = new HashMap<Integer, TypedDependency>(deps.size());
        for (TypedDependency dep : deps) {
            indexedDeps.put(dep.dep().index(), dep);
        }
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens == null) {
            throw new RuntimeException("dependenciesToCoNLLXString: CoreMap does not have required TokensAnnotation.");
        }
        int idx = 1;
        for (CoreLabel token : tokens) {
            String word = token.value();
            String pos = token.tag();
            String cPos = token.get(CoreAnnotations.CoarseTagAnnotation.class) != null ? (String)token.get(CoreAnnotations.CoarseTagAnnotation.class) : pos;
            String lemma = token.lemma() != null ? token.lemma() : "_";
            Integer gov = indexedDeps.containsKey(idx) ? ((TypedDependency)indexedDeps.get(idx)).gov().index() : 0;
            String reln = indexedDeps.containsKey(idx) ? ((TypedDependency)indexedDeps.get(idx)).reln().toString() : "erased";
            String out2 = String.format("%d\t%s\t%s\t%s\t%s\t_\t%d\t%s\t_\t_\n", idx, word, lemma, cPos, pos, gov, reln);
            bf.append(out2);
            ++idx;
        }
        return bf.toString();
    }

    public static String dependenciesToString(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        StringBuilder bf;
        block7: {
            Map<Integer, Integer> indexToPos;
            block8: {
                block6: {
                    bf = new StringBuilder();
                    indexToPos = Generics.newHashMap();
                    indexToPos.put(0, 0);
                    List gsLeaves = gs.root.getLeaves();
                    for (int i = 0; i < gsLeaves.size(); ++i) {
                        TreeGraphNode leaf = (TreeGraphNode)gsLeaves.get(i);
                        indexToPos.put(leaf.label.index(), i + 1);
                    }
                    if (!conllx) break block6;
                    List leaves = tree.getLeaves();
                    Iterator uposTree = UniversalPOSMapper.mapTree(tree);
                    List<Label> uposLabels = ((Tree)((Object)uposTree)).preTerminalYield();
                    int index = 0;
                    CoreLabel sentence = new CoreLabel();
                    ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(leaves.size());
                    for (Tree leaf : leaves) {
                        if (!indexToPos.containsKey(++index)) continue;
                        CoreLabel token = new CoreLabel();
                        token.setIndex(index);
                        token.setValue(leaf.value());
                        token.setWord(leaf.value());
                        token.setTag(leaf.parent(tree).value());
                        token.set(CoreAnnotations.CoarseTagAnnotation.class, uposLabels.get(index - 1).value());
                        tokens.add(token);
                    }
                    sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
                    bf.append(GrammaticalStructure.dependenciesToCoNLLXString(deps, (CoreMap)sentence));
                    break block7;
                }
                if (!extraSep) break block8;
                ArrayList<TypedDependency> extraDeps = new ArrayList<TypedDependency>();
                for (TypedDependency dep : deps) {
                    if (dep.extra()) {
                        extraDeps.add(dep);
                        continue;
                    }
                    bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                if (extraDeps.isEmpty()) break block7;
                bf.append("======\n");
                for (TypedDependency dep : extraDeps) {
                    bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                break block7;
            }
            for (TypedDependency dep : deps) {
                bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                bf.append("\n");
            }
        }
        return bf.toString();
    }

    private static String toStringIndex(TypedDependency td, Map<Integer, Integer> indexToPos) {
        IndexedWord gov = td.gov();
        IndexedWord dep = td.dep();
        return td.reln() + "(" + gov.value() + "-" + indexToPos.get(gov.index()) + gov.toPrimes() + ", " + dep.value() + "-" + indexToPos.get(dep.index()) + dep.toPrimes() + ")";
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) throws IOException {
        LineNumberReader reader = new LineNumberReader(IOUtils.readerFromString(fileName));
        LinkedList<GrammaticalStructure> gsList = new LinkedList<GrammaticalStructure>();
        ArrayList<List<String>> tokenFields = new ArrayList<List<String>>();
        String inline = reader.readLine();
        while (inline != null) {
            if (!inline.isEmpty()) {
                List<String> fields = Arrays.asList(inline.split("\t"));
                if (fields.size() != 10) {
                    throw new RuntimeException(String.format("Error (line %d): 10 fields expected but %d are present", reader.getLineNumber(), fields.size()));
                }
                tokenFields.add(fields);
            } else if (!tokenFields.isEmpty()) {
                gsList.add(GrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, shortNameToGRel, factory));
                tokenFields = new ArrayList();
            }
            inline = reader.readLine();
        }
        return gsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) {
        ArrayList<IndexedWord> tgWords = new ArrayList<IndexedWord>(tokenFields.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
        SemanticHeadFinder headFinder = new SemanticHeadFinder();
        for (List<String> fields : tokenFields) {
            CoreLabel word = new CoreLabel();
            word.setValue(fields.get(1));
            word.setWord(fields.get(1));
            word.setTag(fields.get(3));
            word.setIndex(tgWords.size() + 1);
            CoreLabel pos = new CoreLabel();
            pos.setTag(fields.get(3));
            pos.setValue(fields.get(3));
            TreeGraphNode wordNode = new TreeGraphNode(word);
            TreeGraphNode posNode = new TreeGraphNode(pos);
            tgWords.add(new IndexedWord(word));
            tgPOSNodes.add(posNode);
            Tree[] childArr = new TreeGraphNode[]{wordNode};
            posNode.setChildren(childArr);
            wordNode.setParent(posNode);
            posNode.percolateHeads(headFinder);
        }
        TreeGraphNode root = new TreeGraphNode(new Word("ROOT-" + (tgPOSNodes.size() + 1)));
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(tgWords.size());
        CoreLabel rootLabel = new CoreLabel();
        rootLabel.setValue("ROOT");
        rootLabel.setWord("ROOT");
        rootLabel.setIndex(0);
        IndexedWord dependencyRoot = new IndexedWord(rootLabel);
        for (int i = 0; i < tgWords.size(); ++i) {
            TypedDependency tdep;
            String parentIdStr = tokenFields.get(i).get(6);
            if (parentIdStr == null || parentIdStr.equals("")) continue;
            int parentId = Integer.parseInt(parentIdStr) - 1;
            String grelString = tokenFields.get(i).get(7);
            if (grelString.equals("null") || grelString.equals("erased")) continue;
            GrammaticalRelation grel = shortNameToGRel.get(grelString.toLowerCase());
            if (grel == null) {
                if (!grelString.toLowerCase().equals("root")) throw new RuntimeException("Unknown grammatical relation '" + grelString + "' fields: " + tokenFields.get(i) + "\nNode: " + tgWords.get(i) + "\n" + "Known Grammatical relations: [" + shortNameToGRel.keySet() + "]");
                tdep = new TypedDependency(GrammaticalRelation.ROOT, dependencyRoot, (IndexedWord)tgWords.get(i));
            } else {
                if (parentId >= tgWords.size()) {
                    System.err.printf("Warning: Invalid Parent Id %d Sentence Length: %d%n", parentId + 1, tgWords.size());
                    System.err.printf("         Assigning to root (0)%n", new Object[0]);
                    parentId = -1;
                }
                tdep = new TypedDependency(grel, parentId == -1 ? dependencyRoot : (IndexedWord)tgWords.get(parentId), (IndexedWord)tgWords.get(i));
            }
            tdeps.add(tdep);
        }
        return factory.build(tdeps, root);
    }

    private static String[] parseClassConstructArgs(String namePlusArgs) {
        String[] args = StringUtils.EMPTY_STRING_ARRAY;
        String name = namePlusArgs;
        if (namePlusArgs.matches(".*\\([^)]*\\)$")) {
            String argStr = namePlusArgs.replaceFirst("^.*\\(([^)]*)\\)$", "$1");
            args = argStr.split(",");
            name = namePlusArgs.replaceFirst("\\([^)]*\\)$", "");
        }
        String[] tokens = new String[1 + args.length];
        tokens[0] = name;
        System.arraycopy(args, 0, tokens, 1, args.length);
        return tokens;
    }

    private static DependencyReader loadAlternateDependencyReader(String altDepReaderName) {
        DependencyReader altDepReader;
        Class<?> cl2;
        Class<DependencyReader> altDepReaderClass = null;
        String[] toks = GrammaticalStructure.parseClassConstructArgs(altDepReaderName);
        altDepReaderName = toks[0];
        String[] depReaderArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depReaderArgs, 0, toks.length - 1);
        try {
            cl2 = Class.forName(altDepReaderName);
            altDepReaderClass = cl2.asSubclass(DependencyReader.class);
        }
        catch (ClassNotFoundException cl2) {
            // empty catch block
        }
        if (altDepReaderClass == null) {
            try {
                cl2 = Class.forName("edu.stanford.nlp.trees." + altDepReaderName);
                altDepReaderClass = cl2.asSubclass(DependencyReader.class);
            }
            catch (ClassNotFoundException cl3) {
                // empty catch block
            }
        }
        if (altDepReaderClass == null) {
            System.err.println("Can't load dependency reader " + altDepReaderName + " or edu.stanford.nlp.trees." + altDepReaderName);
            return null;
        }
        if (depReaderArgs.length == 0) {
            try {
                altDepReader = altDepReaderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                System.err.println("No argument constructor to " + altDepReaderName + " is not public");
                return null;
            }
        }
        try {
            altDepReader = altDepReaderClass.getConstructor(String[].class).newInstance(new Object[]{depReaderArgs});
        }
        catch (IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.println(depReaderArgs.length + " argument constructor to " + altDepReaderName + " is not public.");
            return null;
        }
        catch (NoSuchMethodException e) {
            System.err.println("String arguments constructor to " + altDepReaderName + " does not exist.");
            return null;
        }
        return altDepReader;
    }

    private static DependencyPrinter loadAlternateDependencyPrinter(String altDepPrinterName) {
        Class<?> cl2;
        Class<DependencyPrinter> altDepPrinterClass = null;
        String[] toks = GrammaticalStructure.parseClassConstructArgs(altDepPrinterName);
        altDepPrinterName = toks[0];
        Object[] depPrintArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depPrintArgs, 0, toks.length - 1);
        try {
            cl2 = Class.forName(altDepPrinterName);
            altDepPrinterClass = cl2.asSubclass(DependencyPrinter.class);
        }
        catch (ClassNotFoundException cl2) {
            // empty catch block
        }
        if (altDepPrinterClass == null) {
            try {
                cl2 = Class.forName("edu.stanford.nlp.trees." + altDepPrinterName);
                altDepPrinterClass = cl2.asSubclass(DependencyPrinter.class);
            }
            catch (ClassNotFoundException cl3) {
                // empty catch block
            }
        }
        if (altDepPrinterClass == null) {
            System.err.printf("Unable to load alternative printer %s or %s. Is your classpath set correctly?\n", altDepPrinterName, "edu.stanford.nlp.trees." + altDepPrinterName);
            return null;
        }
        try {
            DependencyPrinter depPrinter = depPrintArgs.length == 0 ? altDepPrinterClass.newInstance() : altDepPrinterClass.getConstructor(String[].class).newInstance(new Object[]{depPrintArgs});
            return depPrinter;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            if (depPrintArgs.length == 0) {
                System.err.printf("Can't find no-argument constructor %s().%n", altDepPrinterName);
            } else {
                System.err.printf("Can't find constructor %s(%s).%n", altDepPrinterName, Arrays.toString(depPrintArgs));
            }
            return null;
        }
    }

    private static Function<List<? extends HasWord>, Tree> loadParser(String parserFile, String parserOptions, boolean makeCopulaHead) {
        Function lp;
        if (parserFile == null || "".equals(parserFile)) {
            parserFile = DEFAULT_PARSER_FILE;
            if (parserOptions == null) {
                parserOptions = "-retainTmpSubcategories";
            }
        }
        if (parserOptions == null) {
            parserOptions = "";
        }
        if (makeCopulaHead) {
            parserOptions = "-makeCopulaHead " + parserOptions;
        }
        parserOptions = parserOptions.trim();
        try {
            Class[] classes = new Class[]{String.class, String[].class};
            Method method = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getMethod("loadModel", classes);
            String[] opts = StringUtils.EMPTY_STRING_ARRAY;
            if (!parserOptions.isEmpty()) {
                opts = parserOptions.split(" +");
            }
            lp = (Function)method.invoke(null, parserFile, opts);
        }
        catch (Exception cnfe) {
            throw new RuntimeException(cnfe);
        }
        return lp;
    }

    public static void main(String[] args) {
        boolean portray;
        MemoryTreebank tb;
        Iterable<Tree> trees = tb = new MemoryTreebank(new NPTmpRetainingTreeNormalizer(0, false, 1, false));
        Iterable<GrammaticalStructure> gsBank = null;
        Properties props = StringUtils.argsToProperties(args);
        String encoding = props.getProperty("encoding", "utf-8");
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String conllXFileName = props.getProperty("conllxFile");
        String altDepPrinterName = props.getProperty("altprinter");
        String altDepReaderName = props.getProperty("altreader");
        String altDepReaderFilename = props.getProperty("altreaderfile");
        String filter = props.getProperty("filter");
        boolean makeCopulaHead = props.getProperty("makeCopulaHead") != null;
        boolean generateOriginalDependencies = props.getProperty("originalDependencies") != null;
        String tLPP = props.getProperty("tLPP", "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams");
        TreebankLangParserParams params = (TreebankLangParserParams)ReflectionLoading.loadByReflection(tLPP, new Object[0]);
        if (generateOriginalDependencies) {
            params.setGenerateOriginalDependencies(true);
        }
        if (makeCopulaHead) {
            String[] options = new String[]{"-makeCopulaHead"};
            params.setOptionFlag(options, 0);
        }
        if (sentFileName == null && (altDepReaderName == null || altDepReaderFilename == null) && treeFileName == null && conllXFileName == null && filter == null) {
            try {
                System.err.println("Usage: java GrammaticalStructure [options]* [-sentFile|-treeFile|-conllxFile file] [-testGraph]");
                System.err.println("  options: -basic, -collapsed, -CCprocessed [the default], -collapsedTree, -parseTree, -test, -parserFile file, -conllx, -keepPunct, -altprinter -altreader -altreaderfile -originalDependencies");
                PennTreeReader tr = new PennTreeReader(new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"));
                tb.add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else {
            if (altDepReaderName != null && altDepReaderFilename != null) {
                DependencyReader altDepReader = GrammaticalStructure.loadAlternateDependencyReader(altDepReaderName);
                try {
                    gsBank = altDepReader.readDependencies(altDepReaderFilename);
                }
                catch (IOException e) {
                    System.err.println("Error reading " + altDepReaderFilename);
                    return;
                }
            }
            if (treeFileName != null) {
                tb.loadPath(treeFileName);
            } else if (filter != null) {
                tb.load(IOUtils.readerFromStdin());
            } else {
                if (conllXFileName != null) {
                    try {
                        gsBank = params.readGrammaticalStructureFromFile(conllXFileName);
                    }
                    catch (RuntimeIOException e) {
                        System.err.println("Error reading " + conllXFileName);
                        return;
                    }
                }
                String parserFile = props.getProperty("parserFile");
                String parserOpts = props.getProperty("parserOpts");
                boolean tokenized = props.getProperty("tokenized") != null;
                Function<List<? extends HasWord>, Tree> lp = GrammaticalStructure.loadParser(parserFile, parserOpts, makeCopulaHead);
                trees = new LazyLoadTreesByParsing(sentFileName, encoding, tokenized, lp);
                try {
                    Method method = lp.getClass().getMethod("getTLPParams", new Class[0]);
                    params = (TreebankLangParserParams)method.invoke(lp, new Object[0]);
                }
                catch (Exception cnfe) {
                    throw new RuntimeException(cnfe);
                }
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean collapsedTree = props.getProperty("collapsedTree") != null;
        boolean nonCollapsed = props.getProperty("nonCollapsed") != null;
        boolean extraSep = props.getProperty("extraSep") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        boolean keepPunct = props.getProperty("keepPunct") != null;
        boolean conllx = props.getProperty("conllx") != null;
        boolean checkConnected = props.getProperty("checkConnected") != null;
        boolean bl = portray = props.getProperty("portray") != null;
        if (conllx) {
            keepPunct = true;
        }
        DependencyPrinter altDepPrinter = null;
        if (altDepPrinterName != null) {
            altDepPrinter = GrammaticalStructure.loadAlternateDependencyPrinter(altDepPrinterName);
        }
        Method m = null;
        if (test) {
            try {
                Class<?> sgf = Class.forName("edu.stanford.nlp.semgraph.SemanticGraphFactory");
                m = sgf.getDeclaredMethod("makeFromTree", GrammaticalStructure.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Predicate.class, String.class, Integer.TYPE);
            }
            catch (Exception e) {
                System.err.println("Test cannot check for cycles in tree format (classes not available)");
            }
        }
        if (gsBank == null) {
            gsBank = new TreeBankGrammaticalStructureWrapper(trees, keepPunct, params);
        }
        for (GrammaticalStructure gs : gsBank) {
            Tree tree = gsBank instanceof TreeBankGrammaticalStructureWrapper ? ((TreeBankGrammaticalStructureWrapper)gsBank).getOriginalTree(gs) : gs.root();
            if (test) {
                System.out.println("============= parse tree =======================");
                tree.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                boolean allConnected = true;
                Collection<TypedDependency> bungRoots = null;
                System.out.println("------------- basic dependencies ---------------");
                List<TypedDependency> gsb = gs.typedDependencies(Extras.NONE);
                System.out.println(StringUtils.join(gsb, "\n"));
                boolean connected = GrammaticalStructure.isConnected(gsb);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gsb);
                }
                allConnected = connected && allConnected;
                System.out.println("------------- non-collapsed dependencies (basic + extra) ---------------");
                List<TypedDependency> gse = gs.typedDependencies(Extras.MAXIMAL);
                System.out.println(StringUtils.join(gse, "\n"));
                connected = GrammaticalStructure.isConnected(gse);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gse);
                }
                allConnected = connected && allConnected;
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(Extras.MAXIMAL), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                List<TypedDependency> gscc = gs.typedDependenciesCollapsed(Extras.MAXIMAL);
                System.out.println(StringUtils.join(gscc, "\n"));
                System.out.println("-----------------------------------------------");
                connected = GrammaticalStructure.isConnected(gscc);
                if (!connected && bungRoots == null) {
                    bungRoots = GrammaticalStructure.getRoots(gscc);
                }
                boolean bl2 = allConnected = connected && allConnected;
                if (allConnected) {
                    System.out.println("dependencies form connected graphs.");
                } else {
                    System.out.println("dependency graph NOT connected! possible offending nodes: " + bungRoots);
                }
                if (m != null) {
                    try {
                        Object semGraph = m.invoke(null, gs, false, true, false, false, false, false, null, null, 0);
                        Class<?> sg = Class.forName("edu.stanford.nlp.semgraph.SemanticGraph");
                        Method mDag = sg.getDeclaredMethod("isDag", new Class[0]);
                        boolean isDag = (Boolean)mDag.invoke(semGraph, new Object[0]);
                        System.out.println("tree dependencies form a DAG: " + isDag);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (parseTree) {
                    System.out.println("============= parse tree =======================");
                    tree.pennPrint();
                    System.out.println();
                }
                if (basic) {
                    if (collapsed || CCprocessed || collapsedTree || nonCollapsed) {
                        System.out.println("------------- basic dependencies ---------------");
                    }
                    if (altDepPrinter == null) {
                        GrammaticalStructure.printDependencies(gs, gs.typedDependencies(Extras.NONE), tree, conllx, false);
                    } else {
                        System.out.println(altDepPrinter.dependenciesToString(gs, gs.typedDependencies(Extras.NONE), tree));
                    }
                }
                if (nonCollapsed) {
                    if (basic || CCprocessed || collapsed || collapsedTree) {
                        System.out.println("----------- non-collapsed dependencies (basic + extra) -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.allTypedDependencies(), tree, conllx, extraSep);
                }
                if (collapsed) {
                    if (basic || CCprocessed || collapsedTree || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsed(Extras.MAXIMAL), tree, conllx, false);
                }
                if (CCprocessed) {
                    if (basic || collapsed || collapsedTree || nonCollapsed) {
                        System.out.println("---------- CCprocessed dependencies ----------");
                    }
                    List<TypedDependency> deps = gs.typedDependenciesCCprocessed(Extras.MAXIMAL);
                    if (checkConnected && !GrammaticalStructure.isConnected(deps)) {
                        System.err.println("Graph is not connected for:");
                        System.err.println(tree);
                        System.err.println("possible offending nodes: " + GrammaticalStructure.getRoots(deps));
                    }
                    GrammaticalStructure.printDependencies(gs, deps, tree, conllx, false);
                }
                if (collapsedTree) {
                    if (basic || CCprocessed || collapsed || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies tree -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsedTree(), tree, conllx, false);
                }
                if (!(basic || collapsed || CCprocessed || collapsedTree || nonCollapsed)) {
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCCprocessed(Extras.MAXIMAL), tree, conllx, false);
                }
            }
            if (!portray) continue;
            try {
                Class<?> sgu = Class.forName("edu.stanford.nlp.semgraph.SemanticGraphUtils");
                Method mRender = sgu.getDeclaredMethod("render", GrammaticalStructure.class, String.class);
                mRender.invoke(null, gs, "Collapsed, CC processed deps");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't use swing to portray semantic graph", e);
            }
        }
    }

    static class LazyLoadTreesByParsing
    implements Iterable<Tree> {
        final Reader reader;
        final String filename;
        final boolean tokenized;
        final String encoding;
        final Function<List<? extends HasWord>, Tree> lp;

        public LazyLoadTreesByParsing(String filename, String encoding, boolean tokenized, Function<List<? extends HasWord>, Tree> lp) {
            this.filename = filename;
            this.encoding = encoding;
            this.reader = null;
            this.tokenized = tokenized;
            this.lp = lp;
        }

        @Override
        public Iterator<Tree> iterator() {
            BufferedReader iReader;
            if (this.reader != null) {
                iReader = new BufferedReader(this.reader);
            } else {
                try {
                    iReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), this.encoding));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Iterator<Tree>(){
                String line;

                @Override
                public boolean hasNext() {
                    if (this.line != null) {
                        return true;
                    }
                    try {
                        this.line = iReader.readLine();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.line == null) {
                        try {
                            if (reader == null) {
                                iReader.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public Tree next() {
                    if (this.line == null) {
                        throw new NoSuchElementException();
                    }
                    StringReader lineReader = new StringReader(this.line);
                    this.line = null;
                    List words = tokenized ? WhitespaceTokenizer.newWordWhitespaceTokenizer(lineReader).tokenize() : PTBTokenizer.newPTBTokenizer(lineReader).tokenize();
                    if (!words.isEmpty()) {
                        Tree parseTree = lp.apply(words);
                        return parseTree;
                    }
                    return new SimpleTree();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class TreeBankGrammaticalStructureWrapper
    implements Iterable<GrammaticalStructure> {
        private final Iterable<Tree> trees;
        private final boolean keepPunct;
        private final TreebankLangParserParams params;
        private final Map<GrammaticalStructure, Tree> origTrees = new WeakHashMap<GrammaticalStructure, Tree>();

        public TreeBankGrammaticalStructureWrapper(Iterable<Tree> wrappedTrees, boolean keepPunct, TreebankLangParserParams params) {
            this.trees = wrappedTrees;
            this.keepPunct = keepPunct;
            this.params = params;
        }

        @Override
        public Iterator<GrammaticalStructure> iterator() {
            return new GsIterator();
        }

        public Tree getOriginalTree(GrammaticalStructure gs) {
            return this.origTrees.get(gs);
        }

        private class GsIterator
        implements Iterator<GrammaticalStructure> {
            private final Iterator<Tree> tbIterator;
            private final Predicate<String> puncFilter;
            private final HeadFinder hf;
            private GrammaticalStructure next;

            public GsIterator() {
                this.tbIterator = TreeBankGrammaticalStructureWrapper.this.trees.iterator();
                this.puncFilter = TreeBankGrammaticalStructureWrapper.this.keepPunct ? Filters.acceptFilter() : (TreeBankGrammaticalStructureWrapper.this.params.generateOriginalDependencies() ? TreeBankGrammaticalStructureWrapper.this.params.treebankLanguagePack().punctuationWordRejectFilter() : TreeBankGrammaticalStructureWrapper.this.params.treebankLanguagePack().punctuationTagRejectFilter());
                this.hf = TreeBankGrammaticalStructureWrapper.this.params.typedDependencyHeadFinder();
                this.primeGs();
            }

            private void primeGs() {
                GrammaticalStructure gs = null;
                while (gs == null && this.tbIterator.hasNext()) {
                    Tree t = this.tbIterator.next();
                    if (t == null) continue;
                    try {
                        gs = TreeBankGrammaticalStructureWrapper.this.params.getGrammaticalStructure(t, this.puncFilter, this.hf);
                        TreeBankGrammaticalStructureWrapper.this.origTrees.put(gs, t);
                        this.next = gs;
                        return;
                    }
                    catch (NullPointerException npe) {
                        System.err.println("Bung tree caused below dump. Continuing....");
                        System.err.println(t);
                        npe.printStackTrace();
                    }
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public GrammaticalStructure next() {
                GrammaticalStructure ret = this.next;
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                this.primeGs();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class NameComparator<X>
    implements Comparator<X> {
        private NameComparator() {
        }

        @Override
        public int compare(X o1, X o2) {
            String n1 = o1.toString();
            String n2 = o2.toString();
            return n1.compareTo(n2);
        }
    }

    private static class NoPunctTypedDependencyFilter
    implements Predicate<TypedDependency>,
    Serializable {
        private Predicate<String> npf;
        private Predicate<String> tf;
        private static final long serialVersionUID = -2872766864289207468L;

        NoPunctTypedDependencyFilter(Predicate<String> f, Predicate<String> tf) {
            this.npf = f;
            this.tf = tf;
        }

        @Override
        public boolean test(TypedDependency d) {
            if (d == null) {
                return false;
            }
            IndexedWord l = d.dep();
            if (l == null) {
                return false;
            }
            return this.npf.test(l.value()) && this.tf.test(l.tag());
        }
    }

    private static class NoPunctFilter
    implements Predicate<Dependency<Label, Label, Object>>,
    Serializable {
        private Predicate<String> npf;
        private static final long serialVersionUID = -2319891944796663180L;

        NoPunctFilter(Predicate<String> f) {
            this.npf = f;
        }

        @Override
        public boolean test(Dependency<Label, Label, Object> d) {
            if (d == null) {
                return false;
            }
            Label lab = d.dependent();
            if (lab == null) {
                return false;
            }
            return this.npf.test(lab.value());
        }
    }

    public static enum Extras {
        NONE(false, false, false),
        REF_ONLY_UNCOLLAPSED(true, false, false),
        REF_ONLY_COLLAPSED(true, false, true),
        SUBJ_ONLY(false, true, false),
        REF_UNCOLLAPSED_AND_SUBJ(true, true, false),
        REF_COLLAPSED_AND_SUBJ(true, true, true),
        MAXIMAL(true, true, true);

        public final boolean doRef;
        public final boolean doSubj;
        public final boolean collapseRef;

        private Extras(boolean doRef, boolean doSubj, boolean collapseRef) {
            this.doRef = doRef;
            this.doSubj = doSubj;
            this.collapseRef = collapseRef;
        }
    }
}

