/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.Disposer;
import com.sun.javafx.embed.swing.DisposerRecord;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.FXDnD;
import javafx.embed.swing.SwingCursors;
import javafx.embed.swing.SwingEvents;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.JComponent;
import sun.awt.UngrabEvent;
import sun.swing.JLightweightFrame;
import sun.swing.LightweightContent;

public class SwingNode
extends Node {
    private static boolean isThreadMerged;
    private double fxWidth;
    private double fxHeight;
    private int swingPrefWidth;
    private int swingPrefHeight;
    private int swingMaxWidth;
    private int swingMaxHeight;
    private int swingMinWidth;
    private int swingMinHeight;
    private volatile JComponent content;
    private volatile JLightweightFrame lwFrame;
    private NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private volatile int scale = 1;
    private EventHandler windowHiddenHandler = event -> {
        Window window;
        TKStage tKStage;
        if (this.lwFrame != null && event.getTarget() instanceof Window && (tKStage = (window = (Window)event.getTarget()).impl_getPeer()) != null) {
            if (isThreadMerged) {
                jlfOverrideNativeWindowHandle.invoke(this.lwFrame, 0L, null);
            } else {
                tKStage.postponeClose();
                SwingFXUtils.runOnEDT(() -> jlfOverrideNativeWindowHandle.invoke(this.lwFrame, 0L, () -> SwingFXUtils.runOnFxThread(() -> tKStage.closePostponed())));
            }
        }
    };
    private Window hWindow = null;
    private static final OptionalMethod<JLightweightFrame> jlfNotifyDisplayChanged;
    private static OptionalMethod<JLightweightFrame> jlfOverrideNativeWindowHandle;
    private List<Runnable> peerRequests = new ArrayList<Runnable>();
    private final InvalidationListener locationListener = observable -> this.locateLwFrame();
    private final EventHandler<FocusUngrabEvent> ungrabHandler = focusUngrabEvent -> {
        if (!this.skipBackwardUnrgabNotification && this.lwFrame != null) {
            AccessController.doPrivileged(new PostEventAction(new UngrabEvent(this.lwFrame)));
        }
    };
    private final ChangeListener<Boolean> windowVisibleListener = (observableValue, bl, bl2) -> {
        if (!bl2.booleanValue()) {
            this.disposeLwFrame();
        } else {
            this.setContent(this.content);
        }
    };
    private final ChangeListener<Window> sceneWindowListener = (observableValue, window, window2) -> {
        if (window != null) {
            this.removeWindowListeners((Window)window);
        }
        this.notifyNativeHandle((Window)window2);
        if (window2 != null) {
            this.addWindowListeners((Window)window2);
        }
    };
    private static final OptionalMethod<JLightweightFrame> jlfSetHostBounds;

    final JLightweightFrame getLightweightFrame() {
        return this.lwFrame;
    }

    public SwingNode() {
        this.setFocusTraversable(true);
        this.setEventHandler(javafx.scene.input.MouseEvent.ANY, new SwingMouseEventHandler());
        this.setEventHandler(KeyEvent.ANY, new SwingKeyEventHandler());
        this.setEventHandler(ScrollEvent.SCROLL, new SwingScrollEventHandler());
        this.focusedProperty().addListener((observableValue, bl, bl2) -> this.activateLwFrame((boolean)bl2));
        Font.getFamilies();
    }

    private void notifyNativeHandle(Window window) {
        if (this.hWindow != window) {
            if (this.hWindow != null) {
                this.hWindow.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            if (window != null) {
                window.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            this.hWindow = window;
        }
        if (this.lwFrame != null) {
            TKStage tKStage;
            long l = 0L;
            if (window != null && (tKStage = window.impl_getPeer()) != null) {
                l = tKStage.getRawHandle();
            }
            jlfOverrideNativeWindowHandle.invoke(this.lwFrame, l, null);
        }
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
        SwingFXUtils.runOnEDT(() -> this.setContentImpl(jComponent));
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent jComponent) {
        if (this.lwFrame != null) {
            this.lwFrame.dispose();
            this.lwFrame = null;
        }
        if (jComponent != null) {
            this.lwFrame = new JLightweightFrame();
            SwingNodeWindowFocusListener swingNodeWindowFocusListener = new SwingNodeWindowFocusListener(this);
            this.lwFrame.addWindowFocusListener(swingNodeWindowFocusListener);
            jlfNotifyDisplayChanged.invoke(this.lwFrame, this.scale);
            this.lwFrame.setContent(new SwingNodeContent(jComponent, this));
            this.lwFrame.setVisible(true);
            if (this.getScene() != null) {
                this.notifyNativeHandle(this.getScene().getWindow());
            }
            SwingNodeDisposer swingNodeDisposer = new SwingNodeDisposer(this.lwFrame);
            Disposer.addRecord(this, swingNodeDisposer);
            SwingFXUtils.runOnFxThread(() -> {
                this.locateLwFrame();
                if (this.focusedProperty().get()) {
                    this.activateLwFrame(true);
                }
            });
        }
    }

    private static float getRenderScale(Window window) {
        return WindowHelper.getWindowAccessor().getRenderScale(window);
    }

    private static float getPlatformScaleX(Window window) {
        return WindowHelper.getWindowAccessor().getPlatformScaleX(window);
    }

    private static float getPlatformScaleY(Window window) {
        return WindowHelper.getWindowAccessor().getPlatformScaleY(window);
    }

    private float getPlatformScaleX() {
        return SwingNode.getPlatformScaleX(this.getScene().getWindow());
    }

    private float getPlatformScaleY() {
        return SwingNode.getPlatformScaleY(this.getScene().getWindow());
    }

    void setImageBuffer(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Runnable runnable = () -> {
            Window window = this.getScene().getWindow();
            float f = SwingNode.getPlatformScaleX(window);
            float f2 = SwingNode.getPlatformScaleY(window);
            this.peer.setImageBuffer(IntBuffer.wrap(nArray), n, n2, n3, n4, (float)n3 / f, (float)n4 / f2, n5, n6);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.clear();
                this.peerRequests.add(runnable);
            }
        });
    }

    void setImageBounds(int n, int n2, int n3, int n4) {
        Runnable runnable = () -> {
            Window window = this.getScene().getWindow();
            float f = SwingNode.getPlatformScaleX(window);
            float f2 = SwingNode.getPlatformScaleY(window);
            this.peer.setImageBounds(n, n2, n3, n4, (float)n3 / f, (float)n4 / f2);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.add(runnable);
            }
        });
    }

    void repaintDirtyRegion(int n, int n2, int n3, int n4) {
        Runnable runnable = () -> {
            this.peer.repaintDirtyRegion(n, n2, n3, n4);
            this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.add(runnable);
            }
        });
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        super.resize(d, d2);
        if (d != this.fxWidth || d2 != this.fxHeight) {
            this.fxWidth = d;
            this.fxHeight = d2;
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            SwingFXUtils.runOnEDT(() -> {
                if (this.lwFrame != null) {
                    this.locateLwFrame();
                }
            });
        }
    }

    @Override
    public double prefWidth(double d) {
        return (float)this.swingPrefWidth / this.getPlatformScaleX();
    }

    @Override
    public double prefHeight(double d) {
        return (float)this.swingPrefHeight / this.getPlatformScaleY();
    }

    @Override
    public double maxWidth(double d) {
        return (float)this.swingMaxWidth / this.getPlatformScaleX();
    }

    @Override
    public double maxHeight(double d) {
        return (float)this.swingMaxHeight / this.getPlatformScaleY();
    }

    @Override
    public double minWidth(double d) {
        return (float)this.swingMinWidth / this.getPlatformScaleX();
    }

    @Override
    public double minHeight(double d) {
        return (float)this.swingMinHeight / this.getPlatformScaleY();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
            this.notifyNativeHandle(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.widthProperty().addListener(this.locationListener);
        window.heightProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
        this.scale = Math.round(SwingNode.getRenderScale(window));
        this.setLwFrameScale(this.scale);
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.widthProperty().removeListener(this.locationListener);
        window.heightProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable runnable : this.peerRequests) {
            runnable.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            this.addSceneListeners(this.getScene());
        }
        this.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                this.removeSceneListeners((Scene)scene);
                this.disposeLwFrame();
            }
            if (scene2 != null) {
                if (this.content != null && this.lwFrame == null) {
                    this.setContent(this.content);
                }
                this.addSceneListeners((Scene)scene2);
            }
        });
        this.impl_treeVisibleProperty().addListener((observableValue, bl, bl2) -> this.setLwFrameVisible((boolean)bl2));
        return this.peer;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_VISIBLE) || this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        Window window = this.getScene().getWindow();
        float f = SwingNode.getRenderScale(window);
        float f2 = SwingNode.getPlatformScaleX(window);
        float f3 = SwingNode.getPlatformScaleY(window);
        int n = Math.round(f);
        boolean bl = this.scale != n;
        this.scale = n;
        Point2D point2D = this.localToScene(0.0, 0.0);
        int n2 = (int)(window.getX() * (double)f2);
        int n3 = (int)(window.getY() * (double)f3);
        int n4 = (int)(window.getWidth() * (double)f2);
        int n5 = (int)(window.getHeight() * (double)f3);
        int n6 = (int)Math.round((window.getX() + this.getScene().getX() + point2D.getX()) * (double)f2);
        int n7 = (int)Math.round((window.getY() + this.getScene().getY() + point2D.getY()) * (double)f3);
        int n8 = (int)(this.fxWidth * (double)f2);
        int n9 = (int)(this.fxHeight * (double)f3);
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                if (bl) {
                    jlfNotifyDisplayChanged.invoke(this.lwFrame, this.scale);
                }
                this.lwFrame.setSize(n8, n9);
                this.lwFrame.setLocation(n6, n7);
                jlfSetHostBounds.invoke(this.lwFrame, n2, n3, n4, n5);
            }
        });
    }

    private void activateLwFrame(boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.emulateActivation(bl);
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.dispose();
                this.lwFrame = null;
            }
        });
    }

    private void setLwFrameVisible(boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.setVisible(bl);
            }
        });
    }

    private void setLwFrameScale(final int n) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    jlfNotifyDisplayChanged.invoke(SwingNode.this.lwFrame, n);
                }
            }
        });
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.fxWidth, (float)this.fxHeight, 0.0f);
        baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processLeafNode(this, mXNodeAlgorithmContext);
    }

    private void ungrabFocus(boolean bl) {
        if (PlatformUtil.isLinux()) {
            return;
        }
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().impl_getPeer() != null) {
            this.skipBackwardUnrgabNotification = !bl;
            this.getScene().getWindow().impl_getPeer().ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                isThreadMerged = Boolean.valueOf(System.getProperty("javafx.embed.singleThread"));
                return null;
            }
        });
        jlfNotifyDisplayChanged = new OptionalMethod<JLightweightFrame>(JLightweightFrame.class, "notifyDisplayChanged", Integer.TYPE);
        jlfOverrideNativeWindowHandle = new OptionalMethod<JLightweightFrame>(JLightweightFrame.class, "overrideNativeWindowHandle", Long.TYPE, Runnable.class);
        jlfSetHostBounds = new OptionalMethod<JLightweightFrame>(JLightweightFrame.class, "setHostBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    }

    private class SwingKeyEventHandler
    implements EventHandler<KeyEvent> {
        private SwingKeyEventHandler() {
        }

        @Override
        public void handle(KeyEvent keyEvent) {
            String string;
            int n;
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            if (keyEvent.getCharacter().isEmpty()) {
                return;
            }
            if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.TAB) {
                keyEvent.consume();
            }
            if ((n = SwingEvents.fxKeyEventTypeToKeyID(keyEvent)) < 0) {
                return;
            }
            int n2 = SwingEvents.fxKeyModsToKeyMods(keyEvent);
            int n3 = keyEvent.getCode().impl_getCode();
            char c = keyEvent.getCharacter().charAt(0);
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && (string = keyEvent.getText()).length() == 1) {
                c = string.charAt(0);
            }
            long l = System.currentTimeMillis();
            java.awt.event.KeyEvent keyEvent2 = new java.awt.event.KeyEvent(jLightweightFrame, n, l, n2, n3, c);
            AccessController.doPrivileged(new PostEventAction(keyEvent2));
        }
    }

    private class SwingScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private SwingScrollEventHandler() {
        }

        @Override
        public void handle(ScrollEvent scrollEvent) {
            double d;
            boolean bl;
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            int n = SwingEvents.fxScrollModsToMouseWheelMods(scrollEvent);
            boolean bl2 = bl = (n & 0x40) != 0;
            if (!bl && scrollEvent.getDeltaY() != 0.0) {
                this.sendMouseWheelEvent(jLightweightFrame, scrollEvent.getX(), scrollEvent.getY(), n, scrollEvent.getDeltaY() / scrollEvent.getMultiplierY());
            }
            double d2 = d = bl && scrollEvent.getDeltaY() != 0.0 ? scrollEvent.getDeltaY() / scrollEvent.getMultiplierY() : scrollEvent.getDeltaX() / scrollEvent.getMultiplierX();
            if (d != 0.0) {
                this.sendMouseWheelEvent(jLightweightFrame, scrollEvent.getX(), scrollEvent.getY(), n |= 0x40, d);
            }
        }

        private void sendMouseWheelEvent(Component component, double d, double d2, int n, double d3) {
            int n2 = (int)d3;
            int n3 = (int)Math.signum(d3);
            if ((double)n3 * d3 < 1.0) {
                n2 = n3;
            }
            Window window = SwingNode.this.getScene().getWindow();
            float f = SwingNode.getPlatformScaleX(window);
            float f2 = SwingNode.getPlatformScaleY(window);
            int n4 = (int)Math.round(d * (double)f);
            int n5 = (int)Math.round(d2 * (double)f2);
            MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(component, 507, System.currentTimeMillis(), n, n4, n5, 0, 0, 0, false, 0, 1, -n2);
            AccessController.doPrivileged(new PostEventAction(mouseWheelEvent));
        }
    }

    private class SwingMouseEventHandler
    implements EventHandler<javafx.scene.input.MouseEvent> {
        private final Set<MouseButton> mouseClickedAllowed = new HashSet<MouseButton>();

        private SwingMouseEventHandler() {
        }

        @Override
        public void handle(javafx.scene.input.MouseEvent mouseEvent) {
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            int n = SwingEvents.fxMouseEventTypeToMouseID(mouseEvent);
            if (n < 0) {
                return;
            }
            mouseEvent.consume();
            EventType<? extends javafx.scene.input.MouseEvent> eventType = mouseEvent.getEventType();
            if (eventType == javafx.scene.input.MouseEvent.MOUSE_PRESSED) {
                this.mouseClickedAllowed.add(mouseEvent.getButton());
            } else if (eventType != javafx.scene.input.MouseEvent.MOUSE_RELEASED) {
                if (eventType == javafx.scene.input.MouseEvent.MOUSE_DRAGGED) {
                    this.mouseClickedAllowed.clear();
                } else if (eventType == javafx.scene.input.MouseEvent.MOUSE_CLICKED) {
                    if (mouseEvent.getClickCount() == 1 && !this.mouseClickedAllowed.contains((Object)mouseEvent.getButton())) {
                        return;
                    }
                    this.mouseClickedAllowed.remove((Object)mouseEvent.getButton());
                }
            }
            int n2 = SwingEvents.fxMouseModsToMouseMods(mouseEvent);
            boolean bl = mouseEvent.isPopupTrigger();
            int n3 = SwingEvents.fxMouseButtonToMouseButton(mouseEvent);
            long l = System.currentTimeMillis();
            Window window = SwingNode.this.getScene().getWindow();
            float f = SwingNode.getPlatformScaleX(window);
            float f2 = SwingNode.getPlatformScaleY(window);
            int n4 = (int)Math.round(mouseEvent.getX() * (double)f);
            int n5 = (int)Math.round(mouseEvent.getY() * (double)f2);
            int n6 = (int)Math.round(mouseEvent.getScreenX() * (double)f);
            int n7 = (int)Math.round(mouseEvent.getScreenY() * (double)f2);
            MouseEvent mouseEvent2 = new MouseEvent(jLightweightFrame, n, l, n2, n4, n5, n6, n7, mouseEvent.getClickCount(), bl, n3);
            AccessController.doPrivileged(new PostEventAction(mouseEvent2));
        }
    }

    private class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        public PostEventAction(AWTEvent aWTEvent) {
            this.event = aWTEvent;
        }

        @Override
        public Void run() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(this.event);
            return null;
        }
    }

    private static class SwingNodeContent
    implements LightweightContent {
        private JComponent comp;
        private volatile FXDnD dnd;
        private WeakReference<SwingNode> swingNodeRef;

        public SwingNodeContent(JComponent jComponent, SwingNode swingNode) {
            this.comp = jComponent;
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public JComponent getComponent() {
            return this.comp;
        }

        @Override
        public void paintLock() {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.paintLock.lock();
            }
        }

        @Override
        public void paintUnlock() {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.paintLock.unlock();
            }
        }

        @Override
        public void imageBufferReset(int[] nArray, int n, int n2, int n3, int n4, int n5) {
            this.imageBufferReset(nArray, n, n2, n3, n4, n5, 1);
        }

        @Override
        public void imageBufferReset(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.setImageBuffer(nArray, n, n2, n3, n4, n5, n6);
            }
        }

        @Override
        public void imageReshaped(int n, int n2, int n3, int n4) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.setImageBounds(n, n2, n3, n4);
            }
        }

        @Override
        public void imageUpdated(int n, int n2, int n3, int n4) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.repaintDirtyRegion(n, n2, n3, n4);
            }
        }

        @Override
        public void focusGrabbed() {
            SwingFXUtils.runOnFxThread(() -> {
                Scene scene;
                if (PlatformUtil.isLinux()) {
                    return;
                }
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null && (scene = swingNode.getScene()) != null && scene.getWindow() != null && scene.getWindow().impl_getPeer() != null) {
                    scene.getWindow().impl_getPeer().grabFocus();
                    swingNode.grabbed = true;
                }
            });
        }

        @Override
        public void focusUngrabbed() {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.ungrabFocus(false);
                }
            });
        }

        @Override
        public void preferredSizeChanged(int n, int n2) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingPrefWidth = n;
                    swingNode.swingPrefHeight = n2;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void maximumSizeChanged(int n, int n2) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingMaxWidth = n;
                    swingNode.swingMaxHeight = n2;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void minimumSizeChanged(int n, int n2) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingMinWidth = n;
                    swingNode.swingMinHeight = n2;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void setCursor(Cursor cursor) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.setCursor(SwingCursors.embedCursorToCursor(cursor));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDnD() {
            SwingNodeContent swingNodeContent = this;
            synchronized (swingNodeContent) {
                SwingNode swingNode;
                if (this.dnd == null && (swingNode = (SwingNode)this.swingNodeRef.get()) != null) {
                    this.dnd = new FXDnD(swingNode);
                }
            }
        }

        @Override
        public synchronized <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
            this.initDnD();
            return this.dnd.createDragGestureRecognizer(clazz, dragSource, component, n, dragGestureListener);
        }

        @Override
        public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
            this.initDnD();
            return this.dnd.createDragSourceContextPeer(dragGestureEvent);
        }

        @Override
        public void addDropTarget(DropTarget dropTarget) {
            this.initDnD();
            this.dnd.addDropTarget(dropTarget);
        }

        @Override
        public void removeDropTarget(DropTarget dropTarget) {
            this.initDnD();
            this.dnd.removeDropTarget(dropTarget);
        }
    }

    private static class SwingNodeWindowFocusListener
    implements WindowFocusListener {
        private WeakReference<SwingNode> swingNodeRef;

        SwingNodeWindowFocusListener(SwingNode swingNode) {
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public void windowGainedFocus(java.awt.event.WindowEvent windowEvent) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.requestFocus();
                }
            });
        }

        @Override
        public void windowLostFocus(java.awt.event.WindowEvent windowEvent) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.ungrabFocus(true);
                }
            });
        }
    }

    private static class SwingNodeDisposer
    implements DisposerRecord {
        JLightweightFrame lwFrame;

        SwingNodeDisposer(JLightweightFrame jLightweightFrame) {
            this.lwFrame = jLightweightFrame;
        }

        @Override
        public void dispose() {
            if (this.lwFrame != null) {
                this.lwFrame.dispose();
                this.lwFrame = null;
            }
        }
    }

    private static final class OptionalMethod<T> {
        private final Method method;

        public OptionalMethod(Class<T> clazz, String string, Class<?> ... classArray) {
            Method method;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = null;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error when calling " + clazz.getName() + ".getMethod('" + string + "').", throwable);
            }
            this.method = method;
        }

        public boolean isSupported() {
            return this.method != null;
        }

        public Object invoke(T t, Object ... objectArray) {
            if (this.method != null) {
                try {
                    return this.method.invoke(t, objectArray);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Error when calling " + t.getClass().getName() + "." + this.method.getName() + "().", throwable);
                }
            }
            return null;
        }
    }
}

