/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.sieve;

import edu.stanford.nlp.hcoref.CorefPrinter;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.sieve.DeterministicCorefSieve;
import edu.stanford.nlp.hcoref.sieve.OracleSieve;
import edu.stanford.nlp.hcoref.sieve.RFSieve;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public abstract class Sieve
implements Serializable {
    private static final long serialVersionUID = 3986463332365306868L;
    public ClassifierType classifierType = null;
    protected Locale lang;
    public final String sievename;
    public int maxSentDist = -1;
    public final Set<Dictionaries.MentionType> mType;
    public final Set<Dictionaries.MentionType> aType;
    public final Set<String> mTypeStr;
    public final Set<String> aTypeStr;
    public Properties props = null;

    public Sieve() {
        this.lang = Locale.ENGLISH;
        this.sievename = this.getClass().getSimpleName();
        this.aType = new HashSet<Dictionaries.MentionType>(Arrays.asList(Dictionaries.MentionType.values()));
        this.mType = new HashSet<Dictionaries.MentionType>(Arrays.asList(Dictionaries.MentionType.values()));
        this.maxSentDist = 1000;
        this.mTypeStr = Generics.newHashSet();
        this.aTypeStr = Generics.newHashSet();
    }

    public Sieve(Properties props) {
        this.lang = CorefProperties.getLanguage(props);
        this.sievename = this.getClass().getSimpleName();
        this.aType = CorefProperties.getAntecedentType(props, this.sievename);
        this.mType = CorefProperties.getMentionType(props, this.sievename);
        this.maxSentDist = CorefProperties.getMaxSentDistForSieve(props, this.sievename);
        this.mTypeStr = CorefProperties.getMentionTypeStr(props, this.sievename);
        this.aTypeStr = CorefProperties.getAntecedentTypeStr(props, this.sievename);
    }

    public Sieve(Properties props, String sievename) {
        this.lang = CorefProperties.getLanguage(props);
        this.sievename = sievename;
        this.aType = CorefProperties.getAntecedentType(props, sievename);
        this.mType = CorefProperties.getMentionType(props, sievename);
        this.maxSentDist = CorefProperties.getMaxSentDistForSieve(props, sievename);
        this.mTypeStr = CorefProperties.getMentionTypeStr(props, sievename);
        this.aTypeStr = CorefProperties.getAntecedentTypeStr(props, sievename);
    }

    public String resolveMention(Document document, Dictionaries dict, Properties props) throws Exception {
        StringBuilder sbLog = new StringBuilder();
        if (CorefProperties.debug(props)) {
            sbLog.append("=======================================================");
            sbLog.append(CorefPrinter.printRawDoc(document, true, true));
        }
        for (List<Mention> mentionsInSent : document.predictedMentions) {
            for (int mIdx = 0; mIdx < mentionsInSent.size(); ++mIdx) {
                Mention m = mentionsInSent.get(mIdx);
                if (this.skipMentionType(m, props)) continue;
                this.findCoreferentAntecedent(m, mIdx, document, dict, props, sbLog);
            }
        }
        return sbLog.toString();
    }

    public abstract void findCoreferentAntecedent(Mention var1, int var2, Document var3, Dictionaries var4, Properties var5, StringBuilder var6) throws Exception;

    public static Sieve loadSieve(Properties props, String sievename) throws Exception {
        switch (CorefProperties.getClassifierType(props, sievename)) {
            case RULE: {
                DeterministicCorefSieve sieve = (DeterministicCorefSieve)Class.forName("edu.stanford.nlp.hcoref.sieve." + sievename).getConstructor(new Class[0]).newInstance(new Object[0]);
                sieve.props = props;
                sieve.lang = CorefProperties.getLanguage(props);
                return sieve;
            }
            case RF: {
                System.err.print("Loading sieve: " + sievename + " from " + CorefProperties.getPathModel(props, sievename) + " ... ");
                RFSieve rfsieve = (RFSieve)IOUtils.readObjectFromURLOrClasspathOrFileSystem(CorefProperties.getPathModel(props, sievename));
                rfsieve.thresMerge = CorefProperties.getMergeThreshold(props, sievename);
                System.err.println("done. Merging threshold: " + rfsieve.thresMerge);
                return rfsieve;
            }
            case ORACLE: {
                OracleSieve oracleSieve = new OracleSieve(props, sievename);
                oracleSieve.props = props;
                return oracleSieve;
            }
        }
        throw new RuntimeException("no sieve type specified");
    }

    public static List<Sieve> loadSieves(Properties props) throws Exception {
        String[] sievenames;
        ArrayList<Sieve> sieves = new ArrayList<Sieve>();
        String sieveProp = CorefProperties.getSieves(props);
        String currentSieveForTrain = CorefProperties.getCurrentSieveForTrain(props);
        for (String sievename : sievenames = currentSieveForTrain == null ? sieveProp.trim().split(",\\s*") : sieveProp.split(currentSieveForTrain)[0].trim().split(",\\s*")) {
            Sieve sieve = Sieve.loadSieve(props, sievename);
            sieves.add(sieve);
        }
        return sieves;
    }

    public static boolean hasThat(List<CoreLabel> words) {
        for (CoreLabel cl : words) {
            if (!cl.word().equalsIgnoreCase("that") || !cl.tag().equalsIgnoreCase("IN")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasToVerb(List<CoreLabel> words) {
        for (int i = 0; i < words.size() - 1; ++i) {
            if (!words.get(i).tag().equals("TO") || !words.get(i + 1).tag().startsWith("V")) continue;
            return true;
        }
        return false;
    }

    private boolean skipMentionType(Mention m, Properties props) {
        return !this.mType.contains((Object)m.mentionType);
    }

    public static void merge(Document document, int mID, int antID) {
        CorefCluster c2;
        CorefCluster c1 = document.corefClusters.get(document.predictedMentionsByID.get((Object)Integer.valueOf((int)mID)).corefClusterID);
        if (c1 == (c2 = document.corefClusters.get(document.predictedMentionsByID.get((Object)Integer.valueOf((int)antID)).corefClusterID))) {
            return;
        }
        int removeID = c1.getClusterID();
        CorefCluster.mergeClusters(c2, c1);
        document.mergeIncompatibles(c2, c1);
        document.corefClusters.remove(removeID);
    }

    public static boolean isReallyCoref(Document document, int mID, int antID) {
        if (!document.goldMentionsByID.containsKey(mID) || !document.goldMentionsByID.containsKey(antID)) {
            return false;
        }
        int mGoldClusterID = document.goldMentionsByID.get((Object)Integer.valueOf((int)mID)).goldCorefClusterID;
        int aGoldClusterID = document.goldMentionsByID.get((Object)Integer.valueOf((int)antID)).goldCorefClusterID;
        return mGoldClusterID == aGoldClusterID;
    }

    protected static boolean skipForAnalysis(Mention ant, Mention m, Properties props) {
        if (!CorefProperties.doAnalysis(props)) {
            return false;
        }
        String skipMentionType = CorefProperties.getSkipMentionType(props);
        String skipAntType = CorefProperties.getSkipAntecedentType(props);
        return Sieve.matchedMentionType(ant, skipAntType) && Sieve.matchedMentionType(m, skipMentionType);
    }

    protected static boolean matchedMentionType(Mention m, Set<String> types) {
        if (types.isEmpty()) {
            return true;
        }
        for (String type : types) {
            if (!Sieve.matchedMentionType(m, type)) continue;
            return true;
        }
        return false;
    }

    protected static boolean matchedMentionType(Mention m, String type) {
        if (type == null) {
            return false;
        }
        if (type.equalsIgnoreCase("all") || type.equalsIgnoreCase(m.mentionType.toString())) {
            return true;
        }
        if (type.equalsIgnoreCase("he") && m.isPronominal() && m.person == Dictionaries.Person.HE) {
            return true;
        }
        if (type.equalsIgnoreCase("she") && m.isPronominal() && m.person == Dictionaries.Person.SHE) {
            return true;
        }
        if (type.equalsIgnoreCase("you") && m.isPronominal() && m.person == Dictionaries.Person.YOU) {
            return true;
        }
        if (type.equalsIgnoreCase("I") && m.isPronominal() && m.person == Dictionaries.Person.I) {
            return true;
        }
        if (type.equalsIgnoreCase("it") && m.isPronominal() && m.person == Dictionaries.Person.IT) {
            return true;
        }
        if (type.equalsIgnoreCase("they") && m.isPronominal() && m.person == Dictionaries.Person.THEY) {
            return true;
        }
        if (type.equalsIgnoreCase("we") && m.isPronominal() && m.person == Dictionaries.Person.WE) {
            return true;
        }
        return type.toLowerCase().startsWith("ne:") && type.toLowerCase().substring(3).startsWith(m.nerString.toLowerCase().substring(0, Math.min(3, m.nerString.length())));
    }

    public static List<Mention> getOrderedAntecedents(Mention m, int antecedentSentence, int mPosition, List<List<Mention>> orderedMentionsBySentence, Dictionaries dict) {
        List<Mention> orderedAntecedents = new ArrayList<Mention>();
        if (antecedentSentence == m.sentNum) {
            orderedAntecedents.addAll(orderedMentionsBySentence.get(m.sentNum).subList(0, mPosition));
            if (dict.relativePronouns.contains(m.spanToString())) {
                Collections.reverse(orderedAntecedents);
            } else {
                orderedAntecedents = Sieve.sortMentionsByClause(orderedAntecedents, m);
            }
        } else {
            orderedAntecedents.addAll((Collection)orderedMentionsBySentence.get(antecedentSentence));
        }
        return orderedAntecedents;
    }

    private static List<Mention> sortMentionsByClause(List<Mention> l, Mention m1) {
        ArrayList<Mention> sorted = new ArrayList<Mention>();
        Tree tree = m1.contextParseTree;
        Tree current = m1.mentionSubTree;
        if (tree == null || current == null) {
            return l;
        }
        do {
            String curLabel;
            if (!"TOP".equals(curLabel = (current = current.ancestor(1, tree)).label().value()) && !curLabel.startsWith("S") && !curLabel.equals("NP")) continue;
            for (Mention m : l) {
                if (sorted.contains(m) || !current.dominates(m.mentionSubTree)) continue;
                sorted.add(m);
            }
        } while (current.ancestor(1, tree) != null);
        return sorted;
    }

    public static enum ClassifierType {
        RULE,
        RF,
        ORACLE;

    }
}

