/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import java.util.List;
import java.util.Set;

public class FinalizeTransition
implements Transition {
    private final Set<String> rootStates;
    private static final long serialVersionUID = 1L;

    public FinalizeTransition(Set<String> rootStates) {
        this.rootStates = rootStates;
    }

    @Override
    public boolean isLegal(State state, List<ParserConstraint> constraints) {
        boolean legal;
        boolean bl = legal = !state.finished && state.tokenPosition >= state.sentence.size() && state.stack.size() == 1 && this.rootStates.contains(state.stack.peek().value());
        if (!legal || constraints == null) {
            return legal;
        }
        for (ParserConstraint constraint : constraints) {
            if (constraint.start != 0 || constraint.end != state.sentence.size() || ShiftReduceUtils.constraintMatchesTreeTop(state.stack.peek(), constraint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public State apply(State state) {
        return this.apply(state, 0.0);
    }

    @Override
    public State apply(State state, double scoreDelta) {
        return new State(state.stack, state.transitions.push(this), state.separators, state.sentence, state.tokenPosition, state.score + scoreDelta, true);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FinalizeTransition;
    }

    public int hashCode() {
        return 593744340;
    }

    public String toString() {
        return "Finalize";
    }
}

