/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.scoref.DocumentProcessor;
import edu.stanford.nlp.scoref.StatisticalCorefTrainer;
import edu.stanford.nlp.scoref.StatisticalCorefUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataWriter
implements DocumentProcessor {
    private final Map<Integer, Map<Integer, String>> mentionTypes;
    private final Map<Integer, List<List<Integer>>> goldClusters;
    private final Counter<String> wordCounts;
    private final Map<Integer, Map<Pair<Integer, Integer>, Boolean>> mentionPairs;
    private final boolean countWords;

    public MetadataWriter(boolean countWords) {
        this.countWords = countWords;
        this.mentionTypes = new HashMap<Integer, Map<Integer, String>>();
        this.goldClusters = new HashMap<Integer, List<List<Integer>>>();
        this.wordCounts = new ClassicCounter<String>();
        try {
            this.mentionPairs = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.datasetFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(int id, Document document) {
        Map<Pair<Integer, Integer>, Boolean> labeledPairs = StatisticalCorefUtils.getUnlabeledMentionPairs(document);
        for (CorefCluster corefCluster : document.goldCorefClusters.values()) {
            ArrayList<Mention> arrayList = new ArrayList<Mention>(corefCluster.getCorefMentions());
            for (int i = 0; i < arrayList.size(); ++i) {
                for (Mention mention : arrayList) {
                    Pair<Integer, Integer> mentionPair = new Pair<Integer, Integer>(((Mention)arrayList.get((int)i)).mentionID, mention.mentionID);
                    if (!labeledPairs.containsKey(mentionPair)) continue;
                    labeledPairs.put(mentionPair, true);
                }
            }
        }
        Map<Pair<Integer, Integer>, Boolean> savedPairs = this.mentionPairs.get(id);
        for (Map.Entry<Pair<Integer, Integer>, Boolean> entry : savedPairs.entrySet()) {
            Pair<Integer, Integer> pair = entry.getKey();
            boolean label = entry.getValue();
            assert ((Integer)pair.first >= 0 && (Integer)pair.second >= 0);
            assert (label == labeledPairs.get(pair));
        }
        this.mentionTypes.put(id, document.predictedMentionsByID.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Mention)e.getValue()).mentionType.toString())));
        ArrayList arrayList = new ArrayList();
        for (CorefCluster c : document.goldCorefClusters.values()) {
            ArrayList<Integer> cluster = new ArrayList<Integer>();
            for (Mention m : c.getCorefMentions()) {
                cluster.add(m.mentionID);
            }
            arrayList.add(cluster);
        }
        this.goldClusters.put(id, arrayList);
        if (this.countWords && this.mentionPairs.containsKey(id)) {
            Set<Pair<Integer, Integer>> set = this.mentionPairs.get(id).keySet();
            HashSet<Object> mentions = new HashSet<Object>();
            for (Pair<Integer, Integer> pair : set) {
                mentions.add(pair.first);
                mentions.add(pair.second);
                Mention m1 = document.predictedMentionsByID.get(pair.first);
                Mention m2 = document.predictedMentionsByID.get(pair.second);
                this.wordCounts.incrementCount("h_" + m1.headWord.word().toLowerCase() + "_" + m2.headWord.word().toLowerCase());
            }
            HashMap<Integer, List<CoreLabel>> sentences = new HashMap<Integer, List<CoreLabel>>();
            Iterator iterator = mentions.iterator();
            while (iterator.hasNext()) {
                int mention = (Integer)iterator.next();
                Mention m = document.predictedMentionsByID.get(mention);
                if (sentences.containsKey(m.sentNum)) continue;
                sentences.put(m.sentNum, m.sentenceWords);
            }
            for (List sentence : sentences.values()) {
                for (int i = 0; i < sentence.size(); ++i) {
                    CoreLabel clp;
                    CoreLabel cl = (CoreLabel)sentence.get(i);
                    if (cl == null) continue;
                    String w = cl.word().toLowerCase();
                    this.wordCounts.incrementCount(w);
                    if (i <= 0 || (clp = (CoreLabel)sentence.get(i - 1)) == null) continue;
                    String wp = clp.word().toLowerCase();
                    this.wordCounts.incrementCount(wp + "_" + w);
                }
            }
        }
    }

    @Override
    public void finish() throws Exception {
        IOUtils.writeObjectToFile(this.mentionTypes, StatisticalCorefTrainer.mentionTypesFile);
        IOUtils.writeObjectToFile(this.goldClusters, StatisticalCorefTrainer.goldClustersFile);
        if (this.countWords) {
            IOUtils.writeObjectToFile(this.wordCounts, StatisticalCorefTrainer.wordCountsFile);
        }
    }
}

