/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.ReaderInputStream;
import edu.stanford.nlp.io.TeeStream;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.stats.PrecisionRecallStats;
import edu.stanford.nlp.time.GUTimeAnnotator;
import edu.stanford.nlp.time.HeidelTimeAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeAnnotator;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.time.XMLUtils;
import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.SystemUtils;
import edu.stanford.nlp.util.ValuedInterval;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SUTimeMain {
    protected static String PYTHON = null;
    private static CoreLabelTokenFactory tokenFactory = new CoreLabelTokenFactory();
    private static String requiredDocDateFormat;
    private static boolean useGUTime;

    private SUTimeMain() {
    }

    private static void processTimebankCsvSent(AnnotationPipeline pipeline, TimebankSent sent, PrintWriter pw, EvalStats evalStats) {
        if (sent != null) {
            Collections.sort(sent.timexes, (o1, o2) -> {
                if (o1.tid == o2.tid) {
                    return 0;
                }
                return o1.tid < o2.tid ? -1 : 1;
            });
            pw.println();
            for (String item : sent.origItems) {
                pw.println("PROC |" + item);
            }
            Annotation annotation = new Annotation(sent.text);
            annotation.set(CoreAnnotations.DocDateAnnotation.class, sent.docPubDate);
            pipeline.annotate(annotation);
            List timexes = (List)annotation.get(TimeAnnotations.TimexAnnotations.class);
            int i = 0;
            for (CoreMap t : timexes) {
                Object[] newFields;
                if (sent.timexes.size() > i) {
                    String res;
                    String s2;
                    TimebankTimex goldTimex = sent.timexes.get(i);
                    Timex guessTimex = (Timex)t.get(TimeAnnotations.TimexAnnotation.class);
                    String s1 = goldTimex.timexStr.replaceAll("\\s+", "");
                    if (s1.equals(s2 = guessTimex.text().replaceAll("\\s+", ""))) {
                        evalStats.estPrStats.incrementTP();
                        res = "OK";
                    } else {
                        evalStats.estPrStats.incrementFP();
                        evalStats.estPrStats.incrementFN();
                        res = "BAD";
                    }
                    newFields = new String[]{res, goldTimex.timexId, goldTimex.timexVal, goldTimex.timexOrigVal, goldTimex.timexStr, ((Timex)t.get(TimeAnnotations.TimexAnnotation.class)).toString()};
                    ++i;
                } else {
                    newFields = new String[]{"NONE", ((Timex)t.get(TimeAnnotations.TimexAnnotation.class)).toString()};
                    evalStats.estPrStats.incrementFP();
                }
                pw.println("GOT | " + StringUtils.join(newFields, "|"));
            }
            while (i < sent.timexes.size()) {
                evalStats.estPrStats.incrementFN();
                ++i;
            }
            i = 0;
            int lastIndex = 0;
            for (TimebankTimex goldTimex : sent.timexes) {
                CoreMap t;
                int index = sent.text.indexOf(goldTimex.timexStr, lastIndex);
                int endIndex = index + goldTimex.timexStr.length();
                boolean found = false;
                while (i < timexes.size() && (Integer)(t = (CoreMap)timexes.get(i)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) < endIndex) {
                    if ((Integer)t.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) >= index) {
                        found = true;
                        evalStats.prStats.incrementTP();
                        if (goldTimex.timexOrigVal.equals(((Timex)t.get(TimeAnnotations.TimexAnnotation.class)).value())) {
                            evalStats.valPrStats.incrementTP();
                        } else {
                            evalStats.valPrStats.incrementFN();
                        }
                    } else {
                        evalStats.prStats.incrementFP();
                        evalStats.valPrStats.incrementFP();
                    }
                    ++i;
                }
                if (!found) {
                    evalStats.prStats.incrementFN();
                    evalStats.valPrStats.incrementFN();
                }
                lastIndex = endIndex;
            }
            while (i < timexes.size()) {
                evalStats.prStats.incrementFP();
                evalStats.valPrStats.incrementFP();
                ++i;
            }
        }
    }

    public static void processTimebankCsv(AnnotationPipeline pipeline, String in, String out2, String eval) throws IOException {
        boolean addOld;
        BufferedReader br = IOUtils.getBufferedFileReader(in);
        PrintWriter pw = out2 != null ? IOUtils.getPrintWriter(out2) : new PrintWriter(System.out);
        boolean dataStarted = true;
        TimebankSent sent = new TimebankSent();
        String item = null;
        EvalStats evalStats = new EvalStats();
        String line = br.readLine();
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (dataStarted) {
                if (line.contains("|")) {
                    if (item != null && !(addOld = sent.add(item))) {
                        SUTimeMain.processTimebankCsvSent(pipeline, sent, pw, evalStats);
                        sent = new TimebankSent();
                        sent.add(item);
                    }
                    item = line;
                    continue;
                }
                item = item + " " + line;
                continue;
            }
            if (!line.matches("#+ BEGIN DATA #+")) continue;
            dataStarted = true;
        }
        if (item != null) {
            addOld = sent.add(item);
            if (!addOld) {
                SUTimeMain.processTimebankCsvSent(pipeline, sent, pw, evalStats);
                sent = new TimebankSent();
                sent.add(item);
            }
            SUTimeMain.processTimebankCsvSent(pipeline, sent, pw, evalStats);
        }
        br.close();
        if (out2 != null) {
            pw.close();
        }
        System.out.println("Estimate: " + evalStats.estPrStats.toString(2));
        System.out.println("Overall: " + evalStats.prStats.toString(2));
        System.out.println("Value: " + evalStats.valPrStats.toString(2));
    }

    public static String joinWordTags(List<? extends CoreMap> l, String glue, int start, int end) {
        return StringUtils.join(l, glue, in -> (String)in.get(CoreAnnotations.TextAnnotation.class) + "/" + (String)in.get(CoreAnnotations.PartOfSpeechAnnotation.class), start, end);
    }

    private static void processTempEval2Doc(AnnotationPipeline pipeline, Annotation docAnnotation, Map<String, List<TimexAttributes>> timexMap, PrintWriter extPw, PrintWriter attrPw, PrintWriter debugPw, PrintWriter attrDebugPwGold, PrintWriter attrDebugPw) {
        Object[] newFields;
        pipeline.annotate(docAnnotation);
        String docId = (String)docAnnotation.get(CoreAnnotations.DocIDAnnotation.class);
        String docDate = (String)docAnnotation.get(CoreAnnotations.DocDateAnnotation.class);
        List sents = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (timexMap != null) {
            List<TimexAttributes> golds = SUTimeMain.updateTimexText(timexMap, docAnnotation);
            if (attrDebugPwGold != null && golds != null) {
                Iterator iterator = golds.iterator();
                while (iterator.hasNext()) {
                    TimexAttributes g = (TimexAttributes)iterator.next();
                    newFields = new String[]{docId, docDate, String.valueOf(g.sentIndex), String.valueOf(g.tokenStart), String.valueOf(g.tokenEnd), g.type, g.value, g.text, g.context};
                    attrDebugPwGold.println(StringUtils.join(newFields, "\t"));
                }
            }
        }
        if (attrDebugPw != null) {
            for (Object sent : sents) {
                List timexes = (List)sent.get(TimeAnnotations.TimexAnnotations.class);
                if (timexes == null) continue;
                for (CoreMap t : timexes) {
                    int tokenEnd;
                    int tokenStart;
                    Timex timex = (Timex)t.get(TimeAnnotations.TimexAnnotation.class);
                    int sentIndex = (Integer)sent.get(CoreAnnotations.SentenceIndexAnnotation.class);
                    int sentTokenStart = (Integer)sent.get(CoreAnnotations.TokenBeginAnnotation.class);
                    if (t.containsKey(CoreAnnotations.TokenBeginAnnotation.class)) {
                        tokenStart = (Integer)t.get(CoreAnnotations.TokenBeginAnnotation.class) - sentTokenStart;
                        tokenEnd = (Integer)t.get(CoreAnnotations.TokenEndAnnotation.class) - sentTokenStart;
                    } else {
                        CoreMap cm = ChunkAnnotationUtils.getAnnotatedChunkUsingCharOffsets(docAnnotation, (Integer)t.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)t.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                        tokenStart = (Integer)cm.get(CoreAnnotations.TokenBeginAnnotation.class) - sentTokenStart;
                        tokenEnd = (Integer)cm.get(CoreAnnotations.TokenEndAnnotation.class) - sentTokenStart;
                    }
                    String context = SUTimeMain.joinWordTags((List)sent.get(CoreAnnotations.TokensAnnotation.class), " ", tokenStart - 3, tokenEnd + 3);
                    Object[] newFields2 = new String[]{docId, docDate, String.valueOf(sentIndex), String.valueOf(tokenStart), String.valueOf(tokenEnd), timex.timexType(), timex.value(), timex.text(), context};
                    attrDebugPw.println(StringUtils.join(newFields2, "\t"));
                }
            }
        }
        if (debugPw != null) {
            List timexes = (List)docAnnotation.get(TimeAnnotations.TimexAnnotations.class);
            for (CoreMap t : timexes) {
                newFields = new String[]{docId, docDate, ((Timex)t.get(TimeAnnotations.TimexAnnotation.class)).toString()};
                debugPw.println("GOT | " + StringUtils.join(newFields, "|"));
            }
        }
        if (extPw != null || attrPw != null) {
            for (Object sent : sents) {
                int sentTokenBegin = (Integer)sent.get(CoreAnnotations.TokenBeginAnnotation.class);
                for (CoreMap t : (List)sent.get(TimeAnnotations.TimexAnnotations.class)) {
                    Timex tmx = (Timex)t.get(TimeAnnotations.TimexAnnotation.class);
                    List tokens = (List)t.get(CoreAnnotations.TokensAnnotation.class);
                    int tokenIndex = 0;
                    if (tokens == null) {
                        CoreMap cm = ChunkAnnotationUtils.getAnnotatedChunkUsingCharOffsets(docAnnotation, (Integer)t.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)t.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                        tokens = (List)cm.get(CoreAnnotations.TokensAnnotation.class);
                        tokenIndex = (Integer)cm.get(CoreAnnotations.TokenBeginAnnotation.class);
                    } else {
                        tokenIndex = (Integer)t.get(CoreAnnotations.TokenBeginAnnotation.class);
                    }
                    tokenIndex -= sentTokenBegin;
                    String sentenceIndex = String.valueOf(sent.get(CoreAnnotations.SentenceIndexAnnotation.class));
                    int tokenCount = 0;
                    for (CoreLabel token : tokens) {
                        Object[] extFields = new String[]{docId, sentenceIndex, String.valueOf(tokenIndex), "timex3", tmx.tid(), "1"};
                        String extString = StringUtils.join(extFields, "\t");
                        if (extPw != null) {
                            extPw.println(extString);
                        }
                        if (attrPw != null) {
                            Object[] attrFields = new String[]{"type", tmx.timexType()};
                            attrPw.println(extString + "\t" + StringUtils.join(attrFields, "\t"));
                            if (tmx.value() != null) {
                                String val = tmx.value();
                                if (useGUTime) {
                                    if ("TIME".equals(tmx.timexType())) {
                                        if (val.matches("T\\d{4}")) {
                                            val = "T" + val.substring(1, 3) + ":" + val.substring(3, 5);
                                        }
                                    } else if ("DATE".equals(tmx.timexType())) {
                                        if (val.matches("\\d{8}T.*")) {
                                            val = val.substring(0, 4) + "-" + val.substring(4, 6) + "-" + val.substring(6);
                                        } else if (val.matches("\\d{8}")) {
                                            val = val.substring(0, 4) + "-" + val.substring(4, 6) + "-" + val.substring(6, 8);
                                        } else if (val.matches("\\d\\d\\d\\d..")) {
                                            val = val.substring(0, 4) + "-" + val.substring(4, 6);
                                        } else if (val.matches("[0-9X]{4}W[0-9X]{2}.*")) {
                                            val = val.length() > 7 ? val.substring(0, 4) + "-" + val.substring(4, 7) + "-" + val.substring(7) : val.substring(0, 4) + "-" + val.substring(4, 7);
                                        }
                                    }
                                }
                                attrFields[0] = "value";
                                attrFields[1] = val;
                                attrPw.println(extString + "\t" + StringUtils.join(attrFields, "\t"));
                            }
                        }
                        ++tokenIndex;
                        ++tokenCount;
                    }
                }
            }
        }
    }

    private static CoreMap wordsToSentence(List<String> sentWords) {
        String sentText = StringUtils.join(sentWords, " ");
        Annotation sentence = new Annotation(sentText);
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(sentWords.size());
        for (String text : sentWords) {
            CoreLabel token = tokenFactory.makeToken();
            token.set(CoreAnnotations.TextAnnotation.class, text);
            tokens.add(token);
        }
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        return sentence;
    }

    public static Annotation sentencesToDocument(String documentID, String docDate, List<CoreMap> sentences) {
        String docText = ChunkAnnotationUtils.getTokenText(sentences, CoreAnnotations.TextAnnotation.class);
        Annotation document = new Annotation(docText);
        document.set(CoreAnnotations.DocIDAnnotation.class, documentID);
        document.set(CoreAnnotations.DocDateAnnotation.class, docDate);
        document.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        ArrayList docTokens = new ArrayList();
        int sentenceIndex = 0;
        int tokenBegin = 0;
        for (CoreMap sentenceAnnotation : sentences) {
            List sentenceTokens = (List)sentenceAnnotation.get(CoreAnnotations.TokensAnnotation.class);
            docTokens.addAll(sentenceTokens);
            int tokenEnd = tokenBegin + sentenceTokens.size();
            sentenceAnnotation.set(CoreAnnotations.TokenBeginAnnotation.class, tokenBegin);
            sentenceAnnotation.set(CoreAnnotations.TokenEndAnnotation.class, tokenEnd);
            sentenceAnnotation.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
            ++sentenceIndex;
            tokenBegin = tokenEnd;
        }
        document.set(CoreAnnotations.TokensAnnotation.class, docTokens);
        int i = 0;
        for (CoreLabel token : docTokens) {
            String tokenText = (String)token.get(CoreAnnotations.TextAnnotation.class);
            token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, i);
            token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, i += tokenText.length());
            ++i;
        }
        for (CoreMap sentenceAnnotation : sentences) {
            List sentenceTokens = (List)sentenceAnnotation.get(CoreAnnotations.TokensAnnotation.class);
            sentenceAnnotation.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, ((CoreLabel)sentenceTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
            sentenceAnnotation.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, ((CoreLabel)sentenceTokens.get(sentenceTokens.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        }
        return document;
    }

    private static TimexAttributes findTimex(Map<String, List<TimexAttributes>> timexMap, String docId, String tid) {
        List<TimexAttributes> list = timexMap.get(docId);
        for (TimexAttributes timex : list) {
            if (!timex.tid.equals(tid)) continue;
            return timex;
        }
        return null;
    }

    private static List<TimexAttributes> updateTimexText(Map<String, List<TimexAttributes>> timexMap, Annotation docAnnotation) {
        String docId = (String)docAnnotation.get(CoreAnnotations.DocIDAnnotation.class);
        List sents = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        List<TimexAttributes> list = timexMap.get(docId);
        if (list != null) {
            for (TimexAttributes timex : list) {
                CoreMap sent = (CoreMap)sents.get(timex.sentIndex);
                List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
                timex.text = StringUtils.joinWords(tokens, " ", timex.tokenStart, timex.tokenEnd);
                timex.context = SUTimeMain.joinWordTags(tokens, " ", timex.tokenStart - 3, timex.tokenEnd + 3);
            }
            return list;
        }
        return null;
    }

    private static Map<String, List<TimexAttributes>> readTimexAttrExts(String extentsFile, String attrsFile) throws IOException {
        String line;
        Map<String, List<TimexAttributes>> timexMap = Generics.newHashMap();
        BufferedReader extBr = IOUtils.getBufferedFileReader(extentsFile);
        String lastDocId = null;
        TimexAttributes lastTimex = null;
        while ((line = extBr.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String[] fields = line.split("\t");
            String docName = fields[0];
            int sentNo = Integer.parseInt(fields[1]);
            int tokenNo = Integer.parseInt(fields[2]);
            String tid = fields[4];
            if (lastDocId != null && lastDocId.equals(docName) && lastTimex != null && lastTimex.tid.equals(tid)) {
                assert (lastTimex.sentIndex == sentNo);
                lastTimex.tokenEnd = tokenNo + 1;
                continue;
            }
            lastDocId = docName;
            lastTimex = new TimexAttributes(tid, sentNo, tokenNo);
            List<TimexAttributes> list = timexMap.get(docName);
            if (list == null) {
                list = new ArrayList<TimexAttributes>();
                timexMap.put(docName, list);
            }
            list.add(lastTimex);
        }
        extBr.close();
        BufferedReader attrBr = IOUtils.getBufferedFileReader(attrsFile);
        block9: while ((line = attrBr.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String[] fields = line.split("\t");
            String docName = fields[0];
            int sentNo = Integer.parseInt(fields[1]);
            int tokenNo = Integer.parseInt(fields[2]);
            String tid = fields[4];
            String attrname = fields[6];
            String attrvalue = fields[7];
            TimexAttributes timex = SUTimeMain.findTimex(timexMap, docName, tid);
            assert (timex.sentIndex == sentNo);
            assert (timex.tokenStart <= tokenNo && timex.tokenEnd > tokenNo);
            switch (attrname) {
                case "type": {
                    assert (timex.type == null || timex.type.equals(attrvalue));
                    timex.type = attrvalue;
                    continue block9;
                }
                case "value": {
                    assert (timex.value == null || timex.value.equals(attrvalue));
                    timex.value = attrvalue;
                    continue block9;
                }
            }
            throw new RuntimeException("Error processing " + attrsFile + ":" + "Unknown attribute " + attrname + ": from line " + line);
        }
        attrBr.close();
        return timexMap;
    }

    public static void processTempEval2Tab(AnnotationPipeline pipeline, String in, String out2, Map<String, String> docDates) throws IOException {
        String line;
        Map<String, List<TimexAttributes>> timexMap = SUTimeMain.readTimexAttrExts(in + "/timex-extents.tab", in + "/timex-attributes.tab");
        BufferedReader br = IOUtils.getBufferedFileReader(in + "/base-segmentation.tab");
        PrintWriter debugPw = IOUtils.getPrintWriter(out2 + "/timex-debug.out");
        PrintWriter attrPw = IOUtils.getPrintWriter(out2 + "/timex-attrs.res.tab");
        PrintWriter extPw = IOUtils.getPrintWriter(out2 + "/timex-extents.res.tab");
        PrintWriter attrDebugPwGold = IOUtils.getPrintWriter(out2 + "/timex-attrs.debug.gold.tab");
        PrintWriter attrDebugPw = IOUtils.getPrintWriter(out2 + "/timex-attrs.debug.res.tab");
        String curDocName = null;
        int curSentNo = -1;
        ArrayList<String> tokens = null;
        ArrayList<CoreMap> sentences = null;
        while ((line = br.readLine()) != null) {
            CoreMap lastSentence;
            if (line.trim().length() == 0) continue;
            String[] fields = line.split("\t");
            String docName = fields[0];
            int sentNo = Integer.parseInt(fields[1]);
            String tokenText = fields[3];
            if (!docName.equals(curDocName)) {
                if (curDocName != null) {
                    lastSentence = SUTimeMain.wordsToSentence(tokens);
                    sentences.add(lastSentence);
                    Annotation docAnnotation = SUTimeMain.sentencesToDocument(curDocName, docDates.get(curDocName), sentences);
                    SUTimeMain.processTempEval2Doc(pipeline, docAnnotation, timexMap, extPw, attrPw, debugPw, attrDebugPwGold, attrDebugPw);
                    curDocName = null;
                }
                tokens = new ArrayList<String>();
                sentences = new ArrayList<CoreMap>();
            } else if (curSentNo != sentNo) {
                lastSentence = SUTimeMain.wordsToSentence(tokens);
                sentences.add(lastSentence);
                tokens = new ArrayList();
            }
            tokens.add(tokenText);
            curDocName = docName;
            curSentNo = sentNo;
        }
        if (curDocName != null) {
            CoreMap lastSentence = SUTimeMain.wordsToSentence(tokens);
            sentences.add(lastSentence);
            Annotation docAnnotation = SUTimeMain.sentencesToDocument(curDocName, docDates.get(curDocName), (List<CoreMap>)sentences);
            SUTimeMain.processTempEval2Doc(pipeline, docAnnotation, timexMap, extPw, attrPw, debugPw, attrDebugPwGold, attrDebugPw);
            curDocName = null;
        }
        br.close();
        extPw.close();
        attrPw.close();
        debugPw.close();
        attrDebugPwGold.close();
        attrDebugPw.close();
    }

    public static void processTempEval2(AnnotationPipeline pipeline, String in, String out2, String eval, String dct) throws IOException, ParseException {
        Map<String, String> docDates;
        Map<String, String> map = docDates = dct != null ? IOUtils.readMap(dct) : IOUtils.readMap(in + "/dct.txt");
        if (requiredDocDateFormat != null) {
            SimpleDateFormat defaultFormatter = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat requiredFormatter = new SimpleDateFormat(requiredDocDateFormat);
            for (String docId : docDates.keySet()) {
                Date date = defaultFormatter.parse(docDates.get(docId));
                docDates.put(docId, requiredFormatter.format(date));
            }
        }
        SUTimeMain.processTempEval2Tab(pipeline, in, out2, docDates);
        if (eval != null) {
            ArrayList<String> command = new ArrayList<String>();
            if (PYTHON != null) {
                command.add(PYTHON);
            }
            command.add(eval);
            command.add(in + "/base-segmentation.tab");
            command.add(in + "/timex-extents.tab");
            command.add(out2 + "/timex-extents.res.tab");
            command.add(in + "/timex-attributes.tab");
            command.add(out2 + "/timex-attrs.res.tab");
            ProcessBuilder pb = new ProcessBuilder(command);
            FileOutputStream evalFileOutput = new FileOutputStream(out2 + "/scores.txt");
            OutputStreamWriter output = new OutputStreamWriter(new TeeStream(System.out, evalFileOutput));
            SystemUtils.run(pb, output, null);
            evalFileOutput.close();
        }
    }

    public static void processTempEval3(AnnotationPipeline pipeline, String in, String out2, String evalCmd) throws Exception {
        File inFile = new File(in);
        if (inFile.isDirectory()) {
            Pattern teinputPattern = Pattern.compile("\\.(TE3input|tml)$");
            Iterable<File> files = IOUtils.iterFilesRecursive(inFile, teinputPattern);
            File outDir = new File(out2);
            outDir.mkdirs();
            for (File file : files) {
                String inputFilename = file.getAbsolutePath();
                String outputFilename = inputFilename.replace(in, out2).replace(".TE3input", "");
                if (!outputFilename.equalsIgnoreCase(inputFilename)) {
                    SUTimeMain.processTempEval3File(pipeline, inputFilename, outputFilename);
                    continue;
                }
                System.err.println("ABORTING: Input file and output is the same - " + inputFilename);
                System.exit(-1);
            }
        } else {
            SUTimeMain.processTempEval3File(pipeline, in, out2);
        }
        if (evalCmd != null) {
            // empty if block
        }
    }

    public static void processTempEval3File(AnnotationPipeline pipeline, String in, String out2) throws Exception {
        Document doc = edu.stanford.nlp.util.XMLUtils.readDocumentFromFile(in);
        Node timemlNode = XMLUtils.getNode((Node)doc, "TimeML");
        Node docIdNode = XMLUtils.getNode(timemlNode, "DOCID");
        Node dctNode = XMLUtils.getNode(timemlNode, "DCT");
        Node dctTimexNode = XMLUtils.getNode(dctNode, "TIMEX3");
        Node titleNode = XMLUtils.getNode(timemlNode, "TITLE");
        Node extraInfoNode = XMLUtils.getNode(timemlNode, "EXTRA_INFO");
        Node textNode = XMLUtils.getNode(timemlNode, "TEXT");
        String date = XMLUtils.getAttributeValue(dctTimexNode, "value");
        String text = textNode.getTextContent();
        Annotation annotation = SUTimeMain.textToAnnotation(pipeline, text, date);
        Element annotatedTextElem = SUTimeMain.annotationToTmlTextElement(annotation);
        Document annotatedDoc = XMLUtils.createDocument();
        Node newTimemlNode = annotatedDoc.importNode(timemlNode, false);
        if (docIdNode != null) {
            newTimemlNode.appendChild(annotatedDoc.importNode(docIdNode, true));
        }
        newTimemlNode.appendChild(annotatedDoc.importNode(dctNode, true));
        if (titleNode != null) {
            newTimemlNode.appendChild(annotatedDoc.importNode(titleNode, true));
        }
        if (extraInfoNode != null) {
            newTimemlNode.appendChild(annotatedDoc.importNode(extraInfoNode, true));
        }
        newTimemlNode.appendChild(annotatedDoc.adoptNode(annotatedTextElem));
        annotatedDoc.appendChild(newTimemlNode);
        PrintWriter pw = out2 != null ? IOUtils.getPrintWriter(out2) : new PrintWriter(System.out);
        String string = XMLUtils.documentToString(annotatedDoc);
        pw.println(string);
        pw.flush();
        if (out2 != null) {
            pw.close();
        }
    }

    public static AnnotationPipeline getPipeline(Properties props, boolean tokenize) throws Exception {
        String timeAnnotator;
        AnnotationPipeline pipeline = new AnnotationPipeline();
        if (tokenize) {
            pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
            pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
        }
        pipeline.addAnnotator(new POSTaggerAnnotator(false));
        switch (timeAnnotator = props.getProperty("timeAnnotator", "sutime")) {
            case "gutime": {
                useGUTime = true;
                pipeline.addAnnotator(new GUTimeAnnotator("gutime", props));
                break;
            }
            case "heideltime": {
                requiredDocDateFormat = "yyyy-MM-dd";
                pipeline.addAnnotator(new HeidelTimeAnnotator("heideltime", props));
                break;
            }
            case "sutime": {
                pipeline.addAnnotator(new TimeAnnotator("sutime", props));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown timeAnnotator: " + timeAnnotator);
            }
        }
        return pipeline;
    }

    public static void configLogger(String out2) throws IOException {
        File outDir = new File(out2);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("handlers=java.util.logging.ConsoleHandler, java.util.logging.FileHandler\n");
        sb.append(".level=SEVERE\n");
        sb.append("edu.stanford.nlp.level=INFO\n");
        sb.append("java.util.logging.ConsoleHandler.level=SEVERE\n");
        sb.append("java.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n");
        sb.append("java.util.logging.FileHandler.level=INFO\n");
        sb.append("java.util.logging.FileHandler.pattern=" + out2 + "/err.log" + "\n");
        LogManager.getLogManager().readConfiguration(new ReaderInputStream(new StringReader(sb.toString())));
    }

    private static List<Node> createTimexNodes(String str, Integer charBeginOffset, List<CoreMap> timexAnns) {
        ArrayList<ValuedInterval<CoreMap, Integer>> timexList = new ArrayList<ValuedInterval<CoreMap, Integer>>(timexAnns.size());
        for (CoreMap timexAnn : timexAnns) {
            timexList.add(new ValuedInterval<CoreMap, Integer>(timexAnn, MatchedExpression.COREMAP_TO_CHAR_OFFSETS_INTERVAL_FUNC.apply(timexAnn)));
        }
        Collections.sort(timexList, HasInterval.CONTAINS_FIRST_ENDPOINTS_COMPARATOR);
        return SUTimeMain.createTimexNodesPresorted(str, charBeginOffset, timexList);
    }

    private static List<Node> createTimexNodesPresorted(String str, Integer charBeginOffset, List<ValuedInterval<CoreMap, Integer>> timexList) {
        Element timexElem;
        if (charBeginOffset == null) {
            charBeginOffset = 0;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        int previousEnd = 0;
        ArrayList<Element> timexElems = new ArrayList<Element>();
        ArrayList<ValuedInterval<CoreMap, Integer>> processed = new ArrayList<ValuedInterval<CoreMap, Integer>>();
        CollectionValuedMap unprocessed = new CollectionValuedMap(CollectionFactory.arrayListFactory());
        for (ValuedInterval<CoreMap, Integer> v : timexList) {
            CoreMap timexAnn = v.getValue();
            int begin = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) - charBeginOffset;
            int end = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) - charBeginOffset;
            if (begin >= previousEnd) {
                nodes.add(XMLUtils.createTextNode(str.substring(previousEnd, begin)));
                Timex timex = (Timex)timexAnn.get(TimeAnnotations.TimexAnnotation.class);
                timexElem = timex.toXmlElement();
                nodes.add(timexElem);
                previousEnd = end;
                processed.add(v);
                timexElems.add(timexElem);
                continue;
            }
            unprocessed.add(processed.size() - 1, v);
        }
        if (previousEnd < str.length()) {
            nodes.add(XMLUtils.createTextNode(str.substring(previousEnd)));
        }
        for (Integer i : unprocessed.keySet()) {
            ValuedInterval v = (ValuedInterval)processed.get(i);
            String elemStr = (String)((CoreMap)v.getValue()).get(CoreAnnotations.TextAnnotation.class);
            int charStart = (Integer)((CoreMap)v.getValue()).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            List<Node> innerElems = SUTimeMain.createTimexNodesPresorted(elemStr, charStart, (List)unprocessed.get(i));
            timexElem = (Element)timexElems.get(i);
            XMLUtils.removeChildren(timexElem);
            for (Node n : innerElems) {
                timexElem.appendChild(n);
            }
        }
        return nodes;
    }

    public static void processTextFile(AnnotationPipeline pipeline, String in, String out2, String date) throws IOException {
        String text = IOUtils.slurpFile(in);
        PrintWriter pw = out2 != null ? IOUtils.getPrintWriter(out2) : new PrintWriter(System.out);
        String string = SUTimeMain.textToAnnotatedXml(pipeline, text, date);
        pw.println(string);
        pw.flush();
        if (out2 != null) {
            pw.close();
        }
    }

    public static void processText(AnnotationPipeline pipeline, String text, String out2, String date) throws IOException {
        PrintWriter pw = out2 != null ? IOUtils.getPrintWriter(out2) : new PrintWriter(System.out);
        String string = SUTimeMain.textToAnnotatedXml(pipeline, text, date);
        pw.println(string);
        pw.flush();
        if (out2 != null) {
            pw.close();
        }
    }

    public static String textToAnnotatedXml(AnnotationPipeline pipeline, String text, String date) {
        Annotation annotation = SUTimeMain.textToAnnotation(pipeline, text, date);
        Document xmlDoc = SUTimeMain.annotationToXmlDocument(annotation);
        return XMLUtils.documentToString(xmlDoc);
    }

    public static Element annotationToTmlTextElement(Annotation annotation) {
        List timexAnnsAll = (List)annotation.get(TimeAnnotations.TimexAnnotations.class);
        Element textElem = XMLUtils.createElement("TEXT");
        List<Node> timexNodes = SUTimeMain.createTimexNodes((String)annotation.get(CoreAnnotations.TextAnnotation.class), (Integer)annotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), timexAnnsAll);
        for (Node node : timexNodes) {
            textElem.appendChild(node);
        }
        return textElem;
    }

    public static Document annotationToXmlDocument(Annotation annotation) {
        Element dateElem = XMLUtils.createElement("DATE");
        dateElem.setTextContent((String)annotation.get(CoreAnnotations.DocDateAnnotation.class));
        Element textElem = SUTimeMain.annotationToTmlTextElement(annotation);
        Element docElem = XMLUtils.createElement("DOC");
        docElem.appendChild(dateElem);
        docElem.appendChild(textElem);
        Document doc = XMLUtils.createDocument();
        doc.appendChild(doc.importNode(docElem, true));
        return doc;
    }

    public static Annotation textToAnnotation(AnnotationPipeline pipeline, String text, String date) {
        Annotation annotation = new Annotation(text);
        annotation.set(CoreAnnotations.DocDateAnnotation.class, date);
        pipeline.annotate(annotation);
        return annotation;
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        String in = props.getProperty("i");
        String date = props.getProperty("date");
        String dct = props.getProperty("tempeval2.dct");
        String out2 = props.getProperty("o");
        String inputTypeStr = props.getProperty("in.type", InputType.TEXT.name());
        String eval = props.getProperty("eval");
        PYTHON = props.getProperty("python", PYTHON);
        InputType inputType = InputType.valueOf(inputTypeStr);
        switch (inputType) {
            case TEXT: {
                AnnotationPipeline pipeline = SUTimeMain.getPipeline(props, true);
                SUTimeMain.processText(pipeline, in, out2, date);
                break;
            }
            case TEXTFILE: {
                AnnotationPipeline pipeline = SUTimeMain.getPipeline(props, true);
                SUTimeMain.processTextFile(pipeline, in, out2, date);
                break;
            }
            case TIMEBANK_CSV: {
                SUTimeMain.configLogger(out2);
                AnnotationPipeline pipeline = SUTimeMain.getPipeline(props, true);
                SUTimeMain.processTimebankCsv(pipeline, in, out2, eval);
                break;
            }
            case TEMPEVAL2: {
                SUTimeMain.configLogger(out2);
                AnnotationPipeline pipeline = SUTimeMain.getPipeline(props, false);
                SUTimeMain.processTempEval2(pipeline, in, out2, eval, dct);
                break;
            }
            case TEMPEVAL3: {
                AnnotationPipeline pipeline = SUTimeMain.getPipeline(props, true);
                SUTimeMain.processTempEval3(pipeline, in, out2, eval);
            }
        }
    }

    static {
        useGUTime = false;
    }

    static enum InputType {
        TEXTFILE,
        TEXT,
        TIMEBANK_CSV,
        TEMPEVAL2,
        TEMPEVAL3;

    }

    private static class TimexAttributes {
        public String tid;
        public int sentIndex;
        public int tokenStart;
        public int tokenEnd;
        public String text;
        public String type;
        public String value;
        public String context;

        public TimexAttributes(String tid, int sentIndex, int tokenIndex) {
            this.tid = tid;
            this.sentIndex = sentIndex;
            this.tokenStart = tokenIndex;
            this.tokenEnd = tokenIndex + 1;
        }
    }

    private static class TimebankSent {
        boolean initialized = false;
        String docId;
        String docFilename;
        String docPubDate;
        String sentId;
        String text;
        List<TimebankTimex> timexes = new ArrayList<TimebankTimex>();
        List<String> origItems = new ArrayList<String>();

        private TimebankSent() {
        }

        public boolean add(String item) {
            String[] fields = item.split("\\s*\\|\\s*", 9);
            String docId = fields[0];
            String docFilename = fields[1];
            String docPubDate = fields[2];
            String sentId = fields[3];
            String sent = fields[8];
            if (this.initialized) {
                if (!docId.equals(this.docId) || !sentId.equals(this.sentId)) {
                    return false;
                }
            } else {
                this.docId = docId;
                this.docFilename = docFilename;
                this.docPubDate = docPubDate;
                this.sentId = sentId;
                this.text = sent;
                this.initialized = true;
            }
            this.origItems.add(item);
            String timexId = fields[4];
            String timexVal = fields[5];
            String timexOrigVal = fields[6];
            String timexStr = fields[7];
            if (timexId != null && timexId.length() > 0) {
                this.timexes.add(new TimebankTimex(timexId, timexVal, timexOrigVal, timexStr));
            }
            return true;
        }
    }

    private static class TimebankTimex {
        String timexId;
        String timexVal;
        String timexOrigVal;
        String timexStr;
        int tid;

        private TimebankTimex(String timexId, String timexVal, String timexOrigVal, String timexStr) {
            this.timexId = timexId;
            this.timexVal = timexVal;
            this.timexOrigVal = timexOrigVal;
            this.timexStr = timexStr;
            if (timexId != null && timexId.length() > 0) {
                this.tid = Integer.parseInt(timexId);
            }
        }
    }

    private static class EvalStats {
        PrecisionRecallStats prStats = new PrecisionRecallStats();
        PrecisionRecallStats valPrStats = new PrecisionRecallStats();
        PrecisionRecallStats estPrStats = new PrecisionRecallStats();

        private EvalStats() {
        }
    }
}

