/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeNormalizer;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ATBTreeUtils {
    private static final Predicate<Tree> emptyFilter = new ArabicTreeNormalizer.ArabicEmptyFilter();
    private static final TreeFactory tf = new LabeledScoredTreeFactory();
    public static String segMarker = "-";
    public static final String morphBoundary = "+";
    public static final String puncTag = "PUNC";
    private static final String reservedWordList = "-PLUS- -LRB- -RRB-";
    public static final Set<String> reservedWords = Generics.newHashSet();

    private ATBTreeUtils() {
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\(", "-LRB-");
        s = s.replaceAll("\\)", "-RRB-");
        s = s.replaceAll("\\+", "-PLUS-");
        return s;
    }

    public static String unEscape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("-LRB-", "(");
        s = s.replaceAll("-RRB-", ")");
        s = s.replaceAll("-PLUS-", morphBoundary);
        return s;
    }

    public static String flattenTree(Tree t) {
        t = t.prune(emptyFilter, tf);
        String flatString = Sentence.listToString(t.yield());
        return flatString;
    }

    public static String taggedStringFromTree(Tree t, boolean removeEscaping, String separator) {
        t = t.prune(emptyFilter, tf);
        List<CoreLabel> taggedSentence = t.taggedLabeledYield();
        for (CoreLabel token : taggedSentence) {
            String word = removeEscaping ? ATBTreeUtils.unEscape(token.word()) : token.word();
            token.setWord(word);
            token.setValue(word);
        }
        return Sentence.listToString(taggedSentence, false, separator);
    }

    public static void main(String[] args) {
        String debug = "( the big lion ) + (the small rabbit)";
        String escaped = ATBTreeUtils.escape(debug);
        System.out.println(escaped);
    }

    static {
        reservedWords.addAll(Arrays.asList(reservedWordList.split("\\s+")));
    }
}

