/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.wordseg.CorpusChar;
import edu.stanford.nlp.wordseg.affDict;

class TagAffixDetector {
    private CorpusChar cc;
    private affDict aD;
    private String corporaDict = "/u/nlp/data/gale/segtool/stanford-seg/data";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TagAffixDetector(SeqClassifierFlags flags) {
        String adPath;
        String ccPath;
        if (flags.sighanCorporaDict != null) {
            this.corporaDict = flags.sighanCorporaDict;
        }
        if (!this.corporaDict.equals("") && !this.corporaDict.endsWith("/")) {
            this.corporaDict = this.corporaDict + "/";
        }
        if (flags.useChPos || flags.useCTBChar2 || flags.usePKChar2) {
            if (flags.useASBCChar2 || flags.useHKChar2 || flags.useMSRChar2) {
                throw new RuntimeException("only support settings for CTB and PK now.");
            }
            if (flags.useCTBChar2) {
                ccPath = this.corporaDict + "dict/character_list";
                adPath = this.corporaDict + "dict/in.ctb";
            } else {
                if (!flags.usePKChar2) throw new RuntimeException("none of flags.useXXXChar2 are on");
                ccPath = this.corporaDict + "dict/pos_open/character_list.pku.utf8";
                adPath = this.corporaDict + "dict/in.pk";
            }
        } else {
            ccPath = this.corporaDict + "dict/pos_close/char.ctb.list";
            adPath = this.corporaDict + "dict/in.ctb";
        }
        System.err.println("INFO: TagAffixDetector: useChPos=" + flags.useChPos + " | useCTBChar2=" + flags.useCTBChar2 + " | usePKChar2=" + flags.usePKChar2);
        System.err.println("INFO: TagAffixDetector: building TagAffixDetector from " + ccPath + " and " + adPath);
        this.cc = new CorpusChar(ccPath);
        this.aD = new affDict(adPath);
    }

    String checkDic(String t2, String c2) {
        if (this.cc.getTag(t2, c2).equals("1")) {
            return "1";
        }
        return "0";
    }

    String checkInDic(String c2) {
        if (this.aD.getInDict(c2).equals("1")) {
            return "1";
        }
        return "0";
    }
}

