/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolver;

public class LinearSolverSafe<T extends Matrix64F>
implements LinearSolver<T> {
    private LinearSolver<T> alg;
    private T A;
    private T B;

    public LinearSolverSafe(LinearSolver<T> alg) {
        this.alg = alg;
    }

    @Override
    public boolean setA(T A) {
        if (this.alg.modifiesA()) {
            if (this.A == null) {
                this.A = ((Matrix64F)A).copy();
            } else {
                if (((Matrix64F)this.A).numRows != ((Matrix64F)A).numRows || ((Matrix64F)this.A).numCols != ((Matrix64F)A).numCols) {
                    ((Matrix64F)this.A).reshape(((Matrix64F)A).numRows, ((Matrix64F)A).numCols, false);
                }
                ((Matrix64F)this.A).set((Matrix64F)A);
            }
            return this.alg.setA(this.A);
        }
        return this.alg.setA(A);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(T B, T X) {
        if (this.alg.modifiesB()) {
            if (this.B == null) {
                this.B = ((Matrix64F)B).copy();
            } else {
                if (((Matrix64F)this.B).numRows != ((Matrix64F)B).numRows || ((Matrix64F)this.B).numCols != ((Matrix64F)B).numCols) {
                    ((Matrix64F)this.B).reshape(((Matrix64F)this.A).numRows, ((Matrix64F)B).numCols, false);
                }
                ((Matrix64F)this.B).set((Matrix64F)B);
            }
            B = this.B;
        }
        this.alg.solve(B, X);
    }

    @Override
    public void invert(T A_inv) {
        this.alg.invert(A_inv);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

